/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.core.Ownable;
import mods.railcraft.util.JsonUtil;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import org.jetbrains.annotations.Nullable;

public final class MinecartPredicate {
    public static final MinecartPredicate ANY = new MinecartPredicate(null, null, null, null, null, null, MinMaxBounds.Doubles.f_154779_, EntityPredicate.f_36550_);
    @Nullable
    private final Boolean highSpeed;
    @Nullable
    private final Boolean launched;
    @Nullable
    private final Boolean onElevator;
    @Nullable
    private final Boolean derailed;
    @Nullable
    private final Boolean mountable;
    @Nullable
    private final Boolean checksOwner;
    private final MinMaxBounds.Doubles speed;
    private final EntityPredicate parent;

    public MinecartPredicate(@Nullable Boolean highSpeed, @Nullable Boolean launched, @Nullable Boolean elevator, @Nullable Boolean derailed, @Nullable Boolean mountable, @Nullable Boolean checkOwner, MinMaxBounds.Doubles speed, EntityPredicate parent) {
        this.highSpeed = highSpeed;
        this.launched = launched;
        this.onElevator = elevator;
        this.derailed = derailed;
        this.mountable = mountable;
        this.checksOwner = checkOwner;
        this.speed = speed;
        this.parent = parent;
    }

    public boolean test(ServerPlayer player, AbstractMinecart cart) {
        RollingStock rollingStock = RollingStock.getOrThrow(cart);
        if (this.highSpeed != null && rollingStock.isHighSpeed() != this.highSpeed.booleanValue()) {
            return false;
        }
        if (this.launched != null && rollingStock.isLaunched() != this.launched.booleanValue()) {
            return false;
        }
        if (this.onElevator != null && rollingStock.isOnElevator() != this.onElevator.booleanValue()) {
            return false;
        }
        if (this.derailed != null && rollingStock.isDerailed() != this.derailed.booleanValue()) {
            return false;
        }
        if (this.mountable != null && rollingStock.isMountable() != this.mountable.booleanValue()) {
            return false;
        }
        if (this.checksOwner != null && cart instanceof Ownable && ((Ownable)cart).getOwner().map(owner -> !owner.equals((Object)player.m_36316_())).orElse(false).booleanValue()) {
            return false;
        }
        if (!this.speed.m_154812_(MinecartUtil.getCartSpeedUncappedSquared(cart.m_20184_()))) {
            return false;
        }
        return this.parent.m_36611_(player, (Entity)cart);
    }

    private void addOptionalBoolean(JsonObject json, String name, @Nullable Boolean value) {
        if (value != null) {
            json.addProperty(name, value);
        }
    }

    public JsonElement serializeToJson() {
        JsonObject json = new JsonObject();
        this.addOptionalBoolean(json, "high_speed", this.highSpeed);
        this.addOptionalBoolean(json, "launched", this.launched);
        this.addOptionalBoolean(json, "on_elevator", this.onElevator);
        this.addOptionalBoolean(json, "derailed", this.derailed);
        this.addOptionalBoolean(json, "mountable", this.mountable);
        this.addOptionalBoolean(json, "check_owner", this.checksOwner);
        json.add("speed", this.speed.m_55328_());
        json.add("parent", this.parent.m_36606_());
        return json;
    }

    public static MinecartPredicate deserialize(@Nullable JsonObject element) {
        if (element == null || element.isJsonNull() || element.isJsonObject() && element.getAsJsonObject().size() < 1) {
            return ANY;
        }
        Boolean highSpeed = JsonUtil.getAsBoolean(element, "high_speed").orElse(null);
        Boolean launched = JsonUtil.getAsBoolean(element, "launched").orElse(null);
        Boolean elevator = JsonUtil.getAsBoolean(element, "on_elevator").orElse(null);
        Boolean derail = JsonUtil.getAsBoolean(element, "derailed").orElse(null);
        Boolean canMount = JsonUtil.getAsBoolean(element, "canMount").orElse(null);
        Boolean checksOwner = JsonUtil.getAsBoolean(element, "check_owner").orElse(null);
        MinMaxBounds.Doubles speed = MinMaxBounds.Doubles.m_154791_((JsonElement)element.get("speed"));
        EntityPredicate parent = EntityPredicate.m_36614_((JsonElement)element.get("parent"));
        return new MinecartPredicate(highSpeed, launched, elevator, derail, canMount, checksOwner, speed, parent);
    }
}

