/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.charge;

import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.Iterators;
import com.mojang.logging.LogUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeBlock;
import mods.railcraft.api.charge.ChargeProtectionItem;
import mods.railcraft.api.charge.ChargeStorage;
import mods.railcraft.charge.ChargeSavedData;
import mods.railcraft.charge.ChargeStorageBlockImpl;
import mods.railcraft.util.ModEntitySelector;
import mods.railcraft.world.damagesource.RailcraftDamageSources;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ChargeNetworkImpl
implements Charge.Network {
    private static final Logger logger = LogUtils.getLogger();
    public static final int CHARGE_PER_DAMAGE = 1000;
    public static final Map<ChargeBlock.ConnectType, ConnectionMap> CONNECTION_MAPS = new EnumMap<ChargeBlock.ConnectType, ConnectionMap>(ChargeBlock.ConnectType.class);
    private final ChargeGrid NULL_GRID = new NullGrid();
    private final Map<BlockPos, ChargeNode> nodes = new HashMap<BlockPos, ChargeNode>();
    private final Map<BlockPos, ChargeNode> queue = new LinkedHashMap<BlockPos, ChargeNode>();
    private final Set<ChargeNode> tickingNodes = new LinkedHashSet<ChargeNode>();
    private final Set<ChargeGrid> grids = Collections.newSetFromMap(new WeakHashMap());
    private final ChargeNode NULL_NODE = new NullNode();
    private final Charge network;
    private final ServerLevel level;
    private final ChargeSavedData chargeSavedData;

    public ChargeNetworkImpl(Charge network, ServerLevel level) {
        this.network = network;
        this.level = level;
        this.chargeSavedData = ChargeSavedData.getFor(network, level);
    }

    public void tick() {
        this.tickingNodes.removeIf(ChargeNode::checkUsageRecordingCompletion);
        HashSet<BlockPos> added = new HashSet<BlockPos>();
        Iterator<Map.Entry<BlockPos, ChargeNode>> iterator = this.queue.entrySet().iterator();
        int count = 0;
        while (iterator.hasNext() && count < 500) {
            ++count;
            Map.Entry<BlockPos, ChargeNode> action = iterator.next();
            if (action.getValue() == null) {
                this.removeNodeImpl(action.getKey());
            } else {
                this.addNodeImpl(action.getKey(), action.getValue());
                added.add(action.getKey());
            }
            iterator.remove();
        }
        HashSet newNodes = new HashSet();
        added.forEach(pos -> this.forConnections((BlockPos)pos, (conPos, conState) -> {
            if (this.addNode((BlockPos)conPos, (BlockState)conState)) {
                newNodes.add(conPos);
            }
        }));
        this.grids.removeIf(g -> g.invalid);
        this.grids.forEach(ChargeGrid::tick);
        if (!newNodes.isEmpty()) {
            logger.debug("Nodes queued: {}", (Object)newNodes.size());
        }
    }

    private void forConnections(BlockPos pos, BiConsumer<BlockPos, BlockState> action) {
        if (this.level == null) {
            return;
        }
        BlockState state = this.level.m_8055_(pos);
        ChargeBlock.Spec chargeSpec = this.getChargeSpec(state, pos);
        if (chargeSpec != null) {
            CONNECTION_MAPS.get((Object)chargeSpec.connectType()).forEach((k, v) -> {
                BlockPos otherPos = pos.m_121955_(k);
                BlockState otherState = this.level.m_8055_(otherPos);
                ChargeBlock.Spec other = this.getChargeSpec(otherState, otherPos);
                if (other != null && CONNECTION_MAPS.get((Object)other.connectType()).get(pos.m_121996_((Vec3i)otherPos)).contains((Object)chargeSpec.connectType())) {
                    action.accept(otherPos, otherState);
                }
            });
        }
    }

    private void addNodeImpl(BlockPos pos, ChargeNode node) {
        if (!this.needsNode(pos, node.chargeSpec)) {
            return;
        }
        ChargeNode oldNode = this.nodes.put(pos.m_7949_(), node);
        if (node.chargeBattery != null) {
            this.chargeSavedData.initBattery(node.chargeBattery);
        } else {
            this.chargeSavedData.removeBattery(pos);
        }
        if (oldNode != null) {
            oldNode.invalid = true;
            if (oldNode.chargeGrid.isActive()) {
                node.chargeGrid = oldNode.chargeGrid;
                node.chargeGrid.add(node);
            }
            oldNode.chargeGrid = this.NULL_GRID;
        }
        if (node.isGridNull()) {
            node.constructGrid();
        }
    }

    private void removeNodeImpl(BlockPos pos) {
        ChargeNode chargeNode = this.nodes.remove(pos);
        if (chargeNode != null) {
            chargeNode.invalid = true;
            chargeNode.chargeGrid.destroy(true);
        }
        this.chargeSavedData.removeBattery(pos);
    }

    @Override
    public boolean addNode(BlockPos pos, BlockState state) {
        ChargeBlock.Spec chargeSpec = this.getChargeSpec(state, pos);
        if (chargeSpec != null && this.needsNode(pos, chargeSpec)) {
            pos = pos.m_7949_();
            logger.debug("Registering Node: {}->{}", (Object)pos, (Object)chargeSpec);
            this.queue.put(pos, new ChargeNode(pos, chargeSpec));
            return true;
        }
        return false;
    }

    private boolean needsNode(BlockPos pos, ChargeBlock.Spec chargeSpec) {
        ChargeNode node = this.nodes.get(pos);
        return node == null || !node.isValid() || !Objects.equals(node.chargeSpec, chargeSpec);
    }

    @Nullable
    private ChargeBlock.Spec getChargeSpec(BlockState state, BlockPos pos) {
        if (this.level == null) {
            return null;
        }
        Block block = state.m_60734_();
        if (block instanceof ChargeBlock) {
            ChargeBlock chargeBlock = (ChargeBlock)block;
            return chargeBlock.getChargeSpecs(state, this.level, pos).get((Object)this.network);
        }
        return null;
    }

    @Override
    public void removeNode(BlockPos pos) {
        this.queue.put(pos.m_7949_(), null);
    }

    public ChargeGrid grid(BlockPos pos) {
        return this.access(pos).getGrid();
    }

    @Override
    public ChargeNode access(BlockPos pos) {
        BlockState state;
        ChargeBlock.Spec chargeSpec;
        ChargeNode node = this.nodes.get(pos);
        if (node != null && !node.isValid()) {
            this.removeNodeImpl(pos);
            node = null;
        }
        if (node == null && this.level != null && (chargeSpec = this.getChargeSpec(state = this.level.m_8055_(pos), pos)) != null) {
            pos = pos.m_7949_();
            node = new ChargeNode(pos, chargeSpec);
            this.addNodeImpl(pos, node);
        }
        return node == null ? this.NULL_NODE : node;
    }

    static {
        EnumSet<ChargeBlock.ConnectType> any = EnumSet.allOf(ChargeBlock.ConnectType.class);
        EnumSet<ChargeBlock.ConnectType> notWire = EnumSet.complementOf(EnumSet.of(ChargeBlock.ConnectType.WIRE));
        EnumSet<ChargeBlock.ConnectType> track = EnumSet.of(ChargeBlock.ConnectType.TRACK);
        EnumSet<ChargeBlock.ConnectType> notFlat = EnumSet.complementOf(EnumSet.of(ChargeBlock.ConnectType.TRACK, ChargeBlock.ConnectType.SLAB));
        ConnectionMap positions = new ConnectionMap();
        for (Direction facing : Direction.values()) {
            positions.put(facing.m_122436_(), any);
        }
        CONNECTION_MAPS.put(ChargeBlock.ConnectType.BLOCK, positions);
        positions = new ConnectionMap();
        positions.put(new BlockPos(1, 0, 0), notWire);
        positions.put(new BlockPos(-1, 0, 0), notWire);
        positions.put(new BlockPos(0, -1, 0), any);
        positions.put(new BlockPos(0, 0, 1), notWire);
        positions.put(new BlockPos(0, 0, -1), notWire);
        CONNECTION_MAPS.put(ChargeBlock.ConnectType.SLAB, positions);
        positions = new ConnectionMap();
        positions.put(new BlockPos(1, 0, 0), notWire);
        positions.put(new BlockPos(-1, 0, 0), notWire);
        positions.put(new BlockPos(1, 1, 0), track);
        positions.put(new BlockPos(1, -1, 0), track);
        positions.put(new BlockPos(-1, 1, 0), track);
        positions.put(new BlockPos(-1, -1, 0), track);
        positions.put(new BlockPos(0, -1, 0), any);
        positions.put(new BlockPos(0, 0, 1), notWire);
        positions.put(new BlockPos(0, 0, -1), notWire);
        positions.put(new BlockPos(0, 1, 1), track);
        positions.put(new BlockPos(0, -1, 1), track);
        positions.put(new BlockPos(0, 1, -1), track);
        positions.put(new BlockPos(0, -1, -1), track);
        CONNECTION_MAPS.put(ChargeBlock.ConnectType.TRACK, positions);
        positions = new ConnectionMap();
        positions.put(new BlockPos(1, 0, 0), notFlat);
        positions.put(new BlockPos(-1, 0, 0), notFlat);
        positions.put(new BlockPos(0, 1, 0), any);
        positions.put(new BlockPos(0, -1, 0), notFlat);
        positions.put(new BlockPos(0, 0, 1), notFlat);
        positions.put(new BlockPos(0, 0, -1), notFlat);
        CONNECTION_MAPS.put(ChargeBlock.ConnectType.WIRE, positions);
    }

    private class NullGrid
    extends ChargeGrid {
        private NullGrid() {
        }

        @Override
        protected Set<ChargeNode> delegate() {
            return Collections.emptySet();
        }

        @Override
        protected void destroy(boolean touchNodes) {
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public String toString() {
            return "ChargeGrid{NullGrid}";
        }
    }

    public class ChargeGrid
    extends ForwardingSet<ChargeNode> {
        private final Set<ChargeNode> chargeNodes = new HashSet<ChargeNode>();
        private final List<ChargeStorageBlockImpl> batteries = new ArrayList<ChargeStorageBlockImpl>();
        private boolean invalid;
        private float totalLosses;
        private int chargeUsedThisTick;
        private float averageUsagePerTick;

        protected Set<ChargeNode> delegate() {
            return this.chargeNodes;
        }

        public boolean add(ChargeNode chargeNode) {
            if (!chargeNode.isValid()) {
                return false;
            }
            boolean added = super.add((Object)chargeNode);
            if (added) {
                this.totalLosses += chargeNode.chargeSpec.losses();
            }
            chargeNode.chargeGrid = this;
            this.batteries.removeIf((? super E b) -> b.getBlockPos().equals((Object)chargeNode.pos));
            if (chargeNode.chargeBattery != null) {
                this.batteries.removeIf((? super E b) -> b.getBlockPos().equals((Object)chargeNode.pos));
                this.batteries.add(chargeNode.chargeBattery);
                this.sortBatteries();
            } else {
                ChargeNetworkImpl.this.chargeSavedData.removeBattery(chargeNode.pos);
            }
            return added;
        }

        private void sortBatteries() {
            this.batteries.sort(Comparator.comparing(ChargeStorage::getState).thenComparing(Comparator.comparing(ChargeStorage::getEfficiency).reversed()));
        }

        public boolean addAll(Collection<? extends ChargeNode> collection) {
            return this.standardAddAll(collection);
        }

        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(Predicate<? super ChargeNode> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        public Iterator<ChargeNode> iterator() {
            return Iterators.unmodifiableIterator((Iterator)super.iterator());
        }

        protected void destroy(boolean touchNodes) {
            logger.debug("Destroying grid: {}", (Object)this);
            this.invalid = true;
            this.totalLosses = 0.0f;
            if (touchNodes) {
                this.forEach(n -> {
                    n.chargeGrid = ChargeNetworkImpl.this.NULL_GRID;
                });
            }
            this.batteries.clear();
            this.chargeNodes.clear();
            ChargeNetworkImpl.this.grids.remove((Object)this);
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        private void tick() {
            this.sortBatteries();
            this.removeCharge(Mth.m_14143_((float)this.getLosses()), false);
            Set<ChargeStorageBlockImpl> rechargeable = this.batteries(ChargeStorage.State.RECHARGEABLE).collect(Collectors.toSet());
            int capacity = rechargeable.stream().mapToInt(IEnergyStorage::getMaxEnergyStored).sum();
            if (capacity > 0) {
                int charge = rechargeable.stream().mapToInt(IEnergyStorage::getEnergyStored).sum();
                int neededCharge = capacity - charge;
                if (neededCharge > 0) {
                    charge += this.removeCharge(this.batteries(ChargeStorage.State.SOURCE).toList(), neededCharge, false);
                }
                float chargeLevel = (float)charge / (float)capacity;
                rechargeable.forEach(bat -> bat.setEnergyStored(Mth.m_14143_((float)(chargeLevel * (float)bat.getMaxEnergyStored()))));
            }
            this.batteries.forEach(bat -> {
                bat.tick();
                ChargeNetworkImpl.this.chargeSavedData.updateBatteryRecord((ChargeStorageBlockImpl)bat);
            });
            this.averageUsagePerTick = (this.averageUsagePerTick * 49.0f + (float)this.chargeUsedThisTick) / 50.0f;
            this.chargeUsedThisTick = 0;
        }

        private Stream<ChargeStorageBlockImpl> batteries(ChargeStorage.State ... state) {
            List<ChargeStorage.State> list = Arrays.asList(state);
            return this.batteries.stream().filter(b -> list.contains((Object)b.getState()));
        }

        private Stream<ChargeStorageBlockImpl> activeBatteries() {
            return this.batteries.stream().filter(b -> b.getState() != ChargeStorage.State.DISABLED);
        }

        public int getCharge() {
            return this.activeBatteries().mapToInt(IEnergyStorage::getEnergyStored).sum();
        }

        public int getCapacity() {
            return this.activeBatteries().mapToInt(IEnergyStorage::getMaxEnergyStored).sum();
        }

        public float getChargeLevel() {
            return (float)this.getCharge() / (float)this.getCapacity();
        }

        public int getAvailableCharge() {
            return this.activeBatteries().mapToInt(ChargeStorage::getAvailableCharge).sum();
        }

        public int getPotentialDraw() {
            return this.activeBatteries().mapToInt(ChargeStorage::getPotentialDraw).sum();
        }

        public int getMaxDraw() {
            return this.activeBatteries().mapToInt(ChargeStorage::getMaxDraw).sum();
        }

        public float getEfficiency() {
            return (float)this.activeBatteries().mapToDouble(ChargeStorage::getEfficiency).average().orElse(1.0);
        }

        public int getComparatorOutput() {
            double capacity = this.getCapacity();
            if (capacity <= 0.0) {
                return 0;
            }
            double level = (double)this.getCharge() / capacity;
            return Math.round((float)(15.0 * level));
        }

        public float getLosses() {
            return this.totalLosses * ((Double)RailcraftConfig.SERVER.lossMultiplier.get()).floatValue();
        }

        public float getAverageUsagePerTick() {
            return this.averageUsagePerTick;
        }

        public float getUtilization() {
            if (this.isInfinite()) {
                return 0.0f;
            }
            int potentialDraw = this.getPotentialDraw();
            if (potentialDraw <= 0) {
                return 1.0f;
            }
            return Math.min(this.averageUsagePerTick / (float)potentialDraw, 1.0f);
        }

        public boolean isInfinite() {
            return this.batteries.stream().anyMatch(b -> b.getState() == ChargeStorage.State.INFINITE);
        }

        public boolean isActive() {
            return !this.isNull();
        }

        public boolean isNull() {
            return false;
        }

        public boolean useCharge(int amount, boolean simulate) {
            if (this.hasCapacity(amount)) {
                this.removeCharge(this.activeBatteries().toList(), amount, simulate);
                return true;
            }
            return false;
        }

        public boolean hasCapacity(int amount) {
            return this.getAvailableCharge() >= amount;
        }

        public int removeCharge(int desiredAmount, boolean simulate) {
            return this.removeCharge(this.activeBatteries().toList(), desiredAmount, simulate);
        }

        private int removeCharge(List<ChargeStorageBlockImpl> batteries, int desiredAmount, boolean simulate) {
            int amountNeeded = desiredAmount;
            for (ChargeStorageBlockImpl battery : batteries) {
                amountNeeded -= battery.extractEnergy(amountNeeded, simulate);
                if (!simulate) {
                    ChargeNetworkImpl.this.chargeSavedData.updateBatteryRecord(battery);
                }
                if (amountNeeded > 0) continue;
                break;
            }
            int chargeRemoved = desiredAmount - amountNeeded;
            if (!simulate) {
                this.chargeUsedThisTick += chargeRemoved;
            }
            return chargeRemoved;
        }

        public String toString() {
            return String.format("ChargeGrid{id=%s,s=%d,b=%d}", "@" + System.identityHashCode((Object)this), this.size(), this.batteries.size());
        }
    }

    public class NullNode
    extends ChargeNode {
        public NullNode() {
            super(new BlockPos(0, 0, 0), new ChargeBlock.Spec(ChargeBlock.ConnectType.BLOCK, 0.0f));
        }

        @Override
        public Optional<ChargeStorageBlockImpl> storage() {
            return Optional.empty();
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public ChargeGrid getGrid() {
            return ChargeNetworkImpl.this.NULL_GRID;
        }

        @Override
        public boolean hasCapacity(int amount) {
            return false;
        }

        @Override
        public boolean useCharge(int amount, boolean simulate) {
            return false;
        }

        @Override
        public int removeCharge(int desiredAmount, boolean simulate) {
            return 0;
        }

        @Override
        protected void constructGrid() {
        }

        @Override
        public String toString() {
            return "ChargeNode{NullNode}";
        }
    }

    public class ChargeNode
    implements Charge.Access {
        protected final ChargeStorageBlockImpl chargeBattery;
        private final BlockPos pos;
        private final ChargeBlock.Spec chargeSpec;
        private ChargeGrid chargeGrid;
        private boolean invalid;
        private Optional<UsageRecorder> usageRecorder;
        private final Collection<ChargeListener> listeners;

        private ChargeNode(BlockPos pos, ChargeBlock.Spec chargeSpec) {
            this.chargeGrid = ChargeNetworkImpl.this.NULL_GRID;
            this.usageRecorder = Optional.empty();
            this.listeners = new LinkedHashSet<ChargeListener>();
            this.pos = pos.m_7949_();
            this.chargeSpec = chargeSpec;
            this.chargeBattery = chargeSpec.storageSpec() == null ? null : new ChargeStorageBlockImpl(this.pos, chargeSpec.storageSpec());
        }

        public ChargeBlock.Spec getChargeSpec() {
            return this.chargeSpec;
        }

        private void forConnections(Consumer<ChargeNode> action) {
            CONNECTION_MAPS.get((Object)this.chargeSpec.connectType()).forEach((k, v) -> {
                BlockPos otherPos = this.pos.m_121955_(k);
                ChargeNode other = ChargeNetworkImpl.this.nodes.get(otherPos);
                if (other != null && v.contains((Object)other.chargeSpec.connectType()) && CONNECTION_MAPS.get((Object)other.chargeSpec.connectType()).get(this.pos.m_121996_((Vec3i)otherPos)).contains((Object)this.chargeSpec.connectType())) {
                    action.accept(other);
                }
            });
        }

        public ChargeGrid getGrid() {
            if (this.chargeGrid.isActive()) {
                return this.chargeGrid;
            }
            this.constructGrid();
            return this.chargeGrid;
        }

        public void addListener(ChargeListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(ChargeListener listener) {
            this.listeners.remove(listener);
        }

        public void startUsageRecording(int ticksToRecord, Consumer<Double> usageConsumer) {
            this.usageRecorder = Optional.of(new UsageRecorder(ticksToRecord, usageConsumer));
            ChargeNetworkImpl.this.tickingNodes.add(this);
        }

        public boolean checkUsageRecordingCompletion() {
            this.usageRecorder = this.usageRecorder.filter(UsageRecorder::run);
            return this.usageRecorder.isEmpty();
        }

        @Override
        public boolean hasCapacity(int amount) {
            return this.chargeGrid.hasCapacity(amount);
        }

        @Override
        public boolean useCharge(int amount, boolean simulate) {
            boolean removed = this.chargeGrid.useCharge(amount, simulate);
            if (removed && !simulate) {
                this.listeners.forEach(c -> c.chargeRemoved(this, amount));
                this.usageRecorder.ifPresent(r -> r.useCharge(amount));
            }
            return removed;
        }

        @Override
        public int removeCharge(int desiredAmount, boolean simulate) {
            int removed = this.chargeGrid.removeCharge(desiredAmount, simulate);
            if (!simulate) {
                this.listeners.forEach(c -> c.chargeRemoved(this, removed));
                this.usageRecorder.ifPresent(r -> r.useCharge(removed));
            }
            return removed;
        }

        public boolean isValid() {
            return !this.invalid;
        }

        public boolean isGridNull() {
            return this.chargeGrid.isNull();
        }

        protected void constructGrid() {
            ChargeNode nextNode;
            HashSet<ChargeNode> visitedNodes = new HashSet<ChargeNode>();
            visitedNodes.add(this);
            HashSet<ChargeNode> nullNodes = new HashSet<ChargeNode>();
            if (this.isGridNull()) {
                nullNodes.add(this);
            }
            ArrayDeque<ChargeNode> nodeQueue = new ArrayDeque<ChargeNode>();
            nodeQueue.add(this);
            TreeSet<ChargeGrid> seenGrids = new TreeSet<ChargeGrid>(Comparator.comparingInt(ForwardingCollection::size));
            seenGrids.add(this.chargeGrid);
            while ((nextNode = (ChargeNode)nodeQueue.poll()) != null) {
                nextNode.forConnections(connection -> {
                    if (visitedNodes.contains(connection)) {
                        return;
                    }
                    visitedNodes.add((ChargeNode)connection);
                    if (connection.isGridNull()) {
                        nullNodes.add((ChargeNode)connection);
                        nodeQueue.addLast((ChargeNode)connection);
                    } else {
                        seenGrids.add(connection.chargeGrid);
                    }
                });
            }
            this.chargeGrid = Objects.requireNonNull(seenGrids.pollLast());
            if (this.chargeGrid.isNull()) {
                this.chargeGrid = new ChargeGrid();
                ChargeNetworkImpl.this.grids.add(this.chargeGrid);
            }
            int originalSize = this.chargeGrid.size();
            this.chargeGrid.addAll(nullNodes);
            seenGrids.forEach(grid -> {
                this.chargeGrid.addAll((Collection<? extends ChargeNode>)((Object)grid));
                grid.destroy(false);
            });
            logger.debug("Constructing Grid: {}->{} Added {} nodes", new Object[]{this.pos, this.chargeGrid, this.chargeGrid.size() - originalSize});
        }

        @Override
        public void zap(Entity entity, Charge.DamageOrigin origin, float damage) {
            if (entity.m_9236_().m_5776_()) {
                return;
            }
            if (!ModEntitySelector.KILLABLE.test(entity)) {
                return;
            }
            int chargeCost = Mth.m_14143_((float)damage) * 1000;
            if (this.hasCapacity(chargeCost)) {
                float remainingDamage = damage;
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    EnumMap<EquipmentSlot, ChargeProtectionItem> protections = new EnumMap<EquipmentSlot, ChargeProtectionItem>(EquipmentSlot.class);
                    for (EquipmentSlot slot : EquipmentSlot.values()) {
                        ChargeProtectionItem protection = this.getChargeProtection(livingEntity, slot);
                        if (protection == null) continue;
                        protections.put(slot, protection);
                    }
                    for (Map.Entry entry : protections.entrySet()) {
                        if (!(remainingDamage > 0.1f)) break;
                        ChargeProtectionItem.ZapResult result = ((ChargeProtectionItem)entry.getValue()).zap(livingEntity.m_6844_((EquipmentSlot)entry.getKey()), livingEntity, remainingDamage);
                        entity.m_8061_((EquipmentSlot)entry.getKey(), result.stack());
                        remainingDamage -= result.damagePrevented();
                    }
                }
                if (remainingDamage > 0.1f && entity.m_6469_((DamageSource)(origin == Charge.DamageOrigin.BLOCK ? RailcraftDamageSources.electric(ChargeNetworkImpl.this.level.m_9598_()) : RailcraftDamageSources.trackElectric(ChargeNetworkImpl.this.level.m_9598_())), remainingDamage)) {
                    this.removeCharge(chargeCost, false);
                    Charge.zapEffectProvider().zapEffectDeath(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                }
            }
        }

        @Nullable
        private ChargeProtectionItem getChargeProtection(LivingEntity entity, EquipmentSlot slot) {
            ChargeProtectionItem protectionItem;
            ItemStack stack = entity.m_6844_(slot);
            Item item = stack.m_41720_();
            if (item instanceof ChargeProtectionItem && (protectionItem = (ChargeProtectionItem)item).isZapProtectionActive(stack, entity)) {
                return protectionItem;
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChargeNode that = (ChargeNode)o;
            return this.pos.equals((Object)that.pos);
        }

        public int hashCode() {
            return this.pos.hashCode();
        }

        public Optional<ChargeStorageBlockImpl> storage() {
            return Optional.ofNullable(this.chargeBattery);
        }

        @Override
        public int getComparatorOutput() {
            return this.getGrid().getComparatorOutput();
        }

        public String toString() {
            Object string = String.format("ChargeNode{%s}|%s", this.pos, this.chargeSpec.toString());
            if (this.chargeBattery != null) {
                string = (String)string + "|State: " + String.valueOf((Object)this.chargeBattery.getState());
            }
            return string;
        }
    }

    private static class ConnectionMap
    extends ForwardingMap<Vec3i, Set<ChargeBlock.ConnectType>> {
        private final Map<Vec3i, Set<ChargeBlock.ConnectType>> delegate = new HashMap<Vec3i, Set<ChargeBlock.ConnectType>>();

        protected Map<Vec3i, Set<ChargeBlock.ConnectType>> delegate() {
            return this.delegate;
        }

        public Set<ChargeBlock.ConnectType> get(@Nullable Object key) {
            EnumSet<ChargeBlock.ConnectType> ret = (EnumSet<ChargeBlock.ConnectType>)super.get(key);
            return ret == null ? EnumSet.noneOf(ChargeBlock.ConnectType.class) : ret;
        }
    }

    @FunctionalInterface
    public static interface ChargeListener {
        public void chargeRemoved(ChargeNode var1, int var2);
    }

    private static class UsageRecorder {
        private final int ticksToRecord;
        private final Consumer<Double> usageConsumer;
        private double chargeUsed;
        private int ticksRecorded;

        public UsageRecorder(int ticksToRecord, Consumer<Double> usageConsumer) {
            this.ticksToRecord = ticksToRecord;
            this.usageConsumer = usageConsumer;
        }

        public void useCharge(double amount) {
            this.chargeUsed += amount;
        }

        public Boolean run() {
            ++this.ticksRecorded;
            if (this.ticksRecorded > this.ticksToRecord) {
                this.usageConsumer.accept(this.chargeUsed / (double)this.ticksToRecord);
                return false;
            }
            return true;
        }
    }
}

