/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.client.gui.screen.inventory.WidgetRenderer;
import mods.railcraft.gui.widget.Widget;
import mods.railcraft.world.inventory.RailcraftMenu;
import mods.railcraft.world.inventory.slot.RailcraftSlot;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;

public abstract class RailcraftMenuScreen<T extends RailcraftMenu>
extends AbstractContainerScreen<T> {
    private final List<WidgetRenderer<?>> widgetRenderers = new ArrayList();
    protected final Inventory inventory;

    protected void registerWidgetRenderer(WidgetRenderer<?> renderer) {
        this.widgetRenderers.add(renderer);
    }

    protected RailcraftMenuScreen(T menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.inventory = inventory;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        int left = this.f_97735_;
        int top = this.f_97736_;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (((RailcraftMenu)this.f_97732_).m_142621_().m_41619_()) {
            for (WidgetRenderer<?> renderer : this.widgetRenderers) {
                List<Component> tooltip;
                if (((Widget)renderer.widget).hidden || (tooltip = renderer.getTooltip()) == null || !renderer.isMouseOver(mouseX - left, mouseY - top)) continue;
                guiGraphics.m_280666_(this.f_96547_, tooltip, mouseX, mouseY);
            }
            for (Slot slot : ((RailcraftMenu)this.f_97732_).f_38839_) {
                List<Component> tooltip;
                if (!(slot instanceof RailcraftSlot)) continue;
                RailcraftSlot railcraftSlot = (RailcraftSlot)slot;
                if (!slot.m_7993_().m_41619_() || (tooltip = railcraftSlot.getTooltip()) == null || !this.isMouseOverSlot(slot, mouseX, mouseY)) continue;
                guiGraphics.m_280666_(this.f_96547_, tooltip, mouseX, mouseY);
            }
        }
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    public abstract ResourceLocation getWidgetsTexture();

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.f_96543_ - this.getXSize()) / 2;
        int y = (this.f_96544_ - this.getYSize()) / 2;
        guiGraphics.m_280218_(this.getWidgetsTexture(), x, y, 0, 0, this.getXSize(), this.getYSize());
        int relativeMouseX = mouseX - this.f_97735_;
        int relativeMouseY = mouseY - this.f_97736_;
        for (WidgetRenderer<?> renderer : this.widgetRenderers) {
            if (((Widget)renderer.widget).hidden) continue;
            renderer.render(this.getWidgetsTexture(), guiGraphics, x, y, relativeMouseX, relativeMouseY);
        }
    }

    private boolean isMouseOverSlot(Slot slot, int mouseX, int mouseY) {
        return (mouseX -= this.f_97735_) >= slot.f_40220_ - 1 && mouseX < slot.f_40220_ + 16 + 1 && (mouseY -= this.f_97736_) >= slot.f_40221_ - 1 && mouseY < slot.f_40221_ + 16 + 1;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        double relativeMouseX = mouseX - (double)this.f_97735_;
        double relativeMouseY = mouseY - (double)this.f_97736_;
        if (this.widgetRenderers.stream().filter(element -> !((Widget)element.widget).hidden).filter(element -> element.isMouseOver(relativeMouseX, relativeMouseY)).anyMatch(element -> element.mouseClicked(relativeMouseX, relativeMouseY, button))) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        RailcraftSlot railcraftSlot;
        Slot slot = this.getSlotUnderMouse();
        if (button == 0 && slot instanceof RailcraftSlot && (railcraftSlot = (RailcraftSlot)slot).isPhantom()) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }
}

