/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen.inventory;

import java.util.List;
import java.util.Optional;
import mods.railcraft.Translations;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.gui.screen.inventory.RailcraftMenuScreen;
import mods.railcraft.client.gui.screen.inventory.WidgetRenderer;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.MultiButton;
import mods.railcraft.gui.widget.Widget;
import mods.railcraft.network.NetworkChannel;
import mods.railcraft.network.play.SetRoutingDetectorAttributesMessage;
import mods.railcraft.util.routing.RouterBlockEntity;
import mods.railcraft.util.routing.RoutingLogicException;
import mods.railcraft.world.inventory.detector.RoutingDetectorMenu;
import mods.railcraft.world.level.block.entity.LockableSwitchTrackActuatorBlockEntity;
import mods.railcraft.world.level.block.entity.detector.RoutingDetectorBlockEntity;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class RoutingDetectorScreen
extends RailcraftMenuScreen<RoutingDetectorMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = RailcraftConstants.rl("textures/gui/container/routing.png");
    private static final Component ROUTING_TABLE = Component.m_237115_((String)Translations.Screen.ROUTING_TABLE_BOOK);
    private static final int REFRESH_INTERVAL_TICKS = 20;
    private final RoutingDetectorBlockEntity routingDetector;
    private MultiButton<LockableSwitchTrackActuatorBlockEntity.Lock> lockButton;
    private MultiButton<RouterBlockEntity.Railway> railwayButton;
    private int refreshTimer;

    public RoutingDetectorScreen(final RoutingDetectorMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.f_97727_ = 158;
        this.f_97726_ = 176;
        this.f_97731_ = this.f_97727_ - 94;
        this.routingDetector = menu.getRoutingDetector();
        this.registerWidgetRenderer(new WidgetRenderer<Widget>(menu.getErrorWidget()){

            @Override
            public List<Component> getTooltip() {
                return menu.getRoutingDetector().logicError().map(RoutingLogicException::getTooltip).orElse(null);
            }

            @Override
            public void render(ResourceLocation widgetLocation, GuiGraphics guiGraphics, int centreX, int centreY, int mouseX, int mouseY) {
                if (this.getTooltip() != null) {
                    super.render(widgetLocation, guiGraphics, centreX, centreY, mouseX, mouseY);
                }
            }
        });
    }

    @Override
    public ResourceLocation getWidgetsTexture() {
        return BACKGROUND_TEXTURE;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.lockButton = (MultiButton)this.m_142416_((GuiEventListener)((MultiButton)((MultiButton.Builder)MultiButton.builder(ButtonTexture.SMALL_BUTTON, this.routingDetector.getLock()).bounds(this.f_97735_ + 152, this.f_97736_ + 8, 16, 16)).tooltipFactory(this::updateLockButtonTooltip).stateCallback(this::setLock).build()));
        this.railwayButton = (MultiButton)this.m_142416_((GuiEventListener)((MultiButton)((MultiButton.Builder)MultiButton.builder(ButtonTexture.SMALL_BUTTON, this.routingDetector.getRailway()).bounds(this.f_97735_ + 68, this.f_97736_ + 50, 100, 16)).tooltipFactory(this::updateRailwayButtonTooltip).stateCallback(this::setRailway).build()));
        this.updateButtons();
    }

    private void setLock(LockableSwitchTrackActuatorBlockEntity.Lock lock) {
        if (this.routingDetector.getLock() != lock) {
            this.routingDetector.setLock(lock.equals(LockableSwitchTrackActuatorBlockEntity.Lock.UNLOCKED) ? null : this.f_96541_.m_91094_().m_92548_());
            this.sendAttributes();
        }
    }

    private void setRailway(RouterBlockEntity.Railway railway) {
        if (this.routingDetector.getRailway() != railway) {
            this.routingDetector.setRailway(railway.equals(RouterBlockEntity.Railway.PUBLIC) ? null : this.f_96541_.m_91094_().m_92548_());
            this.sendAttributes();
        }
    }

    private Optional<Tooltip> updateLockButtonTooltip(LockableSwitchTrackActuatorBlockEntity.Lock lock) {
        return Optional.of(Tooltip.m_257550_((Component)(switch (lock) {
            default -> throw new IncompatibleClassChangeError();
            case LockableSwitchTrackActuatorBlockEntity.Lock.LOCKED -> Component.m_237110_((String)Translations.Screen.ACTION_SIGNAL_BOX_LOCKED, (Object[])new Object[]{this.routingDetector.getOwnerOrThrow().getName()});
            case LockableSwitchTrackActuatorBlockEntity.Lock.UNLOCKED -> Component.m_237115_((String)Translations.Screen.ACTION_SIGNAL_BOX_UNLOCKED);
        })));
    }

    private Optional<Tooltip> updateRailwayButtonTooltip(RouterBlockEntity.Railway railway) {
        return Optional.of(Tooltip.m_257550_((Component)(switch (railway) {
            default -> throw new IncompatibleClassChangeError();
            case RouterBlockEntity.Railway.PRIVATE -> Component.m_237110_((String)Translations.Screen.SWITCH_TRACK_ROUTER_PRIVATE_RAILWAY_DESC, (Object[])new Object[]{this.routingDetector.getOwnerOrThrow().getName()});
            case RouterBlockEntity.Railway.PUBLIC -> Component.m_237115_((String)Translations.Screen.SWITCH_TRACK_ROUTER_PUBLIC_RAILWAY_DESC);
        })));
    }

    protected void m_181908_() {
        super.m_181908_();
        if (this.refreshTimer++ >= 20) {
            this.refreshTimer = 0;
            this.updateButtons();
        }
    }

    private void updateButtons() {
        boolean canAccess;
        this.lockButton.f_93623_ = canAccess = this.routingDetector.canAccess(this.f_96541_.m_91094_().m_92548_());
        this.lockButton.setState(this.routingDetector.getLock());
        this.railwayButton.f_93623_ = canAccess;
        this.railwayButton.setState(this.routingDetector.getRailway());
    }

    private void sendAttributes() {
        if (!this.routingDetector.canAccess(this.f_96541_.m_91094_().m_92548_())) {
            return;
        }
        NetworkChannel.GAME.sendToServer(new SetRoutingDetectorAttributesMessage(this.routingDetector.m_58899_(), this.railwayButton.getState(), this.lockButton.getState()));
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
        guiGraphics.m_280614_(this.f_96547_, ROUTING_TABLE, 64, 29, 0x404040, false);
    }
}

