/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import mods.railcraft.particle.ChunkLoaderParticleOptions;
import mods.railcraft.world.item.GogglesItem;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.phys.Vec3;

public class ChunkLoaderParticle
extends TextureSheetParticle {
    private final Vec3 dest;

    private ChunkLoaderParticle(ClientLevel level, double x, double y, double z, double dx, double dy, double dz, ChunkLoaderParticleOptions options, SpriteSet sprites) {
        super(level, x, y, z, dx, dy, dz);
        this.dest = options.dest();
        this.calculateVector();
        this.m_6569_(1.2f);
        float brightness = this.f_107223_.m_188501_() * 0.6f + 0.4f;
        this.f_107228_ = this.f_107229_ = 1.0f * brightness;
        this.f_107227_ = this.f_107229_;
        this.f_107228_ *= 0.3f;
        this.f_107227_ *= 0.9f;
        this.m_107257_(250);
        this.f_107219_ = false;
        this.m_108335_(sprites);
    }

    private void calculateVector() {
        Vec3 vecParticle = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        Vec3 vel = this.dest.m_82546_(vecParticle);
        vel = vel.m_82541_();
        float velScale = 0.08f;
        this.f_107215_ = vel.f_82479_ * (double)velScale;
        this.f_107216_ = vel.f_82480_ * (double)velScale;
        this.f_107217_ = vel.f_82481_ * (double)velScale;
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        if (Minecraft.m_91087_().f_91074_.m_20238_(this.dest) > 25600.0) {
            return;
        }
        if (GogglesItem.isGoggleAuraActive(GogglesItem.Aura.WORLDSPIKE)) {
            super.m_5744_(buffer, renderInfo, partialTicks);
        }
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (!GogglesItem.isGoggleAuraActive(GogglesItem.Aura.WORLDSPIKE)) {
            this.m_107274_();
            return;
        }
        if (!this.f_107208_.m_46749_(BlockPos.m_274446_((Position)this.dest))) {
            this.m_107274_();
            return;
        }
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
            return;
        }
        if (this.getPos().m_82557_(this.dest) <= 0.5) {
            this.m_107274_();
            return;
        }
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public static class Provider
    implements ParticleProvider<ChunkLoaderParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(ChunkLoaderParticleOptions options, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new ChunkLoaderParticle(level, x, y, z, dx, dy, dz, options, this.sprites);
        }
    }
}

