/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import mods.railcraft.client.util.LineRenderer;
import mods.railcraft.client.util.RenderUtil;
import mods.railcraft.network.play.LinkedCartsMessage;
import mods.railcraft.world.item.GogglesItem;
import mods.railcraft.world.item.RailcraftItems;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ShuntingAuraRenderer {
    private Collection<LinkedCartsMessage.LinkedCart> linkedCarts;

    public void clearCarts() {
        this.linkedCarts = null;
    }

    public void setLinkedCarts(Collection<LinkedCartsMessage.LinkedCart> linkedCarts) {
        this.linkedCarts = linkedCarts;
    }

    public void render(PoseStack poseStack, Camera mainCamera, float partialTick) {
        GogglesItem.Aura aura;
        if (this.linkedCarts == null) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ItemStack goggles = player.m_6844_(EquipmentSlot.HEAD);
        if (goggles.m_150930_((Item)RailcraftItems.GOGGLES.get()) && (aura = GogglesItem.getAura(goggles)) == GogglesItem.Aura.SHUNTING) {
            poseStack.m_85836_();
            Vec3 projectedView = mainCamera.m_90583_();
            poseStack.m_85837_(-projectedView.f_82479_, -projectedView.f_82480_, -projectedView.f_82481_);
            Level level = player.m_9236_();
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            for (LinkedCartsMessage.LinkedCart linkedCart : this.linkedCarts) {
                Entity entity = level.m_6815_(linkedCart.entityId());
                if (!(entity instanceof AbstractMinecart)) continue;
                AbstractMinecart cart = (AbstractMinecart)entity;
                if (linkedCart.trainId() == null) continue;
                LineRenderer renderer = LineRenderer.simple((MultiBufferSource)bufferSource);
                int color = RenderUtil.replaceAlpha(linkedCart.trainId().hashCode(), 255);
                Vec3 cartPosition = cart.m_20318_(partialTick);
                renderer.renderLine(poseStack, color, cartPosition, cartPosition.m_82520_(0.0, 2.0, 0.0));
                this.renderLink(level, cartPosition, linkedCart.linkAId(), color, partialTick, renderer, poseStack);
                this.renderLink(level, cartPosition, linkedCart.linkBId(), color, partialTick, renderer, poseStack);
                bufferSource.m_109912_(RenderType.m_110504_());
            }
            poseStack.m_85849_();
        }
    }

    private void renderLink(Level level, Vec3 cartPosition, int cartId, int color, float partialTick, LineRenderer renderer, PoseStack poseStack) {
        if (cartId == -1) {
            return;
        }
        Entity cartA = level.m_6815_(cartId);
        if (cartA == null) {
            return;
        }
        Vec3 cartAPosition = cartA.m_20318_(partialTick);
        renderer.renderLine(poseStack, color, cartAPosition.m_82520_(0.0, 1.5, 0.0), cartPosition.m_82520_(0.0, 2.0, 0.0));
    }
}

