/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.util.CuboidModel;
import mods.railcraft.client.util.CuboidModelRenderer;
import mods.railcraft.client.util.FluidRenderer;
import mods.railcraft.client.util.RenderUtil;
import mods.railcraft.world.level.block.entity.manipulator.FluidManipulatorBlockEntity;
import mods.railcraft.world.level.material.StandardTank;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.fluids.FluidStack;

public class FluidManipulatorRenderer<T extends FluidManipulatorBlockEntity>
implements BlockEntityRenderer<T> {
    public static final ResourceLocation INTERIOR_TEXTURE_LOCATION = RailcraftConstants.rl("entity/fluid_manipulator/interior");
    private static final CuboidModel interiorModel = new CuboidModel(0.011f, 0.01f, 0.011f, 0.989f, 0.99f, 0.989f);

    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        interiorModel.setAll(new CuboidModel.Face(interiorModel).setSprite((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(INTERIOR_TEXTURE_LOCATION)));
        interiorModel.setPackedLight(packedLight);
        interiorModel.setPackedOverlay(packedOverlay);
        VertexConsumer consumer = bufferSource.m_6299_(Sheets.m_110790_());
        CuboidModelRenderer.render(interiorModel, poseStack, consumer, -1, CuboidModelRenderer.FaceDisplay.FRONT, true);
        StandardTank tank = ((FluidManipulatorBlockEntity)blockEntity).getTankManager().get(0);
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack != null && fluidStack.getAmount() > 0) {
            float capacity = tank.getCapacity();
            float level = Math.min((float)fluidStack.getAmount() / capacity, 1.0f);
            float fluidMaxY = fluidStack.getFluid().getFluidType().isLighterThanAir() ? 1.0f : level;
            CuboidModel model = FluidRenderer.getFluidModel(fluidStack, 0.9921875f, fluidMaxY - 0.0078125f, 0.9921875f, FluidRenderer.FluidType.STILL);
            if (model != null) {
                poseStack.m_85836_();
                poseStack.m_252880_(0.00390625f, 0.00390625f, 0.00390625f);
                model.setPackedLight(RenderUtil.calculateGlowLight(packedLight, fluidStack));
                model.setPackedOverlay(packedOverlay);
                CuboidModelRenderer.render(model, poseStack, consumer, RenderUtil.getColorARGB(fluidStack, 1.0f), CuboidModelRenderer.FaceDisplay.FRONT, true);
                poseStack.m_85849_();
            }
        }
    }
}

