/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.integrations.jei.category;

import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mods.railcraft.Translations;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.integrations.jei.RecipeTypes;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.crafting.CokeOvenRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class CokeOvenRecipeCategory
implements IRecipeCategory<CokeOvenRecipe> {
    private static final int WIDTH = 124;
    private static final int HEIGHT = 49;
    private static final ResourceLocation BACKGROUND = RailcraftConstants.rl("textures/gui/container/coke_oven.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable flame;
    private final IDrawable arrow;

    public CokeOvenRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(BACKGROUND, 15, 23, 124, 49);
        ItemStack itemStack = new ItemStack((ItemLike)RailcraftItems.COKE_OVEN_BRICKS.get());
        this.icon = guiHelper.createDrawableItemStack(itemStack);
        this.flame = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(BACKGROUND, 176, 47, 14, 14), 200, IDrawableAnimated.StartDirection.TOP, true);
        this.arrow = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(BACKGROUND, 176, 61, 22, 15), 200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public RecipeType<CokeOvenRecipe> getRecipeType() {
        return RecipeTypes.COKE_OVEN;
    }

    public Component getTitle() {
        return Component.m_237115_((String)Translations.Jei.COKE_OVEN);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(CokeOvenRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.flame.draw(guiGraphics, 1, 3);
        this.arrow.draw(guiGraphics, 19, 21);
        int cookTime = recipe.m_43753_();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Font font = Minecraft.m_91087_().f_91062_;
            int stringWidth = font.m_92852_((FormattedText)timeString);
            guiGraphics.m_280614_(font, (Component)timeString, this.getBackground().getWidth() - stringWidth - 80, 43, -8355712, false);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CokeOvenRecipe recipe, IFocusGroup focuses) {
        NonNullList ingredients = recipe.m_7527_();
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 20).addIngredients((Ingredient)ingredients.get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 46, 20).addItemStack(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 75, 1).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.getCreosote())).setFluidRenderer(10000L, true, 48, 47);
    }
}

