/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.network.play;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import mods.railcraft.world.item.RoutingTableBookItem;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public record EditRoutingTableBookMessage(InteractionHand hand, List<String> pages, Optional<String> title) {
    private static final int BOOK_MAX_PAGES = 50;

    public void encode(FriendlyByteBuf out) {
        out.m_130068_((Enum)this.hand);
        out.m_236828_(this.pages, FriendlyByteBuf::m_130070_);
        out.m_236835_(this.title, FriendlyByteBuf::m_130070_);
    }

    public static EditRoutingTableBookMessage decode(FriendlyByteBuf in) {
        InteractionHand hand = (InteractionHand)in.m_130066_(InteractionHand.class);
        ArrayList pages = (ArrayList)in.m_236838_(FriendlyByteBuf.m_182695_(Lists::newArrayListWithCapacity, (int)50), FriendlyByteBuf::m_130277_);
        Optional title = in.m_236860_(FriendlyByteBuf::m_130277_);
        return new EditRoutingTableBookMessage(hand, pages, title);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        ServerPlayer player = context.get().getSender();
        GameProfile senderProfile = player.m_36316_();
        ItemStack itemStack = player.m_21120_(this.hand);
        if (itemStack.m_41720_() instanceof RoutingTableBookItem) {
            if (!this.pages.isEmpty()) {
                ListTag listtag = new ListTag();
                this.pages.stream().map(StringTag::m_129297_).forEach(arg_0 -> listtag.add(arg_0));
                itemStack.m_41700_("pages", (Tag)listtag);
            }
            itemStack.m_41700_("author", (Tag)StringTag.m_129297_((String)senderProfile.getName()));
            itemStack.m_41700_("title", (Tag)StringTag.m_129297_((String)this.title.orElse("").trim()));
        }
        return true;
    }
}

