/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.network.play;

import java.util.Collection;
import java.util.UUID;
import java.util.function.Supplier;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.carts.Side;
import mods.railcraft.client.ClientManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public record LinkedCartsMessage(Collection<LinkedCart> linkedCarts) {
    public void encode(FriendlyByteBuf out) {
        out.m_236828_(this.linkedCarts, (buf, cart) -> cart.encode((FriendlyByteBuf)buf));
    }

    public static LinkedCartsMessage decode(FriendlyByteBuf in) {
        return new LinkedCartsMessage(in.m_236845_(LinkedCart::decode));
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        ClientManager.getShuntingAuraRenderer().setLinkedCarts(this.linkedCarts);
        return true;
    }

    public record LinkedCart(int entityId, @Nullable UUID trainId, int linkAId, int linkBId) {
        public LinkedCart(RollingStock extension) {
            this(extension.entity().m_19879_(), extension.train().id(), extension.linkAt(Side.BACK).map(RollingStock::entity).map(Entity::m_19879_).orElse(-1), extension.linkAt(Side.FRONT).map(RollingStock::entity).map(Entity::m_19879_).orElse(-1));
        }

        public void encode(FriendlyByteBuf out) {
            out.m_130130_(this.entityId);
            out.m_236821_((Object)this.trainId, FriendlyByteBuf::m_130077_);
            out.m_130130_(this.linkAId);
            out.m_130130_(this.linkBId);
        }

        public static LinkedCart decode(FriendlyByteBuf in) {
            return new LinkedCart(in.m_130242_(), (UUID)in.m_236868_(FriendlyByteBuf::m_130259_), in.m_130242_(), in.m_130242_());
        }
    }
}

