/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import mods.railcraft.particle.RailcraftParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public record ChunkLoaderParticleOptions(Vec3 dest) implements ParticleOptions
{
    public static final Codec<ChunkLoaderParticleOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Vec3.f_231074_.fieldOf("dest").forGetter(ChunkLoaderParticleOptions::dest)).apply((Applicative)instance, ChunkLoaderParticleOptions::new));
    public static final ParticleOptions.Deserializer<ChunkLoaderParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<ChunkLoaderParticleOptions>(){

        public ChunkLoaderParticleOptions fromCommand(ParticleType<ChunkLoaderParticleOptions> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            double x = reader.readDouble();
            reader.expect(' ');
            double y = reader.readDouble();
            reader.expect(' ');
            double z = reader.readDouble();
            return new ChunkLoaderParticleOptions(new Vec3(x, y, z));
        }

        public ChunkLoaderParticleOptions fromNetwork(ParticleType<ChunkLoaderParticleOptions> type, FriendlyByteBuf buf) {
            return new ChunkLoaderParticleOptions(new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()));
        }
    };

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeDouble(this.dest.m_7096_());
        buf.writeDouble(this.dest.m_7098_());
        buf.writeDouble(this.dest.m_7094_());
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), this.dest.m_7096_(), this.dest.m_7098_(), this.dest.m_7094_());
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)RailcraftParticleTypes.CHUNK_LOADER.get();
    }
}

