/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import mods.railcraft.particle.RailcraftParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public record TuningAuraParticleOptions(Vec3 destination, int color) implements ParticleOptions
{
    public static final Codec<TuningAuraParticleOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Vec3.f_231074_.fieldOf("destination").forGetter(TuningAuraParticleOptions::destination), (App)Codec.INT.fieldOf("color").forGetter(TuningAuraParticleOptions::color)).apply((Applicative)instance, TuningAuraParticleOptions::new));
    public static final ParticleOptions.Deserializer<TuningAuraParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<TuningAuraParticleOptions>(){

        public TuningAuraParticleOptions fromCommand(ParticleType<TuningAuraParticleOptions> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            double x = reader.readDouble();
            reader.expect(' ');
            double y = reader.readDouble();
            reader.expect(' ');
            double z = reader.readDouble();
            reader.expect(' ');
            int color = reader.readInt();
            return new TuningAuraParticleOptions(new Vec3(x, y, z), color);
        }

        public TuningAuraParticleOptions fromNetwork(ParticleType<TuningAuraParticleOptions> type, FriendlyByteBuf buf) {
            return new TuningAuraParticleOptions(new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()), buf.m_130242_());
        }
    };

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeDouble(this.destination.m_7096_());
        buf.writeDouble(this.destination.m_7098_());
        buf.writeDouble(this.destination.m_7094_());
        buf.m_130130_(this.color);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %d", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), this.destination.m_7096_(), this.destination.m_7098_(), this.destination.m_7094_(), this.color);
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)RailcraftParticleTypes.TUNING_AURA.get();
    }
}

