/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util.container;

import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class CombinedInvWrapper
implements IItemHandlerModifiable {
    private final InvWrapper inputInv;
    private final InvWrapper outputInv;

    public CombinedInvWrapper(Container inputInv, Container outputInv) {
        this.inputInv = new InvWrapper(inputInv);
        this.outputInv = new InvWrapper(outputInv);
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        if (slot < this.inputInv.getSlots()) {
            this.inputInv.setStackInSlot(slot, stack);
        }
    }

    public int getSlots() {
        return this.inputInv.getSlots() + this.outputInv.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (slot < this.inputInv.getSlots()) {
            return this.inputInv.getStackInSlot(slot);
        }
        return this.outputInv.getStackInSlot(slot - this.inputInv.getSlots());
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (slot >= this.inputInv.getSlots()) {
            return stack;
        }
        return this.inputInv.insertItem(slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot < this.inputInv.getSlots()) {
            return ItemStack.f_41583_;
        }
        return this.outputInv.extractItem(slot - this.inputInv.getSlots(), amount, simulate);
    }

    public int getSlotLimit(int slot) {
        if (slot < this.inputInv.getSlots()) {
            return this.inputInv.getSlotLimit(slot);
        }
        return this.outputInv.getSlotLimit(slot - this.inputInv.getSlots());
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        if (slot < this.inputInv.getSlots()) {
            return this.inputInv.isItemValid(slot, stack);
        }
        return false;
    }
}

