/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle.locomotive;

import java.util.Set;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.charge.ChargeCartStorageImpl;
import mods.railcraft.sounds.RailcraftSoundEvents;
import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import mods.railcraft.world.inventory.ElectricLocomotiveMenu;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.TicketItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class ElectricLocomotive
extends Locomotive
implements WorldlyContainer {
    private static final int ACTUAL_FUEL_GAIN_PER_REQUEST = 20;
    private static final int FUEL_PER_REQUEST = 1;
    private static final int CHARGE_USE_PER_REQUEST = 80;
    public static final int MAX_CHARGE = 5000;
    private static final int SLOT_TICKET = 0;
    private static final int[] SLOTS = ContainerTools.buildSlotArray(0, 1);
    private static final Set<Locomotive.Mode> ALLOWED_MODES = Set.of(Locomotive.Mode.RUNNING, Locomotive.Mode.SHUTDOWN);
    private static final EntityDataAccessor<Float> LIGHT_LEVEL = SynchedEntityData.m_135353_(ElectricLocomotive.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final Container ticketInventory = new ContainerMapper((Container)this, 0, 2).ignoreItemChecks();
    private ChargeCartStorageImpl cartStorage = new ChargeCartStorageImpl(5000);
    private final LazyOptional<IEnergyStorage> energyHandler;

    public ElectricLocomotive(EntityType<?> type, Level level) {
        super(type, level);
        this.energyHandler = LazyOptional.of(() -> this.cartStorage);
    }

    public ElectricLocomotive(ItemStack itemStack, double x, double y, double z, ServerLevel serverLevel) {
        super(itemStack, (EntityType)RailcraftEntityTypes.ELECTRIC_LOCOMOTIVE.get(), x, y, z, serverLevel);
        this.loadFromItemStack(itemStack);
        this.energyHandler = LazyOptional.of(() -> this.cartStorage);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LIGHT_LEVEL, (Object)Float.valueOf(0.0f));
    }

    @Override
    public Set<Locomotive.Mode> getSupportedModes() {
        return ALLOWED_MODES;
    }

    @Override
    protected DyeColor getDefaultPrimaryColor() {
        return DyeColor.YELLOW;
    }

    @Override
    protected DyeColor getDefaultSecondaryColor() {
        return DyeColor.BLACK;
    }

    @Override
    public SoundEvent getWhistleSound() {
        return (SoundEvent)RailcraftSoundEvents.ELECTRIC_WHISTLE.get();
    }

    @Override
    protected int getIdleFuelUse() {
        return 0;
    }

    @Override
    public int retrieveFuel() {
        if (this.cartStorage.getEnergyStored() > 80) {
            this.cartStorage.extractEnergy(80, false);
            return 20;
        }
        return 0;
    }

    @Override
    public Item m_213728_() {
        return (Item)RailcraftItems.ELECTRIC_LOCOMOTIVE.get();
    }

    @Override
    public float getOptimalDistance(RollingStock cart) {
        return 0.92f;
    }

    @Override
    protected Container ticketContainer() {
        return this.ticketInventory;
    }

    @Override
    public int m_6643_() {
        return 2;
    }

    public int[] m_7071_(Direction side) {
        return SLOTS;
    }

    public boolean m_7155_(int slot, ItemStack stack, Direction side) {
        return this.m_7013_(slot, stack);
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction side) {
        return slot == 0;
    }

    public boolean m_7013_(int slot, @Nullable ItemStack stack) {
        if (slot == 0) {
            return TicketItem.FILTER.test(stack);
        }
        return false;
    }

    @Override
    protected void serverTick(ServerLevel level) {
        super.serverTick(level);
        this.cartStorage.tick(level, (AbstractMinecart)this);
        this.f_19804_.m_135381_(LIGHT_LEVEL, (Object)Float.valueOf(Mth.m_184637_((float)this.getCharge(), (float)0.0f, (float)1.0f, (float)0.0f, (float)12.0f)));
    }

    protected void m_6401_(BlockPos pos, BlockState state) {
        super.m_6401_(pos, state);
        this.cartStorage.tickOnTrack((AbstractMinecart)this, pos);
    }

    @Override
    public boolean needsFuel() {
        return (double)this.getCharge() < 0.8;
    }

    private float getCharge() {
        return (float)this.cartStorage.getEnergyStored() / (float)this.cartStorage.getMaxEnergyStored();
    }

    public float getLightLevel() {
        return ((Float)this.f_19804_.m_135370_(LIGHT_LEVEL)).floatValue();
    }

    public IEnergyStorage getBatteryCart() {
        return this.cartStorage;
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.cartStorage.receiveEnergy(tag.m_128451_("energy"), false);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("energy", this.cartStorage.getEnergyStored());
    }

    @Override
    protected void loadFromItemStack(ItemStack itemStack) {
        super.loadFromItemStack(itemStack);
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null && tag.m_128441_("energy")) {
            this.cartStorage.receiveEnergy(tag.m_128451_("energy"), false);
        }
    }

    @Override
    public ItemStack m_142340_() {
        ItemStack itemStack = super.m_142340_();
        itemStack.m_41784_().m_128405_("energy", this.cartStorage.getEnergyStored());
        return itemStack;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        return ForgeCapabilities.ENERGY == capability ? this.energyHandler.cast() : super.getCapability(capability, facing);
    }

    protected AbstractContainerMenu m_7402_(int id, Inventory playerInventory) {
        return new ElectricLocomotiveMenu(id, playerInventory, this);
    }
}

