/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import com.google.common.collect.MapMaker;
import java.util.Map;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.Translations;
import mods.railcraft.advancements.RailcraftCriteriaTriggers;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.carts.Train;
import mods.railcraft.api.item.Crowbar;
import mods.railcraft.season.Season;
import mods.railcraft.world.entity.vehicle.Directional;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.entity.vehicle.SeasonalCart;
import mods.railcraft.world.entity.vehicle.TrackRemover;
import mods.railcraft.world.entity.vehicle.TunnelBore;
import mods.railcraft.world.item.SeasonsCrowbarItem;
import mods.railcraft.world.item.enchantment.RailcraftEnchantments;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class CrowbarHandler {
    private static final float SMACK_VELOCITY = 0.07f;
    private static final Map<ServerPlayer, RollingStock> linkMap = new MapMaker().weakKeys().weakValues().makeMap();

    private CrowbarHandler() {
    }

    public static InteractionResult handleInteract(AbstractMinecart cart, Player player, InteractionHand hand) {
        Item item;
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof Crowbar)) {
            return InteractionResult.PASS;
        }
        Crowbar crowbar = (Crowbar)item;
        Level level = player.m_9236_();
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (stack.m_41720_() instanceof SeasonsCrowbarItem && cart instanceof SeasonalCart) {
            SeasonalCart seasonalCart = (SeasonalCart)cart;
            if (((Boolean)RailcraftConfig.COMMON.seasonsEnabled.get()).booleanValue()) {
                Season season = SeasonsCrowbarItem.getSeason(stack);
                seasonalCart.setSeason(season);
                RailcraftCriteriaTriggers.SEASON_SET.trigger(serverPlayer, cart, season);
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        }
        if (crowbar.canLink(player, hand, stack, cart)) {
            CrowbarHandler.linkCart(serverPlayer, hand, stack, cart, crowbar);
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        if (crowbar.canBoost(player, hand, stack, cart)) {
            CrowbarHandler.boostCart((Player)serverPlayer, hand, stack, cart, crowbar);
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    private static void linkCart(ServerPlayer player, InteractionHand hand, ItemStack stack, AbstractMinecart cart, Crowbar crowbar) {
        RollingStock extension = RollingStock.getOrThrow(cart);
        RollingStock last = linkMap.remove(player);
        if (last == null || !last.entity().m_6084_()) {
            linkMap.put(player, extension);
            MutableComponent message = Component.m_237115_((String)Translations.Tips.CROWBAR_LINK_STARTED).m_130940_(ChatFormatting.LIGHT_PURPLE);
            player.m_5661_((Component)message, true);
            return;
        }
        if (extension.unlink(last)) {
            MutableComponent message = Component.m_237115_((String)Translations.Tips.CROWBAR_LINK_BROKEN).m_130940_(ChatFormatting.LIGHT_PURPLE);
            player.m_5661_((Component)message, true);
        } else {
            if (!last.link(extension)) {
                MutableComponent message = Component.m_237115_((String)Translations.Tips.CROWBAR_LINK_FAILED).m_130940_(ChatFormatting.RED);
                player.m_5661_((Component)message, true);
                return;
            }
            RailcraftCriteriaTriggers.CART_LINK.trigger(player, last.entity(), cart);
            MutableComponent message = Component.m_237115_((String)Translations.Tips.CROWBAR_LINK_CREATED).m_130940_(ChatFormatting.GREEN);
            player.m_5661_((Component)message, true);
        }
        crowbar.onLink((Player)player, hand, stack, cart);
    }

    private static void boostCart(Player player, InteractionHand hand, ItemStack stack, AbstractMinecart cart, Crowbar crowbar) {
        player.m_36399_(0.25f);
        if (player.m_20202_() != null || cart instanceof TunnelBore) {
            return;
        }
        if (cart instanceof Directional) {
            Directional directional = (Directional)cart;
            directional.reverse();
        } else if (cart instanceof TrackRemover) {
            TrackRemover trackRemover = (TrackRemover)cart;
            trackRemover.setMode(trackRemover.mode().next());
        } else {
            int lvl = stack.getEnchantmentLevel((Enchantment)RailcraftEnchantments.SMACK.get());
            if (lvl == 0) {
                MinecartUtil.smackCart(cart, player, 0.07f);
            }
            RollingStock extension = RollingStock.getOrThrow(cart);
            Train train = extension.train();
            float smackVelocity = 0.07f * (float)Math.pow(1.7, lvl) / (float)Math.pow(train.size(), 1.0 / (double)(1 + lvl));
            train.entities().forEach(each -> MinecartUtil.smackCart(cart, each, player, smackVelocity));
        }
        crowbar.onBoost(player, hand, stack, cart);
    }
}

