/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import java.util.List;
import mods.railcraft.Translations;
import mods.railcraft.season.Season;
import mods.railcraft.world.item.CrowbarItem;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SeasonsCrowbarItem
extends CrowbarItem {
    public SeasonsCrowbarItem(Item.Properties properties) {
        super(2.5f, -2.4f, (Tier)Tiers.DIAMOND, properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!level.m_5776_()) {
            SeasonsCrowbarItem.incrementSeason(itemStack);
            Season season = SeasonsCrowbarItem.getSeason(itemStack);
            player.m_5661_(SeasonsCrowbarItem.getDescriptionText(season, false), true);
        }
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
    }

    public boolean m_6832_(ItemStack itemToRepair, ItemStack stack) {
        return false;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag adv) {
        Season season = SeasonsCrowbarItem.getSeason(stack);
        list.add(SeasonsCrowbarItem.getDescriptionText(season, true));
    }

    public static Season getSeason(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        return Season.fromName(tag.m_128461_("season"));
    }

    private static void incrementSeason(ItemStack itemStack) {
        Season season = SeasonsCrowbarItem.getSeason(itemStack).getNext();
        itemStack.m_41784_().m_128359_("season", season.m_7912_());
    }

    private static Component getDescriptionText(Season value, boolean tooltip) {
        MutableComponent title = Component.m_237115_((String)Translations.Tips.CROWBAR_SEASON_DESC);
        if (tooltip) {
            title.m_130940_(ChatFormatting.GRAY);
        }
        return title.m_130946_(" ").m_7220_((Component)value.getDisplayName().m_6881_().m_130940_(ChatFormatting.DARK_PURPLE));
    }
}

