/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import java.util.List;
import mods.railcraft.Translations;
import mods.railcraft.api.signal.entity.SignalControllerEntity;
import mods.railcraft.api.signal.entity.SignalReceiverEntity;
import mods.railcraft.world.item.PairingToolItem;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SignalTunerItem
extends PairingToolItem<SignalControllerEntity, SignalReceiverEntity> {
    public SignalTunerItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)Translations.Tips.LINKS_CONTROLLERS_TO_RECEIVERS).m_130940_(ChatFormatting.GRAY));
    }

    @Override
    protected Class<SignalControllerEntity> targetType() {
        return SignalControllerEntity.class;
    }

    @Override
    protected Class<SignalReceiverEntity> peerType() {
        return SignalReceiverEntity.class;
    }

    @Override
    protected Component getMessageForState(PairingToolItem.State state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case PairingToolItem.State.ABANDONED -> Component.m_237115_((String)Translations.Signal.SIGNAL_TUNER_ABANDONED).m_130940_(ChatFormatting.LIGHT_PURPLE);
            case PairingToolItem.State.LOST_TARGET -> Component.m_237115_((String)Translations.Signal.SIGNAL_TUNER_LOST).m_130940_(ChatFormatting.RED);
            case PairingToolItem.State.INVALID_TARGET -> Component.m_237115_((String)Translations.Signal.SIGNAL_TUNER_INVALID_CONTROLLER).m_130940_(ChatFormatting.RED);
            case PairingToolItem.State.INVALID_PEER -> Component.m_237115_((String)Translations.Signal.SIGNAL_TUNER_INVALID_RECEIVER).m_130940_(ChatFormatting.RED);
        };
    }

    @Override
    protected void abandon(@Nullable SignalControllerEntity target) {
        if (target != null) {
            target.getSignalController().stopLinking();
        }
    }

    @Override
    protected PairingToolItem.Result begin(SignalControllerEntity target) {
        target.getSignalController().startLinking();
        return PairingToolItem.Result.success((Component)Component.m_237110_((String)Translations.Signal.SIGNAL_TUNER_BEGIN, (Object[])new Object[]{target.m_5446_()}).m_130940_(ChatFormatting.LIGHT_PURPLE));
    }

    @Override
    protected PairingToolItem.Result complete(SignalControllerEntity target, SignalReceiverEntity peer) {
        boolean success = target.getSignalController().addPeer(peer);
        target.getSignalController().stopLinking();
        return new PairingToolItem.Result(success, (Component)(success ? Component.m_237110_((String)Translations.Signal.SIGNAL_TUNER_SUCCESS, (Object[])new Object[]{peer.m_5446_(), target.m_5446_()}).m_130940_(ChatFormatting.GREEN) : Component.m_237110_((String)Translations.Signal.SIGNAL_TUNER_ALREADY_PAIRED, (Object[])new Object[]{peer.m_5446_(), target.m_5446_()}).m_130940_(ChatFormatting.RED)));
    }
}

