/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import java.util.Deque;
import java.util.Optional;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.track.SwitchActuator;
import mods.railcraft.util.PlayerUtil;
import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.util.routing.RouterBlockEntity;
import mods.railcraft.util.routing.RoutingLogic;
import mods.railcraft.util.routing.RoutingLogicException;
import mods.railcraft.world.inventory.SwitchTrackRouterMenu;
import mods.railcraft.world.level.block.entity.LockableSwitchTrackActuatorBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.track.actuator.SwitchTrackActuatorBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SwitchTrackRouterBlockEntity
extends LockableSwitchTrackActuatorBlockEntity
implements RouterBlockEntity,
SwitchActuator {
    private final AdvancedContainer container;
    @Nullable
    private Either<RoutingLogic, RoutingLogicException> logic;
    private RouterBlockEntity.Railway railway = RouterBlockEntity.Railway.PUBLIC;
    private boolean powered;

    public SwitchTrackRouterBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.SWITCH_TRACK_ROUTER.get(), blockPos, blockState);
        this.container = new AdvancedContainer(1).listener(this);
    }

    @Override
    public void neighborChanged() {
        this.powered = this.f_58857_.m_276867_(this.m_58899_());
        this.m_6596_();
    }

    @Override
    public RouterBlockEntity.Railway getRailway() {
        return this.railway;
    }

    @Override
    public void setRailway(@Nullable GameProfile gameProfile) {
        RouterBlockEntity.Railway railway = this.railway = gameProfile == null ? RouterBlockEntity.Railway.PUBLIC : RouterBlockEntity.Railway.PRIVATE;
        if (!this.isLocked()) {
            this.setOwner(gameProfile);
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("container", (Tag)this.container.m_7927_());
        tag.m_128359_("railway", this.railway.m_7912_());
        tag.m_128379_("powered", this.powered);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.container.m_7797_(tag.m_128437_("container", 10));
        this.railway = RouterBlockEntity.Railway.fromName(tag.m_128461_("railway"));
        this.powered = tag.m_128471_("powered");
    }

    @Override
    public void writeToBuf(FriendlyByteBuf data) {
        super.writeToBuf(data);
        data.m_130068_((Enum)this.railway);
        data.writeBoolean(this.powered);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf data) {
        super.readFromBuf(data);
        this.railway = (RouterBlockEntity.Railway)data.m_130066_(RouterBlockEntity.Railway.class);
        this.powered = data.readBoolean();
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public Optional<Either<RoutingLogic, RoutingLogicException>> logicResult() {
        this.refreshLogic();
        return Optional.ofNullable(this.logic);
    }

    @Override
    public void resetLogic() {
        this.logic = null;
    }

    private void refreshLogic() {
        ItemStack item;
        if (this.logic == null && !this.container.m_8020_(0).m_41619_() && (item = this.container.m_8020_(0)).m_41783_() != null && item.m_41783_().m_128441_("pages")) {
            Deque content = this.loadPages(item.m_41783_());
            try {
                this.logic = Either.left((Object)RoutingLogic.parseTable(content));
            }
            catch (RoutingLogicException e) {
                this.logic = Either.right((Object)e);
            }
        }
    }

    @Override
    public boolean shouldSwitch(RollingStock rollingStock) {
        boolean shouldSwitch = this.logic().map(logic -> logic.matches(this, rollingStock)).orElse(false);
        if (this.railway == RouterBlockEntity.Railway.PRIVATE) {
            shouldSwitch = rollingStock.owner().filter(owner -> PlayerUtil.isSamePlayer(owner, this.getOwnerOrThrow())).isPresent();
        }
        SwitchTrackActuatorBlock.setSwitched(this.m_58900_(), this.f_58857_, this.m_58899_(), shouldSwitch);
        return shouldSwitch;
    }

    @Override
    public Container container() {
        return this.container;
    }

    @Override
    public boolean m_6542_(Player player) {
        return this.isStillValid(player);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new SwitchTrackRouterMenu(id, inventory, this);
    }
}

