/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.manipulator;

import mods.railcraft.RailcraftConfig;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.util.LevelUtil;
import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.inventory.CartDispenserMenu;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.manipulator.ManipulatorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CartDispenserBlockEntity
extends ManipulatorBlockEntity
implements MenuProvider {
    protected boolean powered;
    protected int timeSinceLastSpawn;

    public CartDispenserBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RailcraftBlockEntityTypes.CART_DISPENSER.get(), pos, state);
        this.setContainerSize(3);
    }

    protected CartDispenserBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, CartDispenserBlockEntity blockEntity) {
        if (blockEntity.timeSinceLastSpawn < Integer.MAX_VALUE) {
            ++blockEntity.timeSinceLastSpawn;
        }
    }

    @Override
    protected boolean hasWorkForCart(AbstractMinecart cart) {
        return false;
    }

    @Override
    protected void processCart(AbstractMinecart cart) {
    }

    public void onNeighborChange() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        boolean newPowered = this.isPowered();
        if (!this.powered && newPowered) {
            this.powered = true;
            this.setPowered(true);
            this.onPulse(serverLevel);
        } else {
            this.powered = newPowered;
            this.setPowered(this.powered);
        }
    }

    protected void onPulse(ServerLevel serverLevel) {
        EntitySearcher.findMinecarts().at(this.m_58899_().m_121955_(this.getFacing().m_122436_())).stream((Level)serverLevel).findAny().ifPresentOrElse(cart -> {
            ItemStack remainder;
            if (!cart.m_6084_()) {
                return;
            }
            AdvancedContainer coppiedContainer = AdvancedContainer.copyOf(this);
            ItemStack cartStack = cart.m_142340_();
            if (cart.m_8077_()) {
                cartStack.m_41714_(cart.m_7755_());
            }
            if ((remainder = coppiedContainer.insert(cartStack.m_41777_())).m_41619_()) {
                this.insert(cartStack);
                if (!cart.m_20197_().isEmpty()) {
                    MinecartUtil.removePassengers(cart);
                }
                cart.m_6074_();
            }
        }, () -> {
            if (this.timeSinceLastSpawn > (Integer)RailcraftConfig.SERVER.cartDispenserDelay.get() * 20) {
                for (int i = 0; i < this.m_6643_(); ++i) {
                    ItemStack cartStack = this.m_8020_(i);
                    if (cartStack.m_41619_()) continue;
                    BlockPos pos = this.m_58899_().m_121955_(this.getFacing().m_122436_());
                    AbstractMinecart placedCart = MinecartUtil.placeCart(cartStack, serverLevel, pos);
                    if (placedCart != null) {
                        this.m_7407_(i, 1);
                        this.timeSinceLastSpawn = 0;
                        break;
                    }
                    LevelUtil.spewItem(cartStack, this.f_58857_, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                    this.m_6836_(i, ItemStack.f_41583_);
                }
            }
        });
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new CartDispenserMenu(id, inventory, this);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("powered", this.powered);
        tag.m_128405_("timeSinceLastSpawn", this.timeSinceLastSpawn);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.powered = tag.m_128471_("powered");
        this.timeSinceLastSpawn = tag.m_128451_("timeSinceLastSpawn");
    }

    @Override
    public void writeToBuf(FriendlyByteBuf data) {
        super.writeToBuf(data);
        data.writeBoolean(this.powered);
        data.writeInt(this.timeSinceLastSpawn);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf data) {
        super.readFromBuf(data);
        this.powered = data.readBoolean();
        this.timeSinceLastSpawn = data.readInt();
    }
}

