/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.multiblock;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

@FunctionalInterface
public interface BlockPredicate {
    public static final BlockPredicate AIR = (level, blockPos) -> level.m_8055_(blockPos).m_60795_();

    public boolean test(ServerLevel var1, BlockPos var2);

    default public BlockPredicate and(BlockPredicate other) {
        Objects.requireNonNull(other);
        return (level, blockPos) -> this.test(level, blockPos) && other.test(level, blockPos);
    }

    default public BlockPredicate negate() {
        return (level, blockPos) -> !this.test(level, blockPos);
    }

    default public BlockPredicate or(BlockPredicate other) {
        Objects.requireNonNull(other);
        return (level, blockPos) -> this.test(level, blockPos) || other.test(level, blockPos);
    }

    public static BlockPredicate ofFluidTag(TagKey<Fluid> tag) {
        return (level, blockPos) -> level.m_6425_(blockPos).m_205070_(tag);
    }

    public static BlockPredicate ofFluid(Fluid fluid) {
        return BlockPredicate.ofFluid(() -> fluid);
    }

    public static BlockPredicate ofFluid(Supplier<Fluid> fluid) {
        return (level, blockPos) -> level.m_6425_(blockPos).m_192917_((Fluid)fluid.get());
    }

    public static BlockPredicate ofTag(TagKey<Block> tag) {
        return (level, blockPos) -> level.m_8055_(blockPos).m_204336_(tag);
    }

    public static BlockPredicate of(Block block) {
        return BlockPredicate.of(() -> block);
    }

    public static BlockPredicate of(Supplier<? extends Block> block) {
        return (level, blockPos) -> level.m_8055_(blockPos).m_60713_((Block)block.get());
    }
}

