/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.signal;

import java.util.HashSet;
import java.util.Set;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.RedstoneUtil;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.signal.AbstractSignalBoxBlockEntity;
import mods.railcraft.world.level.block.entity.signal.SignalCapacitorBoxBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SignalSequencerBoxBlockEntity
extends AbstractSignalBoxBlockEntity {
    private static final int MAX_ITERATIONS = 64;
    private Direction outputDirection = Direction.NORTH;
    private boolean powered;
    private boolean neighborSignal;

    public SignalSequencerBoxBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.SIGNAL_SEQUENCER_BOX.get(), blockPos, blockState);
    }

    @Override
    public void neighborChanged() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        boolean powered = RedstoneUtil.hasRepeaterSignal(this.f_58857_, this.m_58899_());
        if (!this.powered && powered) {
            this.powered = true;
            this.incrementSequencer(true, new HashSet<BlockEntity>(), 0);
        } else {
            this.powered = powered;
        }
    }

    @Override
    public void neighborSignalBoxChanged(AbstractSignalBoxBlockEntity neighborSignalBox, Direction neighborDirection, boolean removed) {
        boolean signal;
        if (this.f_58857_.m_5776_() || neighborSignalBox instanceof SignalSequencerBoxBlockEntity || neighborSignalBox instanceof SignalCapacitorBoxBlockEntity) {
            return;
        }
        boolean bl = signal = neighborSignalBox.getRedstoneSignal(neighborDirection) > 0;
        if (!this.neighborSignal && signal) {
            this.neighborSignal = true;
            this.incrementSequencer(true, new HashSet<BlockEntity>(), 0);
        } else {
            this.neighborSignal = signal;
        }
    }

    private void incrementSequencer(boolean firstPass, Set<BlockEntity> visitedFirstPass, int numberOfIterations) {
        if (firstPass) {
            visitedFirstPass.add(this);
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(this.outputDirection));
            if (blockEntity instanceof SignalSequencerBoxBlockEntity) {
                SignalSequencerBoxBlockEntity signalBox = (SignalSequencerBoxBlockEntity)blockEntity;
                if (!visitedFirstPass.contains(blockEntity)) {
                    signalBox.incrementSequencer(true, visitedFirstPass, numberOfIterations);
                    return;
                }
            }
        }
        Direction lastOutputDirection = this.outputDirection;
        do {
            this.outputDirection = this.outputDirection.m_122427_();
        } while (!this.canOutputToDirection(this.outputDirection) && lastOutputDirection != this.outputDirection);
        this.m_6596_();
        if (numberOfIterations >= 64) {
            return;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(this.outputDirection));
        if (blockEntity instanceof SignalSequencerBoxBlockEntity) {
            SignalSequencerBoxBlockEntity signalBox = (SignalSequencerBoxBlockEntity)blockEntity;
            signalBox.incrementSequencer(false, visitedFirstPass, numberOfIterations + 1);
        }
    }

    private boolean canOutputToDirection(Direction direction) {
        BlockState blockState = this.f_58857_.m_8055_(this.m_58899_().m_121945_(direction));
        if (blockState.m_60713_(this.m_58900_().m_60734_()) || blockState.m_204336_(RailcraftTags.Blocks.ASPECT_RECEIVER)) {
            return true;
        }
        Block block = blockState.m_60734_();
        if (block == Blocks.f_50088_) {
            return true;
        }
        if (block == Blocks.f_50146_) {
            Direction facing = (Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            return direction.m_122424_() == facing;
        }
        return false;
    }

    @Override
    public void m_6596_() {
        super.m_6596_();
        this.syncToClient();
    }

    @Override
    public int getRedstoneSignal(Direction direction) {
        return this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction)) instanceof AbstractSignalBoxBlockEntity ? 0 : (this.outputDirection.m_122424_() == direction ? 15 : 0);
    }

    @Override
    public SignalAspect getSignalAspect(Direction direction) {
        return this.outputDirection == direction ? SignalAspect.GREEN : SignalAspect.RED;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("outputDirection", this.outputDirection.m_122433_());
        tag.m_128379_("powered", this.powered);
        tag.m_128379_("neighborSignal", this.neighborSignal);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.outputDirection = Direction.m_122402_((String)tag.m_128461_("outputDirection"));
        this.powered = tag.m_128471_("powered");
        this.neighborSignal = tag.m_128471_("neighborSignal");
    }

    @Override
    public void writeToBuf(FriendlyByteBuf data) {
        super.writeToBuf(data);
        data.m_130130_(this.outputDirection.m_122411_());
    }

    @Override
    public void readFromBuf(FriendlyByteBuf data) {
        super.readFromBuf(data);
        this.outputDirection = Direction.m_122376_((int)data.m_130242_());
    }
}

