/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.track;

import mods.railcraft.api.track.RailShapeUtil;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.level.block.entity.track.LockingTrackBlockEntity;
import mods.railcraft.world.level.block.track.TrackBlock;
import mods.railcraft.world.level.block.track.outfitted.LockingModeController;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;

public class HoldingLockingProfile
implements LockingModeController {
    protected static final float DIR_THRESHOLD = 0.01f;
    protected boolean launchForward = true;
    private final LockingTrackBlockEntity lockingTrack;

    public HoldingLockingProfile(LockingTrackBlockEntity lockingTrack) {
        this.lockingTrack = lockingTrack;
    }

    @Override
    public void locked(AbstractMinecart cart) {
        this.setLaunchDirection(cart);
    }

    @Override
    public void passed(AbstractMinecart cart) {
        this.setLaunchDirection(cart);
    }

    @Override
    public void released(AbstractMinecart cart) {
        RailShape railShape = TrackBlock.getRailShapeRaw(this.lockingTrack.m_58900_());
        cart.m_20256_(this.applyBoost(RailShapeUtil.isNorthSouth(railShape) ? Direction.Axis.Z : Direction.Axis.X, cart.m_20184_()));
    }

    private Vec3 applyBoost(Direction.Axis axis, Vec3 deltaMovement) {
        double boost;
        double speed = MinecartUtil.getCartSpeedUncapped(deltaMovement);
        double d = boost = speed > 0.005 ? Math.abs(deltaMovement.m_82507_(axis)) / speed * 0.06 : 0.04;
        Vec3 newDeltaMovement = this.launchForward ? deltaMovement.m_82520_(axis == Direction.Axis.X ? boost : 0.0, 0.0, axis == Direction.Axis.Z ? boost : 0.0) : deltaMovement.m_82492_(axis == Direction.Axis.X ? boost : 0.0, 0.0, axis == Direction.Axis.Z ? boost : 0.0);
        return newDeltaMovement;
    }

    protected void setLaunchDirection(AbstractMinecart cart) {
        RailShape railShape = TrackBlock.getRailShapeRaw(this.lockingTrack.m_58900_());
        Vec3 deltaMovement = cart.m_20184_();
        if (MinecartUtil.getCartSpeedUncapped(deltaMovement) > (double)0.01f) {
            this.launchForward = RailShapeUtil.isNorthSouth(railShape) ? deltaMovement.m_7094_() > 0.0 : deltaMovement.m_7096_() > 0.0;
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("launchForward", this.launchForward);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        this.launchForward = tag.m_128471_("launchForward");
    }
}

