/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track;

import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.util.BoxBuilder;
import mods.railcraft.util.EntitySearcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ElevatorTrackBlock
extends Block {
    public static final byte ELEVATOR_TIMER = 20;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    protected static final VoxelShape EAST_SHAPE = ElevatorTrackBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_SHAPE = ElevatorTrackBlock.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = ElevatorTrackBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_SHAPE = ElevatorTrackBlock.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    public static final double FALL_DOWN_CORRECTION = (double)0.04f;
    public static final double RIDE_VELOCITY = 0.4;

    public ElevatorTrackBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWERED});
    }

    private boolean canAttachTo(BlockGetter world, BlockPos pos, Direction direction) {
        BlockState blockstate = world.m_8055_(pos);
        return blockstate.m_60783_(world, pos, direction);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return this.canAttachTo((BlockGetter)world, pos.m_121945_(direction.m_122424_()), direction);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos newPos) {
        if (direction.m_122424_() == state.m_61143_((Property)FACING) && !state.m_60710_((LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, newState, world, pos, newPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate;
        if (!context.m_7058_() && (blockstate = context.m_43725_().m_8055_(context.m_8083_().m_121945_(context.m_43719_().m_122424_()))).m_60713_((Block)this) && blockstate.m_61143_((Property)FACING) == context.m_43719_()) {
            return null;
        }
        BlockState defaultBlockState = this.m_49966_();
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        for (Direction direction : context.m_6232_()) {
            if (!direction.m_122434_().m_122479_() || !(defaultBlockState = (BlockState)defaultBlockState.m_61124_((Property)FACING, (Comparable)direction.m_122424_())).m_60710_((LevelReader)level, pos)) continue;
            return defaultBlockState;
        }
        return null;
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public static boolean getPowered(BlockGetter world, BlockPos pos) {
        return ElevatorTrackBlock.getPowered(world.m_8055_(pos));
    }

    public static boolean getPowered(BlockState state) {
        return (Boolean)state.m_61143_((Property)POWERED);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            default -> EAST_SHAPE;
        };
    }

    public void m_6402_(Level level, BlockPos pos, BlockState blockState, LivingEntity placer, ItemStack stack) {
        boolean powered = ElevatorTrackBlock.getPowered(blockState);
        if (powered != this.determinePowered(level, pos, blockState)) {
            level.m_46597_(pos, (BlockState)blockState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(!powered)));
        }
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean something) {
        super.m_6861_(blockState, level, pos, neighborBlock, neighborPos, something);
        boolean powered = ElevatorTrackBlock.getPowered(blockState);
        if (powered != this.determinePowered(level, pos, blockState)) {
            level.m_46597_(pos, (BlockState)blockState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(!powered)));
        }
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos pos, Entity entityIn) {
        entityIn.f_19789_ = 0.0f;
        if (level.m_5776_() || !(entityIn instanceof AbstractMinecart)) {
            return;
        }
        this.minecartInteraction(level, (AbstractMinecart)entityIn, pos);
    }

    protected boolean determinePowered(Level level, BlockPos pos, BlockState state) {
        BlockPos posUp = pos.m_7494_();
        BlockState stateUp = level.m_8055_(posUp);
        return level.m_276867_(pos) || stateUp.m_60734_() == this && this.determinePowered(level, posUp, stateUp);
    }

    protected void minecartInteraction(Level level, AbstractMinecart cart, BlockPos pos) {
        RollingStock.getOrThrow(cart).setElevatorRemainingTicks(20);
        cart.m_20242_(true);
        BlockState state = level.m_8055_(pos);
        this.keepMinecartConnected(pos, state, cart);
        boolean up = ElevatorTrackBlock.getPowered(state);
        boolean hasPath = up ? this.moveUp(level, state, cart, pos) : this.moveDown(level, state, cart, pos);
        if (!hasPath) {
            this.pushMinecartOntoRail(level, pos, state, cart, up);
        }
    }

    private boolean moveUp(Level level, BlockState state, AbstractMinecart cart, BlockPos pos) {
        boolean hasPath;
        BlockPos posUp = pos.m_7494_();
        boolean bl = hasPath = level.m_8055_(posUp).m_60713_((Block)this) && ElevatorTrackBlock.getPowered((BlockGetter)level, posUp);
        if (hasPath) {
            if (this.isPathEmpty(state, cart, posUp, true)) {
                Vec3 motion = cart.m_20184_();
                cart.m_20334_(motion.m_7096_(), 0.4, motion.m_7094_());
            } else {
                this.holdPosition(state, cart, pos);
            }
            return true;
        }
        return false;
    }

    private boolean moveDown(Level level, BlockState state, AbstractMinecart cart, BlockPos pos) {
        boolean hasPath;
        BlockPos posDown = pos.m_7495_();
        boolean bl = hasPath = level.m_8055_(posDown).m_60713_((Block)this) && !ElevatorTrackBlock.getPowered((BlockGetter)level, posDown);
        if (hasPath) {
            if (this.isPathEmpty(state, cart, posDown, false)) {
                Vec3 motion = cart.m_20184_();
                cart.m_20334_(motion.m_7096_(), -0.4, motion.m_7094_());
            } else {
                this.holdPosition(state, cart, pos);
            }
            return true;
        }
        return false;
    }

    private void holdPosition(BlockState state, AbstractMinecart cart, BlockPos pos) {
        cart.m_7678_(cart.m_20185_(), (double)pos.m_123342_() - (double)cart.m_20206_() / 2.0 + 0.5, cart.m_20189_(), this.getCartRotation(state, cart), 0.0f);
        cart.m_20256_(cart.m_20184_().m_82542_(1.0, 0.0, 1.0));
    }

    protected void keepMinecartConnected(BlockPos pos, BlockState state, AbstractMinecart cart) {
        if (BaseRailBlock.m_49364_((Level)cart.m_9236_(), (BlockPos)pos.m_7495_()) || BaseRailBlock.m_49364_((Level)cart.m_9236_(), (BlockPos)pos.m_6625_(2))) {
            cart.setCanUseRail(false);
        } else {
            cart.setCanUseRail(true);
        }
        Vec3 motion = cart.m_20184_();
        cart.m_20334_((double)pos.m_123341_() + 0.5 - cart.m_20185_(), motion.m_7098_(), (double)pos.m_123343_() + 0.5 - cart.m_20189_());
        this.alignMinecart(state, cart);
    }

    protected void alignMinecart(BlockState state, AbstractMinecart cart) {
        cart.m_146922_(this.getCartRotation(state, cart));
    }

    private float getCartRotation(BlockState state, AbstractMinecart cart) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122430_();
    }

    private boolean isPathEmpty(BlockState state, AbstractMinecart cart, BlockPos pos, boolean up) {
        if (cart.m_9236_().m_8055_(pos).m_280296_()) {
            return false;
        }
        Direction.Axis axis = ((Direction)state.m_61143_((Property)FACING)).m_122434_();
        BoxBuilder factory = BoxBuilder.create().at(pos).expandAxis(axis, 1.0);
        if (up) {
            factory.raiseCeiling(0.5);
            factory.raiseFloor(0.2);
        } else {
            factory.raiseCeiling(-0.2);
            factory.raiseFloor(-0.5);
        }
        return EntitySearcher.findMinecarts().in(factory.build()).except((Entity)cart).list(cart.m_9236_()).isEmpty();
    }

    private boolean pushMinecartOntoRail(Level level, BlockPos pos, BlockState state, AbstractMinecart cart, boolean up) {
        cart.setCanUseRail(true);
        Direction.Axis axis = ((Direction)state.m_61143_((Property)FACING)).m_122434_();
        for (BlockPos target : new BlockPos[]{pos, up ? pos.m_7494_() : pos.m_7495_()}) {
            for (Direction.AxisDirection direction : Direction.AxisDirection.values()) {
                if (!BaseRailBlock.m_49364_((Level)level, (BlockPos)target.m_121945_(Direction.m_122390_((Direction.AxisDirection)direction, (Direction.Axis)axis)))) continue;
                this.holdPosition(state, cart, target);
                double vel = (double)direction.m_122540_() * 0.4;
                Vec3 motion = cart.m_20184_();
                if (axis == Direction.Axis.Z) {
                    cart.m_20334_(motion.m_7096_(), motion.m_7098_(), vel);
                } else {
                    cart.m_20334_(vel, motion.m_7098_(), motion.m_7094_());
                }
                return true;
            }
        }
        return false;
    }
}

