/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.module;

import java.util.Collection;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.util.fluids.FluidTools;
import mods.railcraft.world.level.block.entity.WaterTankSidingBlockEntity;
import mods.railcraft.world.level.material.StandardTank;
import mods.railcraft.world.module.BlockModuleProvider;
import mods.railcraft.world.module.ContainerModule;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class WaterCollectionModule
extends ContainerModule<BlockModuleProvider> {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_PROCESS = 1;
    public static final int SLOT_OUTPUT = 2;
    private static final int REFILL_INTERVAL = 20;
    private static final float REFILL_PENALTY_FROZEN = 0.5f;
    private static final float REFILL_BOOST_RAIN = 3.0f;
    private final WaterTankSidingBlockEntity blockEntity;
    private final StandardTank tank;
    private final LazyOptional<IFluidHandler> fluidHandler;
    private State state = State.INACTIVE;
    private int refillTicks;
    private FluidTools.ProcessState processState = FluidTools.ProcessState.RESET;
    private int processTicks;

    public WaterCollectionModule(WaterTankSidingBlockEntity provider) {
        super(provider, 3);
        this.blockEntity = provider;
        this.tank = StandardTank.ofBuckets((Integer)RailcraftConfig.SERVER.tankCapacityPerBlock.get() * 26);
        this.fluidHandler = LazyOptional.of(() -> this.tank);
    }

    public State getState() {
        return this.state;
    }

    @Override
    public void serverTick() {
        Level level = ((BlockModuleProvider)this.provider).level();
        if (this.refillTicks++ >= 20) {
            this.refillTicks = 0;
            BlockPos above = ((BlockModuleProvider)this.provider).blockPos().m_7494_();
            this.state = State.create(level, above);
            int rate = this.state.calculateRate(this.calculateMultiplier());
            if (rate > 0) {
                this.tank.fill(new FluidStack((Fluid)Fluids.f_76193_, rate), IFluidHandler.FluidAction.EXECUTE);
            } else {
                this.tank.drain(new FluidStack((Fluid)Fluids.f_76193_, Math.abs(rate)), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        if (this.processTicks++ >= 8) {
            this.processTicks = 0;
            this.processState = FluidTools.processContainer(this, this.tank, FluidTools.ProcessType.DRAIN_THEN_FILL, this.processState);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean m_7013_(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                if (!this.tank.isEmpty() && FluidTools.isRoomInContainer(stack, this.tank.getFluidType())) break;
                if (!FluidUtil.getFluidContained((ItemStack)stack).isPresent()) return false;
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            default: {
                return false;
            }
        }
        if (!super.m_7013_(slot, stack)) return false;
        return true;
    }

    private int calculateMultiplier() {
        if (this.blockEntity.getMembers().isEmpty()) {
            return 1;
        }
        return (int)this.blockEntity.getMembers().stream().flatMap(Collection::stream).flatMap(member -> member.getModule(WaterCollectionModule.class).stream()).map(WaterCollectionModule::getState).filter(State::skyVisible).count();
    }

    public StandardTank getTank() {
        return this.tank;
    }

    public LazyOptional<IFluidHandler> getFluidHandler() {
        return this.fluidHandler;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        tag.m_128359_("processState", this.processState.m_7912_());
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.tank.readFromNBT(tag.m_128469_("tank"));
        this.processState = FluidTools.ProcessState.fromTag(tag);
    }

    @Override
    public void writeToBuf(FriendlyByteBuf out) {
        super.writeToBuf(out);
        out.m_130130_(this.tank.getCapacity());
        out.writeFluidStack(this.tank.getFluid());
    }

    @Override
    public void readFromBuf(FriendlyByteBuf in) {
        super.readFromBuf(in);
        this.tank.setCapacity(in.m_130242_());
        this.tank.setFluid(in.readFluidStack());
    }

    public record State(boolean skyVisible, double temperaturePenalty, double humidityMultiplier, double precipitationMultiplier) {
        public static final State INACTIVE = new State(false, 0.0, 1.0, 1.0);

        public int calculateRate(int size) {
            return Mth.m_14107_((double)((double)((Integer)RailcraftConfig.SERVER.waterCollectionRate.get() * size) * this.humidityMultiplier * this.precipitationMultiplier - this.temperaturePenalty));
        }

        public static State create(Level level, BlockPos pos) {
            if (!level.m_45527_(pos)) {
                return INACTIVE;
            }
            Biome biome = (Biome)level.m_204166_(pos).m_203334_();
            float humidityMultiplier = biome.getModifiedClimateSettings().f_47683_();
            double precipitationMultiplier = 1.0;
            if (biome.m_198904_(pos)) {
                precipitationMultiplier = 0.5;
            } else if (level.m_46758_(pos)) {
                precipitationMultiplier = 3.0;
            }
            double temperaturePenalty = 0.0;
            float temperature = biome.m_47505_(pos);
            if ((double)temperature > 1.0) {
                temperaturePenalty = (double)temperature - 1.0;
            }
            return new State(true, temperaturePenalty, humidityMultiplier, precipitationMultiplier);
        }
    }
}

