/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dotaboss.item;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Consumer;
import net.mcreator.dotaboss.item.renderer.MuxaItemRenderer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class MuxaItem
extends Item
implements IAnimatable {
    public AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public String animationprocedure = "empty";
    public static ItemTransforms.TransformType transformType;

    public MuxaItem() {
        super(new Item.Properties().m_41491_(null).m_41487_(64).m_41497_(Rarity.COMMON));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer = new MuxaItemRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public void getTransformType(ItemTransforms.TransformType type) {
        transformType = type;
    }

    protected void interpretFirstPersonInstructions(List<String> tokens, MuxaItemRenderer renderer) {
        String firstTok = tokens.get(0);
        if (tokens.size() < 2) {
            return;
        }
        String boneName = tokens.get(1);
        if (firstTok.equals("set_hidden")) {
            boolean hidden = Boolean.valueOf(tokens.get(2));
            renderer.hideBone(boneName, hidden);
        } else if (firstTok.equals("move")) {
            float x = Float.valueOf(tokens.get(2)).floatValue();
            float y = Float.valueOf(tokens.get(3)).floatValue();
            float z = Float.valueOf(tokens.get(4)).floatValue();
            renderer.setBonePosition(boneName, x, y, z);
        } else if (firstTok.equals("rotate")) {
            float x = Float.valueOf(tokens.get(2)).floatValue();
            float y = Float.valueOf(tokens.get(3)).floatValue();
            float z = Float.valueOf(tokens.get(4)).floatValue();
            renderer.setBoneRotation(boneName, x, y, z);
        } else if (firstTok.equals("suppress_mod")) {
            renderer.suppressModification(boneName);
        } else if (firstTok.equals("allow_mod")) {
            renderer.allowModification(boneName);
        }
    }

    private <P extends Item> PlayState idlePredicate(AnimationEvent<P> event) {
        if (transformType != null && this.animationprocedure.equals("empty")) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("NO", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <P extends Item> PlayState procedurePredicate(AnimationEvent<P> event) {
        if (transformType != null && !this.animationprocedure.equals("empty") && event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(this.animationprocedure, (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
                this.animationprocedure = "empty";
                event.getController().markNeedsReload();
            }
        }
        return PlayState.CONTINUE;
    }

    public void setupAnimationState(MuxaItemRenderer renderer, ItemStack stack, PoseStack matrixStack, float aimProgress) {
    }

    public void registerControllers(AnimationData data) {
        AnimationController procedureController = new AnimationController((IAnimatable)this, "procedureController", 0.0f, this::procedurePredicate);
        data.addAnimationController(procedureController);
        AnimationController idleController = new AnimationController((IAnimatable)this, "idleController", 0.0f, this::idlePredicate);
        data.addAnimationController(idleController);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

