/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dotaboss.network;

import java.util.function.Supplier;
import net.mcreator.dotaboss.DotabossMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DotabossModVariables {
    public static boolean netlenzombispawn = false;
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        DotabossMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        DotabossMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        public int type;
        public SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            SavedData savedData = this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
            if (savedData instanceof MapVariables) {
                MapVariables _mapvars = (MapVariables)savedData;
                _mapvars.read(buffer.m_130260_());
            } else {
                savedData = this.data;
                if (savedData instanceof WorldVariables) {
                    WorldVariables _worldvars = (WorldVariables)savedData;
                    _worldvars.read(buffer.m_130260_());
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        public PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.AdventureUnding = message.data.AdventureUnding;
                    variables.ManaBarPlayer = message.data.ManaBarPlayer;
                    variables.ProthentManaBarPlayer = message.data.ProthentManaBarPlayer;
                    variables.PromiezhutochnyiProtsientMany = message.data.PromiezhutochnyiProtsientMany;
                    variables.MaxManaBarPlayer = message.data.MaxManaBarPlayer;
                    variables.ManaProverka = message.data.ManaProverka;
                    variables.Sila = message.data.Sila;
                    variables.lovkost = message.data.lovkost;
                    variables.Intelekt = message.data.Intelekt;
                    variables.ManaBarPlayerIstina = message.data.ManaBarPlayerIstina;
                    variables.SilaPokazatel = message.data.SilaPokazatel;
                    variables.SilaProverkf = message.data.SilaProverkf;
                    variables.LovkostPokazatel = message.data.LovkostPokazatel;
                    variables.LovkostProverka = message.data.LovkostProverka;
                    variables.IntelektPokazatel = message.data.IntelektPokazatel;
                    variables.IntelektProverka = message.data.IntelektProverka;
                    variables.ManaRegen = message.data.ManaRegen;
                    variables.ManaRegen1 = message.data.ManaRegen1;
                    variables.ManaRegenPokazatel = message.data.ManaRegenPokazatel;
                    variables.LVL = message.data.LVL;
                    variables.DublLVL = message.data.DublLVL;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean AdventureUnding = false;
        public double ManaBarPlayer = 200.0;
        public double ProthentManaBarPlayer = 0.0;
        public double PromiezhutochnyiProtsientMany = 0.0;
        public double MaxManaBarPlayer = 200.0;
        public boolean ManaProverka = false;
        public double Sila = 0.0;
        public double lovkost = 0.0;
        public double Intelekt = 0.0;
        public double ManaBarPlayerIstina = 200.0;
        public double SilaPokazatel = 0.0;
        public boolean SilaProverkf = false;
        public double LovkostPokazatel = 0.0;
        public boolean LovkostProverka = false;
        public double IntelektPokazatel = 0.0;
        public boolean IntelektProverka = false;
        public boolean ManaRegen = false;
        public double ManaRegen1 = 0.5;
        public double ManaRegenPokazatel = 0.0;
        public double LVL = 0.0;
        public double DublLVL = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                DotabossMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("AdventureUnding", this.AdventureUnding);
            nbt.m_128347_("ManaBarPlayer", this.ManaBarPlayer);
            nbt.m_128347_("ProthentManaBarPlayer", this.ProthentManaBarPlayer);
            nbt.m_128347_("PromiezhutochnyiProtsientMany", this.PromiezhutochnyiProtsientMany);
            nbt.m_128347_("MaxManaBarPlayer", this.MaxManaBarPlayer);
            nbt.m_128379_("ManaProverka", this.ManaProverka);
            nbt.m_128347_("Sila", this.Sila);
            nbt.m_128347_("lovkost", this.lovkost);
            nbt.m_128347_("Intelekt", this.Intelekt);
            nbt.m_128347_("ManaBarPlayerIstina", this.ManaBarPlayerIstina);
            nbt.m_128347_("SilaPokazatel", this.SilaPokazatel);
            nbt.m_128379_("SilaProverkf", this.SilaProverkf);
            nbt.m_128347_("LovkostPokazatel", this.LovkostPokazatel);
            nbt.m_128379_("LovkostProverka", this.LovkostProverka);
            nbt.m_128347_("IntelektPokazatel", this.IntelektPokazatel);
            nbt.m_128379_("IntelektProverka", this.IntelektProverka);
            nbt.m_128379_("ManaRegen", this.ManaRegen);
            nbt.m_128347_("ManaRegen1", this.ManaRegen1);
            nbt.m_128347_("ManaRegenPokazatel", this.ManaRegenPokazatel);
            nbt.m_128347_("LVL", this.LVL);
            nbt.m_128347_("DublLVL", this.DublLVL);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.AdventureUnding = nbt.m_128471_("AdventureUnding");
            this.ManaBarPlayer = nbt.m_128459_("ManaBarPlayer");
            this.ProthentManaBarPlayer = nbt.m_128459_("ProthentManaBarPlayer");
            this.PromiezhutochnyiProtsientMany = nbt.m_128459_("PromiezhutochnyiProtsientMany");
            this.MaxManaBarPlayer = nbt.m_128459_("MaxManaBarPlayer");
            this.ManaProverka = nbt.m_128471_("ManaProverka");
            this.Sila = nbt.m_128459_("Sila");
            this.lovkost = nbt.m_128459_("lovkost");
            this.Intelekt = nbt.m_128459_("Intelekt");
            this.ManaBarPlayerIstina = nbt.m_128459_("ManaBarPlayerIstina");
            this.SilaPokazatel = nbt.m_128459_("SilaPokazatel");
            this.SilaProverkf = nbt.m_128471_("SilaProverkf");
            this.LovkostPokazatel = nbt.m_128459_("LovkostPokazatel");
            this.LovkostProverka = nbt.m_128471_("LovkostProverka");
            this.IntelektPokazatel = nbt.m_128459_("IntelektPokazatel");
            this.IntelektProverka = nbt.m_128471_("IntelektProverka");
            this.ManaRegen = nbt.m_128471_("ManaRegen");
            this.ManaRegen1 = nbt.m_128459_("ManaRegen1");
            this.ManaRegenPokazatel = nbt.m_128459_("ManaRegenPokazatel");
            this.LVL = nbt.m_128459_("LVL");
            this.DublLVL = nbt.m_128459_("DublLVL");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("dotaboss", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "dotaboss_mapvars";
        public double OzvuthcaUndying = 0.0;
        public boolean tresposobundying2 = false;
        public boolean TresskillUndyiungAnim = false;
        public double skilloneundying = 0.0;
        public boolean ULTUndying = false;
        public boolean Proverkaspawna = false;
        public boolean blokskillultaUndying = false;
        public boolean BlocULTAUndyiung = false;
        public double TimeOzvuthcka = 0.0;
        public boolean UndyingSpawn = false;
        public boolean PromiezhutochnyiSpavnAndaingh = false;
        public boolean batlMusik = false;
        public boolean StopBatlMusikUndying = false;
        public boolean Poyassila = false;
        public double vostanovlieniieandaingh = 0.0;
        public boolean Antivostanovlieniiekhp = false;
        public boolean WritheKingSpawn = false;
        public boolean writhekingbatlmusic = false;
        public boolean SkillOneWritheKing = false;
        public boolean StopBatlMusik2Undying = false;
        public boolean BatlMusikWK = false;
        public boolean wkskeltonspawn = false;
        public boolean stopskillWK = false;
        public boolean WkOneSkill = false;
        public boolean WkTreSkill = false;
        public boolean WKspawn = false;
        public double wksong = 0.0;
        public boolean LVLPOKAZATEL = false;
        public double x = 0.0;
        public double y = 0.0;
        public double z = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.OzvuthcaUndying = nbt.m_128459_("OzvuthcaUndying");
            this.tresposobundying2 = nbt.m_128471_("tresposobundying2");
            this.TresskillUndyiungAnim = nbt.m_128471_("TresskillUndyiungAnim");
            this.skilloneundying = nbt.m_128459_("skilloneundying");
            this.ULTUndying = nbt.m_128471_("ULTUndying");
            this.Proverkaspawna = nbt.m_128471_("Proverkaspawna");
            this.blokskillultaUndying = nbt.m_128471_("blokskillultaUndying");
            this.BlocULTAUndyiung = nbt.m_128471_("BlocULTAUndyiung");
            this.TimeOzvuthcka = nbt.m_128459_("TimeOzvuthcka");
            this.UndyingSpawn = nbt.m_128471_("UndyingSpawn");
            this.PromiezhutochnyiSpavnAndaingh = nbt.m_128471_("PromiezhutochnyiSpavnAndaingh");
            this.batlMusik = nbt.m_128471_("batlMusik");
            this.StopBatlMusikUndying = nbt.m_128471_("StopBatlMusikUndying");
            this.Poyassila = nbt.m_128471_("Poyassila");
            this.vostanovlieniieandaingh = nbt.m_128459_("vostanovlieniieandaingh");
            this.Antivostanovlieniiekhp = nbt.m_128471_("Antivostanovlieniiekhp");
            this.WritheKingSpawn = nbt.m_128471_("WritheKingSpawn");
            this.writhekingbatlmusic = nbt.m_128471_("writhekingbatlmusic");
            this.SkillOneWritheKing = nbt.m_128471_("SkillOneWritheKing");
            this.StopBatlMusik2Undying = nbt.m_128471_("StopBatlMusik2Undying");
            this.BatlMusikWK = nbt.m_128471_("BatlMusikWK");
            this.wkskeltonspawn = nbt.m_128471_("wkskeltonspawn");
            this.stopskillWK = nbt.m_128471_("stopskillWK");
            this.WkOneSkill = nbt.m_128471_("WkOneSkill");
            this.WkTreSkill = nbt.m_128471_("WkTreSkill");
            this.WKspawn = nbt.m_128471_("WKspawn");
            this.wksong = nbt.m_128459_("wksong");
            this.LVLPOKAZATEL = nbt.m_128471_("LVLPOKAZATEL");
            this.x = nbt.m_128459_("x");
            this.y = nbt.m_128459_("y");
            this.z = nbt.m_128459_("z");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("OzvuthcaUndying", this.OzvuthcaUndying);
            nbt.m_128379_("tresposobundying2", this.tresposobundying2);
            nbt.m_128379_("TresskillUndyiungAnim", this.TresskillUndyiungAnim);
            nbt.m_128347_("skilloneundying", this.skilloneundying);
            nbt.m_128379_("ULTUndying", this.ULTUndying);
            nbt.m_128379_("Proverkaspawna", this.Proverkaspawna);
            nbt.m_128379_("blokskillultaUndying", this.blokskillultaUndying);
            nbt.m_128379_("BlocULTAUndyiung", this.BlocULTAUndyiung);
            nbt.m_128347_("TimeOzvuthcka", this.TimeOzvuthcka);
            nbt.m_128379_("UndyingSpawn", this.UndyingSpawn);
            nbt.m_128379_("PromiezhutochnyiSpavnAndaingh", this.PromiezhutochnyiSpavnAndaingh);
            nbt.m_128379_("batlMusik", this.batlMusik);
            nbt.m_128379_("StopBatlMusikUndying", this.StopBatlMusikUndying);
            nbt.m_128379_("Poyassila", this.Poyassila);
            nbt.m_128347_("vostanovlieniieandaingh", this.vostanovlieniieandaingh);
            nbt.m_128379_("Antivostanovlieniiekhp", this.Antivostanovlieniiekhp);
            nbt.m_128379_("WritheKingSpawn", this.WritheKingSpawn);
            nbt.m_128379_("writhekingbatlmusic", this.writhekingbatlmusic);
            nbt.m_128379_("SkillOneWritheKing", this.SkillOneWritheKing);
            nbt.m_128379_("StopBatlMusik2Undying", this.StopBatlMusik2Undying);
            nbt.m_128379_("BatlMusikWK", this.BatlMusikWK);
            nbt.m_128379_("wkskeltonspawn", this.wkskeltonspawn);
            nbt.m_128379_("stopskillWK", this.stopskillWK);
            nbt.m_128379_("WkOneSkill", this.WkOneSkill);
            nbt.m_128379_("WkTreSkill", this.WkTreSkill);
            nbt.m_128379_("WKspawn", this.WKspawn);
            nbt.m_128347_("wksong", this.wksong);
            nbt.m_128379_("LVLPOKAZATEL", this.LVLPOKAZATEL);
            nbt.m_128347_("x", this.x);
            nbt.m_128347_("y", this.y);
            nbt.m_128347_("z", this.z);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                DotabossMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "dotaboss_worldvars";
        public double TOMBASPAWN = 0.0;
        public boolean Stan = false;
        public double Basher = 0.0;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.TOMBASPAWN = nbt.m_128459_("TOMBASPAWN");
            this.Stan = nbt.m_128471_("Stan");
            this.Basher = nbt.m_128459_("Basher");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("TOMBASPAWN", this.TOMBASPAWN);
            nbt.m_128379_("Stan", this.Stan);
            nbt.m_128347_("Basher", this.Basher);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                DotabossMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.ManaBarPlayer = original.ManaBarPlayer;
            clone.ProthentManaBarPlayer = original.ProthentManaBarPlayer;
            clone.PromiezhutochnyiProtsientMany = original.PromiezhutochnyiProtsientMany;
            clone.MaxManaBarPlayer = original.MaxManaBarPlayer;
            clone.Sila = original.Sila;
            clone.lovkost = original.lovkost;
            clone.Intelekt = original.Intelekt;
            clone.ManaBarPlayerIstina = original.ManaBarPlayerIstina;
            clone.SilaPokazatel = original.SilaPokazatel;
            clone.SilaProverkf = original.SilaProverkf;
            clone.LovkostPokazatel = original.LovkostPokazatel;
            clone.LovkostProverka = original.LovkostProverka;
            clone.IntelektPokazatel = original.IntelektPokazatel;
            clone.IntelektProverka = original.IntelektProverka;
            clone.ManaRegen = original.ManaRegen;
            clone.ManaRegen1 = original.ManaRegen1;
            clone.ManaRegenPokazatel = original.ManaRegenPokazatel;
            clone.LVL = original.LVL;
            clone.DublLVL = original.DublLVL;
            if (!event.isWasDeath()) {
                clone.AdventureUnding = original.AdventureUnding;
                clone.ManaProverka = original.ManaProverka;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().f_19853_);
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_);
                if (mapdata != null) {
                    DotabossMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    DotabossMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().f_19853_.m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_)) != null) {
                DotabossMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

