/*
 * Decompiled with CFR 0.152.
 */
package net.echo.little_johns.block.custom;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2429;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public abstract class MultifaceBlock
extends class_2248 {
    private static final class_265 UP_SHAPE = class_2248.method_9541((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 DOWN_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final class_265 EAST_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    private static final class_265 WEST_SHAPE = class_2248.method_9541((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 SOUTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    private static final class_265 NORTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<class_2350, class_2746> FACING_PROPERTIES = class_2429.field_11329;
    private static final Map<class_2350, class_265> SHAPES_FOR_DIRECTIONS = (Map)class_156.method_654((Object)Maps.newEnumMap(class_2350.class), shapes -> {
        shapes.put(class_2350.field_11043, SOUTH_SHAPE);
        shapes.put(class_2350.field_11034, WEST_SHAPE);
        shapes.put(class_2350.field_11035, NORTH_SHAPE);
        shapes.put(class_2350.field_11039, EAST_SHAPE);
        shapes.put(class_2350.field_11036, UP_SHAPE);
        shapes.put(class_2350.field_11033, DOWN_SHAPE);
    });
    protected static final class_2350[] DIRECTIONS = class_2350.values();
    private final ImmutableMap<class_2680, class_265> SHAPES;
    private final boolean hasAllHorizontalDirections;
    private final boolean canMirrorX;
    private final boolean canMirrorZ;

    public MultifaceBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590(MultifaceBlock.withAllDirections((class_2689<class_2248, class_2680>)this.field_10647));
        this.SHAPES = this.method_33615(MultifaceBlock::getShapeForState);
        this.hasAllHorizontalDirections = class_2350.class_2353.field_11062.method_29716().allMatch(this::canHaveDirection);
        this.canMirrorX = class_2350.class_2353.field_11062.method_29716().filter(class_2350.class_2351.field_11048).filter(this::canHaveDirection).count() % 2L == 0L;
        this.canMirrorZ = class_2350.class_2353.field_11062.method_29716().filter(class_2350.class_2351.field_11051).filter(this::canHaveDirection).count() % 2L == 0L;
    }

    protected abstract MapCodec<? extends MultifaceBlock> method_53969();

    public static Set<class_2350> collectDirections(class_2680 state) {
        if (!(state.method_26204() instanceof MultifaceBlock)) {
            return Set.of();
        }
        EnumSet<class_2350> set = EnumSet.noneOf(class_2350.class);
        for (class_2350 direction : class_2350.values()) {
            if (!MultifaceBlock.hasDirection(state, direction)) continue;
            set.add(direction);
        }
        return set;
    }

    public static Set<class_2350> flagToDirections(byte flag) {
        EnumSet<class_2350> set = EnumSet.noneOf(class_2350.class);
        for (class_2350 direction : class_2350.values()) {
            if ((flag & (byte)(1 << direction.ordinal())) <= 0) continue;
            set.add(direction);
        }
        return set;
    }

    public static byte directionsToFlag(Collection<class_2350> directions) {
        byte b = 0;
        for (class_2350 direction : directions) {
            b = (byte)(b | 1 << direction.ordinal());
        }
        return b;
    }

    protected boolean canHaveDirection(class_2350 direction) {
        return true;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        for (class_2350 direction : DIRECTIONS) {
            if (!this.canHaveDirection(direction)) continue;
            builder.method_11667(new class_2769[]{MultifaceBlock.getProperty(direction)});
        }
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return (class_265)this.SHAPES.get((Object)state);
    }

    protected boolean method_9616(class_2680 state, class_1750 context) {
        return MultifaceBlock.isNotFullBlock(state);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_1937 world = ctx.method_8045();
        class_2338 blockPos = ctx.method_8037();
        class_2680 blockState = world.method_8320(blockPos);
        return Arrays.stream(ctx.method_7718()).map(direction -> this.withDirection(blockState, (class_1922)world, blockPos, (class_2350)direction)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Nullable
    public class_2680 withDirection(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        class_2680 blockState = state.method_27852((class_2248)this) ? state : (this.isWaterlogged() && state.method_26227().method_33659((class_3611)class_3612.field_15910) ? (class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)) : this.method_9564());
        return (class_2680)blockState.method_11657((class_2769)MultifaceBlock.getProperty(direction), (Comparable)Boolean.valueOf(true));
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        if (!this.hasAllHorizontalDirections) {
            return state;
        }
        return this.mirror(state, arg_0 -> ((class_2470)rotation).method_10503(arg_0));
    }

    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        if (mirror == class_2415.field_11301 && !this.canMirrorX) {
            return state;
        }
        if (mirror == class_2415.field_11300 && !this.canMirrorZ) {
            return state;
        }
        return this.mirror(state, arg_0 -> ((class_2415)mirror).method_10343(arg_0));
    }

    private class_2680 mirror(class_2680 state, Function<class_2350, class_2350> mirror) {
        class_2680 blockState = state;
        for (class_2350 direction : DIRECTIONS) {
            if (!this.canHaveDirection(direction)) continue;
            blockState = (class_2680)blockState.method_11657((class_2769)MultifaceBlock.getProperty(mirror.apply(direction)), (Comparable)((Boolean)state.method_11654((class_2769)MultifaceBlock.getProperty(direction))));
        }
        return blockState;
    }

    public static boolean hasDirection(class_2680 state, class_2350 direction) {
        class_2746 booleanProperty = MultifaceBlock.getProperty(direction);
        return state.method_28498((class_2769)booleanProperty) && (Boolean)state.method_11654((class_2769)booleanProperty) != false;
    }

    private boolean isWaterlogged() {
        return this.field_10647.method_11659().contains(class_2741.field_12508);
    }

    private static class_2680 disableDirection(class_2680 state, class_2746 direction) {
        class_2680 blockState = (class_2680)state.method_11657((class_2769)direction, (Comparable)Boolean.valueOf(false));
        if (MultifaceBlock.hasAnyDirection(blockState)) {
            return blockState;
        }
        return class_2246.field_10124.method_9564();
    }

    public static class_2746 getProperty(class_2350 direction) {
        return FACING_PROPERTIES.get(direction);
    }

    private static class_2680 withAllDirections(class_2689<class_2248, class_2680> stateManager) {
        class_2680 blockState = (class_2680)stateManager.method_11664();
        for (class_2746 booleanProperty : FACING_PROPERTIES.values()) {
            if (!blockState.method_28498((class_2769)booleanProperty)) continue;
            blockState = (class_2680)blockState.method_11657((class_2769)booleanProperty, (Comparable)Boolean.valueOf(false));
        }
        return blockState;
    }

    private static class_265 getShapeForState(class_2680 state) {
        class_265 voxelShape = class_259.method_1073();
        for (class_2350 direction : DIRECTIONS) {
            if (!MultifaceBlock.hasDirection(state, direction)) continue;
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)SHAPES_FOR_DIRECTIONS.get(direction));
        }
        return voxelShape.method_1110() ? class_259.method_1077() : voxelShape;
    }

    protected static boolean hasAnyDirection(class_2680 state) {
        return Arrays.stream(DIRECTIONS).anyMatch(direction -> MultifaceBlock.hasDirection(state, direction));
    }

    private static boolean isNotFullBlock(class_2680 state) {
        return Arrays.stream(DIRECTIONS).anyMatch(direction -> !MultifaceBlock.hasDirection(state, direction));
    }
}

