/*
 * Decompiled with CFR 0.152.
 */
package xyz.kaleidiodev.kaleidiosguns.entity;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.GlassBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.StainedGlassBlock;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractFireballEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.util.FakePlayer;
import xyz.kaleidiodev.kaleidiosguns.config.KGConfig;
import xyz.kaleidiodev.kaleidiosguns.item.GunItem;
import xyz.kaleidiodev.kaleidiosguns.item.IBullet;
import xyz.kaleidiodev.kaleidiosguns.network.NetworkUtils;
import xyz.kaleidiodev.kaleidiosguns.registry.ModEntities;
import xyz.kaleidiodev.kaleidiosguns.registry.ModItems;
import xyz.kaleidiodev.kaleidiosguns.registry.ModSounds;

public class BulletEntity
extends AbstractFireballEntity {
    protected double damage = 1.0;
    protected double inaccuracy = 0.0;
    protected boolean ignoreInvulnerability = false;
    protected double knockbackStrength = 0.0;
    public long ticksOnFire;
    protected double healthRewardChance = 0.0;
    protected float healthOfVictim;
    protected boolean shouldBreakBlock;
    protected boolean shouldCollateral;
    protected double bulletSpeed;
    public boolean isTorpedo;
    protected boolean shouldGlow;
    protected GunItem shootingGun;
    protected Vector3d origin;
    public boolean isExplosive;
    public boolean isPlasma;
    public boolean isWither;
    public boolean wasRevenge;
    public boolean wasDark;
    public boolean shootsLights;
    public boolean isClean;
    public boolean isCorrupted;
    public boolean shouldBreakDoors;
    public boolean shouldFlinch;
    public boolean armorBonus;
    public boolean healsFriendlies;
    public boolean juggle;
    public byte lavaMode;
    public boolean isMeleeBonus;
    public boolean interactsWithBlocks;
    public int redstoneLevel;
    public double mineChance;
    public boolean clip;
    public boolean hero;
    public long actualTick;
    public List<EffectInstance> potionInstance = new ArrayList<EffectInstance>();
    public PotionApplyMode applyMode;
    public int lingeringTime;
    public double heroStep;
    public Vector3d lastPos = new Vector3d(0.0, 0.0, 0.0);
    public boolean hitBlock;
    public boolean hitEntity;
    public Set<Entity> entitiesThisTick = new HashSet<Entity>();
    public boolean pollRemove;
    public boolean didNoDamage;
    public boolean silenced;
    public boolean shouldSlow;
    protected Set<Entity> entityHitHistory = new HashSet<Entity>();
    public Set<Entity> headshotHistory = new HashSet<Entity>();

    public BulletEntity(EntityType<? extends BulletEntity> entityType, World worldIn) {
        super(entityType, worldIn);
    }

    public BulletEntity(World worldIn, LivingEntity shooter) {
        this(worldIn, shooter, 0.0, 0.0, 0.0);
        this.ticksOnFire = this.field_70170_p.func_82737_E();
        this.func_70107_b(shooter.func_226277_ct_(), shooter.func_226280_cw_() - 0.1, shooter.func_226281_cx_());
    }

    public BulletEntity(World worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super(ModEntities.BULLET, shooter, accelX, accelY, accelZ, worldIn);
    }

    protected IParticleData func_195057_f() {
        if (this.isExplosive) {
            return ParticleTypes.field_197598_I;
        }
        if (this.isPlasma) {
            return ParticleTypes.field_197590_A;
        }
        if (this.wasRevenge || this.isMeleeBonus || this.hero) {
            return ParticleTypes.field_197632_y;
        }
        if (this.wasDark) {
            return ParticleTypes.field_197601_L;
        }
        if ((this.lavaMode & 4) != 0 && this.lavaMode > 4) {
            return ParticleTypes.field_218424_l;
        }
        return ParticleTypes.field_197614_g;
    }

    public void func_70071_h_() {
        long passage;
        ++this.actualTick;
        if (!this.field_70170_p.field_72995_K && (passage = this.field_70170_p.func_82737_E() - this.ticksOnFire) != this.actualTick) {
            this.func_70106_y();
        }
        if (this.actualTick > 100L) {
            this.func_70106_y();
        }
        Entity entity = this.func_234616_v_();
        if (this.field_70128_L) {
            return;
        }
        if (entity != null && entity.field_70128_L) {
            this.func_70106_y();
            return;
        }
        if (this.pollRemove) {
            this.func_70106_y();
            return;
        }
        if (this.shouldGlow || this.clip) {
            this.func_184195_f(true);
        }
        this.func_70052_a(6, this.func_225510_bt_());
        this.func_70030_z();
        this.func_145775_I();
        ProjectileHelper.func_188803_a((Entity)this, (float)20.0f);
        Vector3d vector3d = this.func_213322_ci();
        if (this.func_70090_H() && !this.isTorpedo) {
            vector3d = vector3d.func_216372_d(0.5, 0.5, 0.5);
        }
        if (!this.func_189652_ae()) {
            vector3d = vector3d.func_178786_a(0.0, 0.05, 0.0);
        }
        this.func_213317_d(vector3d);
        Vector3d prevPos = this.func_213303_ch();
        this.func_70107_b(this.func_226277_ct_() + vector3d.field_72450_a, this.func_226278_cu_() + vector3d.field_72448_b, this.func_226281_cx_() + vector3d.field_72449_c);
        if (this.shouldCollateral) {
            if (!this.field_70170_p.field_72995_K) {
                for (Entity currentEntity : this.entitiesThisTick) {
                    this.entityHitProcess(currentEntity);
                    if (!this.didNoDamage) continue;
                    break;
                }
            }
        } else if (this.hitEntity) {
            if (!this.field_70170_p.field_72995_K) {
                Entity next = this.entityHitHistory.iterator().next();
                this.entityHitProcess(next);
            }
            this.func_70107_b(this.lastPos.field_72450_a, this.lastPos.field_72448_b, this.lastPos.field_72449_c);
            this.pollRemove = true;
        }
        if (this.hitBlock) {
            this.func_70107_b(this.lastPos.field_72450_a, this.lastPos.field_72448_b, this.lastPos.field_72449_c);
            if (this.field_70170_p.field_72995_K) {
                Vector3d motionDiv = this.func_213322_ci().func_72432_b().func_216369_h(new Vector3d(0.25, 0.25, 0.25)).func_216371_e();
                this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197598_I, true, this.lastPos.field_72450_a, this.lastPos.field_72448_b, this.lastPos.field_72449_c, motionDiv.field_72450_a, motionDiv.field_72448_b, motionDiv.field_72449_c);
            }
            this.pollRemove = true;
        }
        if (this.field_70170_p.field_72995_K && !this.silenced) {
            int divisor = (Integer)KGConfig.particlesPerTick.get();
            if (divisor == 0) {
                return;
            }
            Vector3d position = this.func_174813_aQ().func_189972_c().func_178788_d(this.func_213322_ci());
            Vector3d motionDiv = this.func_213322_ci().func_216369_h(new Vector3d(1.0 / (double)divisor, 1.0 / (double)divisor, 1.0 / (double)divisor));
            Vector3d motionDivHit = this.func_213303_ch().func_178788_d(prevPos).func_216369_h(new Vector3d(1.0 / (double)divisor, 1.0 / (double)divisor, 1.0 / (double)divisor));
            if (this.func_204231_K()) {
                if (this.actualTick > 1L) {
                    this.placeParticle((IParticleData)ParticleTypes.field_197612_e, position, motionDiv);
                }
                if (this.pollRemove) {
                    this.placeParticle((IParticleData)ParticleTypes.field_197612_e, this.func_174813_aQ().func_189972_c(), motionDivHit);
                }
            } else {
                if (this.actualTick > 1L) {
                    this.placeParticle(this.func_195057_f(), position, motionDiv);
                }
                if (this.pollRemove) {
                    this.placeParticle(this.func_195057_f(), this.func_174813_aQ().func_189972_c(), motionDivHit);
                }
            }
        }
        if (!this.pollRemove) {
            this.traceHits();
        }
    }

    private void placeParticle(IParticleData particle, Vector3d position, Vector3d motionDiv) {
        Vector3d prevPos = position;
        for (int i = 0; i < (Integer)KGConfig.particlesPerTick.get(); ++i) {
            Vector3d maths = position.func_178788_d(motionDiv.func_216372_d((double)i, (double)i, (double)i));
            if (!(maths.func_178788_d(prevPos).func_72433_c() > 0.5)) continue;
            prevPos = maths;
            if (this.origin.func_178788_d(maths).func_72433_c() < 5.0) continue;
            this.field_70170_p.func_195590_a(particle, true, maths.field_72450_a, maths.field_72448_b, maths.field_72449_c, 0.0, 0.0, 0.0);
        }
    }

    public void traceHits() {
        this.entitiesThisTick.clear();
        AxisAlignedBB bb = this.func_174813_aQ();
        double actualSpeed = Vector3d.field_186680_a.func_72438_d(this.func_213322_ci());
        Vector3d delta = this.func_213322_ci();
        Vector3d incPosition = new Vector3d(delta.field_72450_a / (actualSpeed * 8.0), delta.field_72448_b / (actualSpeed * 8.0), delta.field_72449_c / (actualSpeed * 8.0));
        int i = 0;
        while ((double)i < actualSpeed * 8.0) {
            bb = bb.func_191194_a(incPosition);
            HashSet<Entity> thisEntities = new HashSet<Entity>(this.field_70170_p.func_72839_b((Entity)this, bb));
            thisEntities.removeIf(entity -> this.checkIsSameTeam(this.func_234616_v_(), (Entity)entity) || entity == this.func_234616_v_() || !entity.func_70089_S() || !this.func_230298_a_((Entity)entity));
            thisEntities.removeAll(this.entityHitHistory);
            this.entitiesThisTick.addAll(thisEntities);
            this.entityHitHistory.addAll(this.entitiesThisTick);
            if (thisEntities.size() > 0) {
                if (this.isExplosive) {
                    this.explode(bb.func_189972_c());
                }
                double bulletBBFloor = bb.func_189972_c().field_72448_b - bb.func_216360_c() / 2.0;
                for (Entity victim : thisEntities) {
                    AxisAlignedBB tempBB = victim.func_174813_aQ();
                    double enemyBoxHeight = tempBB.func_216360_c() / 2.0;
                    double enemyTop = tempBB.func_189972_c().field_72448_b + enemyBoxHeight;
                    double enemyChin = enemyTop - enemyBoxHeight * 2.0 / 4.0;
                    if (!(bulletBBFloor > enemyChin) || !(bulletBBFloor < enemyTop) || this.isExplosive || this.isPlasma || this.shouldBreakBlock) continue;
                    if (this.func_234616_v_() != null && !this.field_70170_p.func_201670_d() && !(victim instanceof EndermanEntity)) {
                        this.func_234616_v_().field_70170_p.func_184148_a(null, bb.func_189972_c().field_72450_a, bb.func_189972_c().field_72448_b, bb.func_189972_c().field_72449_c, SoundEvents.field_187718_dS, SoundCategory.VOICE, 5.0f, 1.0f);
                    }
                    this.headshotHistory.add(victim);
                }
                if (!this.shouldCollateral) {
                    this.lastPos = bb.func_189972_c();
                    this.hitEntity = true;
                    break;
                }
            }
            if (!this.clip) {
                Block blockToChange;
                BlockPos someBlockPos = new BlockPos(bb.func_189972_c());
                BlockState someBlockState = this.field_70170_p.func_180495_p(someBlockPos);
                BlockState targetBlock = this.field_70170_p.func_180495_p(someBlockPos);
                targetBlock.func_215690_a(this.field_70170_p, targetBlock, new BlockRayTraceResult(bb.func_189972_c(), Direction.func_210769_a((double)bb.func_189972_c().field_72450_a, (double)bb.func_189972_c().field_72448_b, (double)bb.func_189972_c().field_72449_c), someBlockPos, false), (ProjectileEntity)this);
                if ((this.lavaMode & 4) != 0 && this.shootingGun != null) {
                    if (someBlockState.func_177230_c() == Blocks.field_150353_l) {
                        this.shootingGun.hadLava = (Integer)KGConfig.lavaSmgLavaBonusCount.get();
                        this.field_70170_p.func_180501_a(someBlockPos, Blocks.field_150350_a.func_176223_P(), 2);
                        this.hitBlock = true;
                    }
                    if (someBlockState.func_177230_c() == Blocks.field_150355_j && this.lavaMode > 4) {
                        this.field_70170_p.func_180501_a(someBlockPos, Blocks.field_150348_b.func_176223_P(), 2);
                        this.hitBlock = true;
                    }
                }
                if (this.shootsLights && (blockToChange = someBlockState.func_177230_c()).getLightValue(someBlockState, (IBlockReader)this.field_70170_p, someBlockPos) > 0) {
                    this.field_70170_p.func_175655_b(someBlockPos, false);
                    this.hitBlock = true;
                }
                if (this.interactsWithBlocks && this.field_70170_p.func_226666_b_((Entity)this, bb).findAny().isPresent()) {
                    FakePlayer fakePlayer = new FakePlayer((ServerWorld)this.field_70170_p, new GameProfile(null, "[KaleidiosGunsFakePlayer]"));
                    someBlockState.func_227031_a_(this.field_70170_p, (PlayerEntity)fakePlayer, Hand.MAIN_HAND, new BlockRayTraceResult(bb.func_189972_c(), Direction.func_210769_a((double)bb.func_189972_c().field_72450_a, (double)bb.func_189972_c().field_72448_b, (double)bb.func_189972_c().field_72449_c), someBlockPos, true));
                    this.hitBlock = true;
                }
                if (someBlockState.func_185904_a().func_76230_c() && this.field_70170_p.func_226666_b_((Entity)this, bb).findAny().isPresent()) {
                    if (this.isExplosive) {
                        this.explode(bb.func_189972_c().func_178788_d(incPosition));
                    } else {
                        this.onHitBlock(bb.func_189972_c());
                    }
                    this.hitBlock = true;
                }
                if (this.hitBlock) {
                    this.lastPos = bb.func_189972_c();
                    break;
                }
            }
            ++i;
        }
    }

    protected void onHitBlock(Vector3d pos) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_184148_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, ModSounds.impact, SoundCategory.VOICE, 0.25f, this.field_70146_Z.nextFloat() * 0.5f + 0.75f);
        }
        BlockPos blockPositionToMine = new BlockPos(pos);
        if (((Boolean)KGConfig.griefEnabled.get()).booleanValue() && !this.field_70170_p.field_72995_K) {
            if (this.shouldBreakBlock) {
                ItemStack newTool;
                if (this.getDamage() >= (Double)KGConfig.mineGunFifthLevel.get()) {
                    newTool = new ItemStack((IItemProvider)Items.field_151046_w);
                    this.tryBreakBlock(blockPositionToMine, newTool);
                    newTool = new ItemStack((IItemProvider)Items.field_151056_x);
                    this.tryBreakBlock(blockPositionToMine, newTool);
                    newTool = new ItemStack((IItemProvider)Items.field_151047_v);
                    this.tryBreakBlock(blockPositionToMine, newTool);
                    newTool = new ItemStack((IItemProvider)Items.field_151097_aZ);
                    this.tryBreakBlock(blockPositionToMine, newTool);
                    this.breakWeakBlocks(blockPositionToMine);
                } else if (this.getDamage() >= (Double)KGConfig.mineGunFourthLevel.get()) {
                    newTool = new ItemStack((IItemProvider)Items.field_151035_b);
                    this.tryBreakBlock(blockPositionToMine, newTool);
                    newTool = new ItemStack((IItemProvider)Items.field_151036_c);
                    this.tryBreakBlock(blockPositionToMine, newTool);
                    newTool = new ItemStack((IItemProvider)Items.field_151037_a);
                    this.tryBreakBlock(blockPositionToMine, newTool);
                    newTool = new ItemStack((IItemProvider)Items.field_151097_aZ);
                    this.tryBreakBlock(blockPositionToMine, newTool);
                    this.breakWeakBlocks(blockPositionToMine);
                } else if (this.getDamage() >= (Double)KGConfig.mineGunThirdLevel.get()) {
                    newTool = new ItemStack((IItemProvider)Items.field_151050_s);
                    this.tryBreakBlock(blockPositionToMine, newTool);
                    newTool = new ItemStack((IItemProvider)Items.field_151049_t);
                    this.tryBreakBlock(blockPositionToMine, newTool);
                    newTool = new ItemStack((IItemProvider)Items.field_151051_r);
                    this.tryBreakBlock(blockPositionToMine, newTool);
                    this.breakWeakBlocks(blockPositionToMine);
                } else if (this.getDamage() >= (Double)KGConfig.mineGunSecondLevel.get()) {
                    newTool = new ItemStack((IItemProvider)Items.field_151039_o);
                    this.tryBreakBlock(blockPositionToMine, newTool);
                    newTool = new ItemStack((IItemProvider)Items.field_151053_p);
                    this.tryBreakBlock(blockPositionToMine, newTool);
                    newTool = new ItemStack((IItemProvider)Items.field_151038_n);
                    this.tryBreakBlock(blockPositionToMine, newTool);
                    this.breakWeakBlocks(blockPositionToMine);
                } else {
                    this.breakWeakBlocks(blockPositionToMine);
                }
                if (this.isCorrupted && this.field_70170_p.func_180495_p(blockPositionToMine).func_177230_c() == Blocks.field_150350_a && ((Boolean)KGConfig.netheriteMinegunCorruptBlock.get()).booleanValue()) {
                    this.field_70170_p.func_180501_a(blockPositionToMine, Blocks.field_150424_aL.func_176223_P(), 1);
                    if (this.func_70027_ad() && this.field_70146_Z.nextDouble() < (Double)KGConfig.netheriteMinegunIgnitionChance.get() && this.field_70170_p.func_180495_p(blockPositionToMine.func_177981_b(1)).func_177230_c() == Blocks.field_150350_a) {
                        this.field_70170_p.func_180501_a(blockPositionToMine.func_177981_b(1), Blocks.field_150480_ab.func_176223_P(), 3);
                    }
                }
            }
            if (this.shouldBreakDoors && this.actualTick <= 2L) {
                Block blockToChange = this.field_70170_p.func_180495_p(blockPositionToMine).func_177230_c();
                if (BlockTags.field_200152_g.func_230236_b_().contains(blockToChange) || BlockTags.field_212186_k.func_230236_b_().contains(blockToChange) || BlockTags.field_232868_aA_.func_230236_b_().contains(blockToChange) || BlockTags.field_219748_G.func_230236_b_().contains(blockToChange) || BlockTags.field_205213_E.func_230236_b_().contains(blockToChange) || blockToChange instanceof GlassBlock || blockToChange instanceof StainedGlassBlock || blockToChange instanceof PaneBlock || blockToChange == Blocks.field_150454_av || blockToChange == Blocks.field_180400_cw || blockToChange == Blocks.field_150407_cf || blockToChange == Blocks.field_226907_mc_ || blockToChange == Blocks.field_180399_cE) {
                    this.field_70170_p.func_175655_b(blockPositionToMine, false);
                }
            }
        }
    }

    protected void breakWeakBlocks(BlockPos blockPosToTest) {
        if (!this.field_70170_p.func_180495_p(blockPosToTest).func_235783_q_()) {
            this.breakBlock(blockPosToTest);
        }
    }

    protected void entityHitProcess(Entity entity) {
        Entity shooter = this.func_234616_v_();
        IBullet bullet = (IBullet)this.func_213896_l().func_77973_b();
        if (entity instanceof LivingEntity) {
            LivingEntity victim = (LivingEntity)entity;
            this.healthOfVictim = victim.func_110143_aJ();
            if (this.shouldGlow) {
                victim.func_195064_c(new EffectInstance(Effects.field_188423_x, ((Integer)KGConfig.enemyGlowTicks.get()).intValue(), 0));
            }
        } else {
            this.healthOfVictim = 0.0f;
        }
        if (shooter != null) {
            if (this.healsFriendlies && entity instanceof LivingEntity) {
                if (entity.getClassification(true) == EntityClassification.CREATURE || entity.getClassification(true) == EntityClassification.WATER_CREATURE || entity.func_96124_cp() == shooter.func_96124_cp() && shooter.func_96124_cp() != null) {
                    LivingEntity target = (LivingEntity)entity;
                    if (Math.random() - (Double)KGConfig.lmgDefenderHealChance.get() >= 0.0) {
                        target.func_195064_c(new EffectInstance(Effects.field_76432_h, 10, 0));
                    }
                } else {
                    this.giveDamage(shooter, entity, bullet);
                }
            } else if (!this.checkIsSameTeam(shooter, entity)) {
                this.giveDamage(shooter, entity, bullet);
            }
        } else {
            this.giveDamage(null, entity, bullet);
        }
    }

    protected void giveDamage(Entity shooter, Entity victim, IBullet bullet) {
        if (victim.func_70027_ad()) {
            this.lavaMode = (byte)(this.lavaMode + 2);
        }
        if (this.func_70027_ad()) {
            victim.func_70015_d(5);
        }
        int lastHurtResistant = victim.field_70172_ad;
        if (this.ignoreInvulnerability) {
            victim.field_70172_ad = 0;
        }
        Vector3d previousDelta = victim.func_213322_ci();
        if (victim instanceof LivingEntity) {
            this.healthOfVictim = ((LivingEntity)victim).func_110143_aJ();
        }
        Vector3d posCache = this.func_213303_ch();
        this.func_70107_b(this.lastPos.field_72450_a, this.lastPos.field_72448_b, this.lastPos.field_72449_c);
        boolean damaged = victim.func_70097_a(new IndirectEntityDamageSource("arrow", (Entity)this, shooter).func_76349_b().func_76359_i(), (float)bullet.modifyDamage(this.damage, this, victim, shooter, this.field_70170_p));
        if (damaged && this.armorBonus && victim instanceof LivingEntity) {
            victim.func_70097_a(new IndirectEntityDamageSource("arrow", (Entity)this, shooter).func_82726_p().func_76349_b().func_76348_h().func_76359_i(), ((Double)KGConfig.ironCarbineArmorBonus.get()).floatValue());
        }
        this.func_70107_b(posCache.field_72450_a, posCache.field_72448_b, posCache.field_72449_c);
        if (victim instanceof LivingEntity) {
            if (this.healthOfVictim == ((LivingEntity)victim).func_110143_aJ()) {
                this.didNoDamage = true;
            }
        } else {
            this.didNoDamage = true;
        }
        if (this.isClean) {
            victim.func_213317_d(previousDelta);
        } else if (damaged && victim instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)victim;
            if (this.shootingGun != null && this.shootingGun.getItem() == ModItems.doubleBarrelShotgun) {
                double actualKnockback = this.knockbackStrength / (double)this.actualTick;
                Vector3d vec = this.func_213322_ci().func_216372_d(1.0, 0.25, 1.0).func_72432_b().func_186678_a(actualKnockback);
                livingTarget.func_70024_g(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            }
            if (this.juggle) {
                Vector3d vel = livingTarget.func_213322_ci();
                livingTarget.func_213317_d(new Vector3d(vel.field_72450_a, 0.4, vel.field_72449_c));
            }
            if (this.applyMode == PotionApplyMode.INJECT) {
                for (EffectInstance effect : this.potionInstance) {
                    livingTarget.func_195064_c(effect);
                }
            }
            bullet.onLivingEntityHit(this, livingTarget, shooter, this.field_70170_p);
        } else if (!damaged && this.ignoreInvulnerability) {
            victim.field_70172_ad = lastHurtResistant;
        }
    }

    protected boolean checkIsSameTeam(Entity player, Entity victim) {
        if (player != null && victim != null) {
            if (victim instanceof BulletEntity) {
                return true;
            }
            if (victim instanceof TameableEntity) {
                return ((TameableEntity)victim).func_70902_q() == player;
            }
            if (player.func_96124_cp() == null || victim.func_96124_cp() == null) {
                return false;
            }
            return player.func_96124_cp() == victim.func_96124_cp() && !victim.func_96124_cp().func_96665_g();
        }
        return true;
    }

    public void explode(Vector3d position) {
        if (this.getShootingGun() == null) {
            return;
        }
        double newRadius = this.getShootingGun().damageMultiplier;
        this.field_70170_p.func_217398_a((Entity)this, position.field_72450_a, position.field_72448_b, position.field_72449_c, (float)newRadius, this.func_70027_ad(), (Boolean)KGConfig.explosionsEnabled.get() != false ? Explosion.Mode.DESTROY : Explosion.Mode.NONE);
        if (this.isWither) {
            List<LivingEntity> entities = this.getExplosionAffected(position, newRadius *= ((Double)KGConfig.witherLauncherEffectRadiusMultiplier.get()).doubleValue());
            Iterator<Object> iterator = entities.iterator();
            while (iterator.hasNext()) {
                LivingEntity mob = (LivingEntity)iterator.next();
                if (this.func_234616_v_() == null || this.checkIsSameTeam(this.func_234616_v_(), (Entity)mob)) continue;
                mob.func_195064_c(new EffectInstance(Effects.field_82731_v, 200, 1));
            }
        }
        if (this.applyMode == PotionApplyMode.SPLASH) {
            for (EffectInstance effect : this.potionInstance) {
                List<LivingEntity> entities = this.getExplosionAffected(position, newRadius * (Double)KGConfig.potionCannonSplashMultiplier.get());
                for (LivingEntity mob : entities) {
                    mob.func_195064_c(new EffectInstance(effect));
                }
            }
        }
        if (this.applyMode == PotionApplyMode.LINGER) {
            AreaEffectCloudEntity areaEffectCloud = new AreaEffectCloudEntity(this.field_70170_p, position.field_72450_a, position.field_72448_b, position.field_72449_c);
            areaEffectCloud.func_184486_b(this.lingeringTime);
            areaEffectCloud.func_184483_a((float)newRadius * 2.0f);
            areaEffectCloud.func_184487_c(-((float)newRadius / (float)this.lingeringTime));
            areaEffectCloud.func_184485_d(10);
            for (EffectInstance effect : this.potionInstance) {
                areaEffectCloud.func_184496_a(effect);
            }
            this.field_70170_p.func_217376_c((Entity)areaEffectCloud);
        }
        this.func_70106_y();
    }

    public List<LivingEntity> getExplosionAffected(Vector3d position, double newRadius) {
        AxisAlignedBB explosionTrace = new AxisAlignedBB(position.field_72450_a - newRadius, position.field_72448_b - newRadius, position.field_72449_c - newRadius, position.field_72450_a + newRadius, position.field_72448_b + newRadius, position.field_72449_c + newRadius);
        return this.field_70170_p.func_217357_a(LivingEntity.class, explosionTrace);
    }

    protected void tryBreakBlock(BlockPos blockPosToTest, ItemStack stack) {
        if (ForgeHooks.isToolEffective((IWorldReader)this.field_70170_p, (BlockPos)blockPosToTest, (ItemStack)stack)) {
            ItemStack itemStackForge = stack;
            boolean mineable = false;
            BlockState targetBlock = this.field_70170_p.func_180495_p(blockPosToTest);
            for (ToolType type : itemStackForge.getToolTypes()) {
                if (itemStackForge.getHarvestLevel(type, null, this.field_70170_p.func_180495_p(blockPosToTest)) < targetBlock.getHarvestLevel()) continue;
                mineable = true;
            }
            if (mineable) {
                this.breakBlock(blockPosToTest);
            }
        }
    }

    protected void breakBlock(BlockPos blockToBreak) {
        Random random = new Random();
        if (this.mineChance - random.nextDouble() > 0.0) {
            this.field_70170_p.func_175655_b(blockToBreak, !this.isCorrupted);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74772_a("tickfired", this.ticksOnFire);
        compound.func_74780_a("damage", this.damage);
        compound.func_74780_a("tsf", (double)this.actualTick);
        compound.func_74757_a("explosive", this.isExplosive);
        compound.func_74757_a("collateral", this.shouldCollateral);
        if (this.ignoreInvulnerability) {
            compound.func_74757_a("ignoreinv", this.ignoreInvulnerability);
        }
        if (this.knockbackStrength != 0.0) {
            compound.func_74780_a("knockback", this.knockbackStrength);
        }
        compound.func_74757_a("clip", this.clip);
        compound.func_74774_a("lava", this.lavaMode);
        compound.func_74780_a("originX", this.origin.field_72450_a);
        compound.func_74780_a("originY", this.origin.field_72448_b);
        compound.func_74780_a("originZ", this.origin.field_72449_c);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.ticksOnFire = compound.func_74763_f("tickfired");
        this.actualTick = compound.func_74763_f("tsf");
        this.damage = compound.func_74769_h("damage");
        this.isExplosive = compound.func_74767_n("explosive");
        this.shouldCollateral = compound.func_74767_n("collateral");
        this.ignoreInvulnerability = compound.func_74767_n("ignoreinv");
        this.knockbackStrength = compound.func_74769_h("knockback");
        this.clip = compound.func_74767_n("clip");
        this.lavaMode = compound.func_74771_c("lava");
        this.origin = new Vector3d(compound.func_74769_h("originX"), compound.func_74769_h("originY"), compound.func_74769_h("originZ"));
    }

    public void setDamage(double damage) {
        this.damage = damage;
    }

    public double getDamage() {
        return this.damage;
    }

    public double getInaccuracy() {
        return this.inaccuracy;
    }

    public void setHealthRewardChance(double rewardChance) {
        this.healthRewardChance = rewardChance;
    }

    public float getPreviousHealthOfVictim() {
        return this.healthOfVictim;
    }

    public void setShouldBreakBlock(boolean breakBlock) {
        this.shouldBreakBlock = breakBlock;
    }

    public boolean rollRewardChance() {
        Random random = new Random();
        return this.healthRewardChance - random.nextDouble() > 0.0;
    }

    public void setInaccuracy(double inaccuracy) {
        this.inaccuracy = inaccuracy;
    }

    public void setBulletSpeed(double speed) {
        this.bulletSpeed = speed;
    }

    public void setIgnoreInvulnerability(boolean ignoreInvulnerability) {
        this.ignoreInvulnerability = ignoreInvulnerability;
    }

    public void setShouldCollateral(boolean collateral) {
        this.shouldCollateral = collateral;
    }

    public void setShouldGlow(boolean glow) {
        this.shouldGlow = glow;
    }

    public void setShootingGun(GunItem gun) {
        this.shootingGun = gun;
    }

    public void setExplosive(boolean explosive) {
        this.isExplosive = explosive;
    }

    public GunItem getShootingGun() {
        return this.shootingGun;
    }

    public void setOrigin(Vector3d shooterOrigin) {
        this.origin = shooterOrigin;
    }

    public Vector3d getOrigin() {
        return this.origin;
    }

    public void setKnockbackStrength(double knockbackStrength) {
        this.knockbackStrength = knockbackStrength;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    protected boolean func_184564_k() {
        return false;
    }

    protected float func_82341_c() {
        return 1.0f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkUtils.getProjectileSpawnPacket((Entity)this);
    }

    public static enum PotionApplyMode {
        NONE,
        INJECT,
        SPLASH,
        LINGER;

    }
}

