/*
 * Decompiled with CFR 0.152.
 */
package xyz.kaleidiodev.kaleidiosguns.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.kaleidiodev.kaleidiosguns.entity.BulletEntity;
import xyz.kaleidiodev.kaleidiosguns.item.HungerBulletItem;
import xyz.kaleidiodev.kaleidiosguns.item.IBullet;
import xyz.kaleidiodev.kaleidiosguns.item.XPBulletItem;

public class BulletItem
extends Item
implements IBullet {
    public final double damage;
    public final int durabilityDamage;

    public BulletItem(Item.Properties properties, double newDamage, int durability) {
        super(properties);
        this.damage = newDamage;
        this.durabilityDamage = durability;
    }

    @Override
    public BulletEntity createProjectile(World world, ItemStack stack, LivingEntity shooter, boolean isPlasma) {
        ItemStack fake = new ItemStack((IItemProvider)this);
        if (this instanceof XPBulletItem || this instanceof HungerBulletItem) {
            fake.func_196082_o().func_74768_a("shot", 1);
        }
        fake.func_196082_o().func_74757_a("isPlasma", isPlasma);
        BulletEntity entity = new BulletEntity(world, shooter);
        entity.func_213898_b(fake);
        entity.setDamage(this.damage);
        return entity;
    }

    @Override
    public void consume(ItemStack stack, PlayerEntity player, ItemStack gunItem) {
        stack.func_190918_g(this.costToUse(gunItem));
        if (stack.func_190926_b()) {
            player.field_71071_by.func_184437_d(stack);
        }
    }

    public boolean hasAmmo(ItemStack stack, PlayerEntity player, ItemStack gunItem) {
        return stack.func_190916_E() >= this.costToUse(gunItem);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.bullet.damage", new Object[]{this.damage}));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.bullet.durability", new Object[]{this.durabilityDamage}));
    }

    public boolean func_77636_d(ItemStack pStack) {
        return pStack.func_196082_o().func_74767_n("isPlasma");
    }
}

