/*
 * Decompiled with CFR 0.152.
 */
package xyz.kaleidiodev.kaleidiosguns.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import xyz.kaleidiodev.kaleidiosguns.config.KGConfig;
import xyz.kaleidiodev.kaleidiosguns.item.BulletItem;
import xyz.kaleidiodev.kaleidiosguns.item.GunItem;
import xyz.kaleidiodev.kaleidiosguns.item.IBullet;
import xyz.kaleidiodev.kaleidiosguns.registry.ModEnchantments;
import xyz.kaleidiodev.kaleidiosguns.registry.ModItems;

public class GatlingItem
extends GunItem {
    protected boolean isFirstShot = true;

    public GatlingItem(Item.Properties properties, int bonusDamage, double damageMultiplier, int fireDelay, double inaccuracy, int enchantability, double attackSpeed, double attackDamage) {
        super(properties, bonusDamage, damageMultiplier, fireDelay, inaccuracy, enchantability, attackSpeed, attackDamage);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.isRedstone) {
            if (this.checkRedstoneLevel(world, player, itemstack) != -1) {
                return this.handleGatling(world, player, itemstack, hand);
            }
            return ActionResult.func_226251_d_((Object)itemstack);
        }
        return this.handleGatling(world, player, itemstack, hand);
    }

    protected ActionResult<ItemStack> handleGatling(World world, PlayerEntity player, ItemStack gun, Hand hand) {
        if (!player.field_71075_bZ.field_75098_d && this.mergeStacks(player, gun).func_190926_b()) {
            return ActionResult.func_226251_d_((Object)gun);
        }
        ItemStack ammo = this.mergeStacks(player, gun);
        if (this.isExplosive && ammo.func_77973_b() == ModItems.flintBullet) {
            return ActionResult.func_226251_d_((Object)gun);
        }
        if (!this.caliburCheck(EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.calibur, (ItemStack)gun), ammo.func_77973_b())) {
            return ActionResult.func_226251_d_((Object)gun);
        }
        player.func_184598_c(hand);
        if (this.isFirstShot && !world.field_72995_K) {
            this.fireGatling(world, (LivingEntity)player, gun, 0, ammo);
        }
        return ActionResult.func_226249_b_((Object)gun);
    }

    public void func_77615_a(ItemStack itemstack, World level, LivingEntity living, int timeLeft) {
        if (!level.field_72995_K) {
            this.isFirstShot = true;
            if (living instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)living;
                player.func_184811_cZ().func_185145_a((Item)this, this.getFireDelay(itemstack, player));
            }
        }
    }

    public void func_219972_a(World world, LivingEntity user, ItemStack gun, int ticks) {
        if (user instanceof PlayerEntity && !world.field_72995_K) {
            PlayerEntity player = (PlayerEntity)user;
            ItemStack ammo = this.mergeStacks(player, gun);
            if (player.func_233643_dh_()) {
                player.func_184602_cy();
            }
            this.fireGatling(world, user, gun, ticks, ammo);
        }
    }

    public void fireGatling(World world, LivingEntity user, ItemStack gun, int ticks, ItemStack ammo) {
        if (user instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)user;
            if (this.isRedstone && this.checkRedstoneLevel(world, player, gun) == -1) {
                player.func_184602_cy();
            }
            int used = this.func_77626_a(gun) - (ticks - 1);
            int rateChange = this.getFireDelay(gun, player) - (this.isDefender && this.checkTileEntities(world, player) ? (Integer)KGConfig.lmgDefenderDelayDelta.get() : 0);
            if ((used > 0 && used % rateChange == 0 || this.isFirstShot) && !world.func_201670_d()) {
                this.isFirstShot = false;
                if (ammo.func_190926_b() && !player.field_71075_bZ.field_75098_d) {
                    player.func_184602_cy();
                }
                if (!ammo.func_190926_b() || player.field_71075_bZ.field_75098_d) {
                    if (ammo.func_190926_b()) {
                        ammo = new ItemStack((IItemProvider)ModItems.flintBullet);
                    }
                    if (ammo.func_77973_b() == Items.field_151032_g) {
                        ammo = new ItemStack((IItemProvider)ModItems.flintBullet);
                    }
                    IBullet bulletItem = (IBullet)(ammo.func_77973_b() instanceof IBullet ? ammo.func_77973_b() : ModItems.flintBullet);
                    if (!world.field_72995_K) {
                        boolean bulletFree = player.field_71075_bZ.field_75098_d || !this.shouldConsumeAmmo(gun, player);
                        ItemStack shotAmmo = ammo.func_77973_b() instanceof IBullet ? ammo : new ItemStack((IItemProvider)ModItems.flintBullet);
                        this.fireWeapon(world, player, gun, shotAmmo, bulletItem, bulletFree);
                        int durabilityDamage = 1;
                        if (((BulletItem)ammo.func_77973_b()).damage >= (Double)KGConfig.blazeBulletDamage.get()) {
                            ++durabilityDamage;
                        }
                        if (((BulletItem)ammo.func_77973_b()).damage >= (Double)KGConfig.xpBulletDamage.get()) {
                            ++durabilityDamage;
                        }
                        gun.func_222118_a(durabilityDamage, (LivingEntity)player, p -> p.func_213334_d(player.func_184600_cs()));
                        if (!bulletFree) {
                            bulletItem.consume(ammo, player, gun);
                        }
                    }
                    float volume = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.silenced, (ItemStack)gun) > 0 ? 2.0f : 10.0f;
                    world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), this.fireSound, SoundCategory.PLAYERS, volume, 1.0f);
                    player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                }
            }
        }
    }

    @Override
    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @Override
    protected void addExtraStatsTooltip(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip) {
        if (((Boolean)KGConfig.showClassDetails.get()).booleanValue()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.gatling.hold"));
        }
    }

    protected boolean checkTileEntities(World world, PlayerEntity player) {
        BlockPos closestPos = null;
        int checkRadius = (Integer)KGConfig.lmgDefenderRange.get();
        int distance = -1;
        for (int x = player.func_233580_cy_().func_177958_n() - checkRadius; x < player.func_233580_cy_().func_177958_n() + checkRadius; ++x) {
            for (int y = player.func_233580_cy_().func_177956_o() - checkRadius; y < player.func_233580_cy_().func_177956_o() + checkRadius; ++y) {
                for (int z = player.func_233580_cy_().func_177952_p() - checkRadius; z < player.func_233580_cy_().func_177952_p() + checkRadius; ++z) {
                    BlockPos checkPos = new BlockPos(x, y, z);
                    if (world.func_175625_s(checkPos) == null || closestPos != null && player.func_233580_cy_().func_218139_n((Vector3i)checkPos) >= player.func_233580_cy_().func_218139_n((Vector3i)closestPos)) continue;
                    closestPos = checkPos;
                }
            }
        }
        if (closestPos != null) {
            distance = closestPos.func_218139_n((Vector3i)player.func_233580_cy_());
        }
        if (distance > checkRadius) {
            distance = -1;
        }
        return distance != -1;
    }
}

