/*
 * Decompiled with CFR 0.152.
 */
package xyz.kaleidiodev.kaleidiosguns.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.kaleidiodev.kaleidiosguns.KaleidiosGuns;
import xyz.kaleidiodev.kaleidiosguns.config.KGConfig;
import xyz.kaleidiodev.kaleidiosguns.enchantment.GunAccuracyEnchantment;
import xyz.kaleidiodev.kaleidiosguns.enchantment.GunDamageEnchantment;
import xyz.kaleidiodev.kaleidiosguns.entity.BulletEntity;
import xyz.kaleidiodev.kaleidiosguns.item.BulletItem;
import xyz.kaleidiodev.kaleidiosguns.item.GatlingItem;
import xyz.kaleidiodev.kaleidiosguns.item.IBullet;
import xyz.kaleidiodev.kaleidiosguns.item.ShotgunItem;
import xyz.kaleidiodev.kaleidiosguns.registry.ModEnchantments;
import xyz.kaleidiodev.kaleidiosguns.registry.ModItems;
import xyz.kaleidiodev.kaleidiosguns.registry.ModSounds;

public class GunItem
extends Item {
    protected int bonusDamage;
    public double damageMultiplier;
    public int hadLava;
    protected int fireDelay;
    protected double inaccuracy;
    protected double projectileSpeed = 3.0;
    private final int enchantability;
    protected boolean ignoreInvulnerability = true;
    protected double chanceFreeShot = 0.0;
    protected boolean hasBlockMineAbility = false;
    protected int revolutions = 1;
    protected boolean shouldCollateral = false;
    protected int barrelSwitchSpeed = -1;
    protected double myKnockback = 0.1;
    protected int stabilityTime;
    protected double instabilitySpreadAdditional;
    protected boolean twoHandBonus;
    public boolean isExplosive;
    protected boolean isWither;
    protected boolean shouldRevenge;
    protected boolean isShadow;
    protected boolean isRedstone;
    protected boolean isCorruption;
    protected boolean hasVoltage;
    protected boolean isDefender;
    protected boolean isOneHanded;
    protected boolean isSensitive;
    protected boolean canFlinch;
    protected boolean isJuggler;
    protected boolean isLava;
    protected boolean isMeleeBonus;
    protected boolean breachDoors;
    protected double baseSpeed;
    protected double baseDamage;
    protected double currentSpeed;
    protected double currentDamage;
    protected int meleeBonusCounter;
    protected double mineChance;
    protected int ammoCost = 1;
    protected int burstSpeed;
    protected int burstAmount;
    protected boolean isVex;
    protected boolean isHero;
    protected boolean isGravity;
    protected boolean isPotion;
    protected boolean interactsWithBlocks;
    protected float sniperReplacementAim = 0.0f;
    protected float sniperMovementAim = 0.0f;
    protected boolean armorBonus;
    protected boolean witherHead;
    protected boolean shouldSlow;
    protected SoundEvent fireSound = ModSounds.gun;
    protected SoundEvent reloadSound = ModSounds.double_shotgunReload;
    protected Supplier<Ingredient> repairMaterial;
    private Multimap<Attribute, AttributeModifier> defaultModifiers;

    public GunItem(Item.Properties properties, int bonusDamage, double damageMultiplier, int fireDelay, double inaccuracy, int enchantability, double attackSpeed, double attackDamage) {
        super(properties);
        this.bonusDamage = bonusDamage;
        this.damageMultiplier = damageMultiplier;
        this.enchantability = enchantability;
        this.fireDelay = fireDelay;
        this.inaccuracy = inaccuracy;
        this.baseSpeed = attackSpeed;
        this.baseDamage = attackDamage;
        this.setAttributes(attackDamage, attackSpeed);
    }

    public void setAttributes(double newDamage, double newSpeed) {
        this.currentDamage = newDamage;
        this.currentSpeed = newSpeed;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Tool modifier", newDamage - 1.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Tool modifier", newSpeed - 4.0, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType pEquipmentSlot) {
        return pEquipmentSlot == EquipmentSlotType.MAINHAND ? this.defaultModifiers : super.func_111205_h(pEquipmentSlot);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack gun = player.func_184586_b(hand);
        ItemStack ammo = this.mergeStacks(player, gun);
        if (this.isExplosive && ammo.func_77973_b() == ModItems.flintBullet) {
            return ActionResult.func_226251_d_((Object)gun);
        }
        if (!this.caliburCheck(EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.calibur, (ItemStack)gun), ammo.func_77973_b())) {
            return ActionResult.func_226251_d_((Object)gun);
        }
        if (this.isRedstone) {
            if (this.checkRedstoneLevel(world, player, gun) != -1) {
                return this.handleWeapon(world, player, gun, hand, ammo);
            }
            return ActionResult.func_226251_d_((Object)gun);
        }
        return this.handleWeapon(world, player, gun, hand, ammo);
    }

    protected boolean caliburCheck(int level, Item item) {
        if (level == 0) {
            return true;
        }
        if (item == ModItems.flintBullet && level == 1) {
            return true;
        }
        if (item == ModItems.ironBullet && level == 2) {
            return true;
        }
        if (item == ModItems.blazeBullet && level == 3) {
            return true;
        }
        if (item == ModItems.hungerBullet && level == 4) {
            return true;
        }
        return item == ModItems.xpBullet && level == 5;
    }

    public ItemStack mergeStacks(PlayerEntity player, ItemStack gun) {
        ItemStack itemstack1;
        int i;
        ItemStack newAmmo = ItemStack.field_190927_a;
        if (!player.field_70170_p.field_72995_K) {
            for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                itemstack1 = player.field_71071_by.func_70301_a(i);
                if (!(itemstack1.func_77973_b() instanceof BulletItem)) continue;
                if (!itemstack1.func_190926_b()) {
                    for (int j = i; j < player.field_71071_by.func_70302_i_(); ++j) {
                        if (j == i || player.field_71071_by.func_70301_a(j).func_77973_b() != itemstack1.func_77973_b()) continue;
                        ItemStack itemstack2 = player.field_71071_by.func_70301_a(j);
                        int needed = 64 - itemstack1.func_190916_E();
                        int has = itemstack2.func_190916_E();
                        if (has < needed) {
                            player.field_71071_by.func_184437_d(itemstack2);
                            itemstack1.func_190917_f(has);
                            continue;
                        }
                        itemstack2.func_190918_g(needed);
                        itemstack1.func_190917_f(needed);
                    }
                }
                if (!itemstack1.func_190926_b()) continue;
                player.field_71071_by.func_184437_d(itemstack1);
            }
        }
        for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            itemstack1 = player.field_71071_by.func_70301_a(i);
            if (!(itemstack1.func_77973_b() instanceof BulletItem)) continue;
            BulletItem item = (BulletItem)itemstack1.func_77973_b();
            if (newAmmo.func_77973_b() instanceof BulletItem) {
                BulletItem otherItem = (BulletItem)newAmmo.func_77973_b();
                if (!item.hasAmmo(itemstack1, player, gun) || !(item.damage > otherItem.damage)) continue;
                newAmmo = itemstack1;
                continue;
            }
            if (!item.hasAmmo(itemstack1, player, gun)) continue;
            newAmmo = itemstack1;
        }
        if (this.isExplosive && player.field_71075_bZ.field_75098_d && newAmmo.func_77973_b() == ModItems.flintBullet) {
            newAmmo = new ItemStack((IItemProvider)ModItems.ironBullet);
        }
        return newAmmo;
    }

    protected int checkRedstoneLevel(World world, PlayerEntity player, ItemStack gun) {
        int redstone = -1;
        if (((GunItem)gun.func_77973_b()).isRedstone) {
            BlockPos closestPos = null;
            int checkRadius = (int)((double)((Integer)KGConfig.redstoneRadius.get()).intValue() * (1.0 + (double)EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.signalBoost, (ItemStack)gun) * (Double)KGConfig.signalMultiplier.get()));
            for (int x = player.func_233580_cy_().func_177958_n() - checkRadius; x < player.func_233580_cy_().func_177958_n() + checkRadius; ++x) {
                for (int y = player.func_233580_cy_().func_177956_o() - checkRadius; y < player.func_233580_cy_().func_177956_o() + checkRadius; ++y) {
                    for (int z = player.func_233580_cy_().func_177952_p() - checkRadius; z < player.func_233580_cy_().func_177952_p() + checkRadius; ++z) {
                        BlockPos checkPos = new BlockPos(x, y, z);
                        if (world.func_180495_p(checkPos).func_177230_c() != Blocks.field_150451_bX || closestPos != null && player.func_233580_cy_().func_218139_n((Vector3i)checkPos) >= player.func_233580_cy_().func_218139_n((Vector3i)closestPos)) continue;
                        closestPos = checkPos;
                    }
                }
            }
            if (closestPos != null) {
                redstone = closestPos.func_218139_n((Vector3i)player.func_233580_cy_());
            }
            if (redstone > checkRadius) {
                redstone = -1;
            }
        }
        return redstone;
    }

    protected ActionResult<ItemStack> handleWeapon(World world, PlayerEntity player, ItemStack gun, Hand hand, ItemStack ammo) {
        if (!ammo.func_190926_b() || player.field_71075_bZ.field_75098_d) {
            if (ammo.func_190926_b()) {
                ammo = new ItemStack((IItemProvider)ModItems.flintBullet);
            }
            if (ammo.func_77973_b() == Items.field_151032_g) {
                ammo = new ItemStack((IItemProvider)ModItems.flintBullet);
            }
            IBullet bulletItem = (IBullet)(ammo.func_77973_b() instanceof IBullet ? ammo.func_77973_b() : ModItems.flintBullet);
            if (!world.field_72995_K) {
                boolean bulletFree = player.field_71075_bZ.field_75098_d || !this.shouldConsumeAmmo(gun, player);
                ItemStack shotAmmo = ammo.func_77973_b() instanceof IBullet ? ammo : new ItemStack((IItemProvider)ModItems.flintBullet);
                this.fireWeapon(world, player, gun, shotAmmo, bulletItem, bulletFree);
                gun.func_222118_a(((BulletItem)ammo.func_77973_b()).durabilityDamage, (LivingEntity)player, p -> p.func_213334_d(player.func_184600_cs()));
                if (!bulletFree) {
                    bulletItem.consume(ammo, player, gun);
                }
                float volume = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.silenced, (ItemStack)gun) > 0 ? 2.0f : 10.0f;
                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), this.fireSound, SoundCategory.PLAYERS, volume, 1.0f);
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                CompoundNBT nbt = gun.func_196082_o();
                if (this.revolutions > 1) {
                    if (!nbt.func_74764_b("chambers")) {
                        nbt.func_74768_a("chambers", this.revolutions);
                    }
                    int chambers = nbt.func_74762_e("chambers");
                    if (--chambers <= 0) {
                        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), this.reloadSound, SoundCategory.HOSTILE, 1.0f, 1.0f);
                        chambers = this.revolutions;
                    }
                    nbt.func_74768_a("chambers", chambers);
                    gun.func_77982_d(nbt);
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.tracer, (ItemStack)gun) > 0) {
                    player.func_195064_c(new EffectInstance(Effects.field_188423_x, ((Integer)KGConfig.playerGlowTicks.get()).intValue(), 0));
                }
                player.func_184811_cZ().func_185145_a((Item)this, this.getActualFireDelay(gun, player));
                if (player.func_184614_ca().func_77973_b() == this) {
                    if (player.func_184592_cb().func_77973_b() instanceof GunItem) {
                        player.func_184811_cZ().func_185145_a(player.func_184592_cb().func_77973_b(), this.getActualFireDelay(gun, player) + 1);
                    }
                } else if (player.func_184592_cb().func_77973_b() != this && player.func_184592_cb().func_77973_b() instanceof GunItem) {
                    player.func_184811_cZ().func_185145_a(player.func_184614_ca().func_77973_b(), this.getActualFireDelay(gun, player) + 1);
                }
                this.mergeStacks(player, gun);
            }
            player.func_184598_c(hand);
            return ActionResult.func_226249_b_((Object)gun);
        }
        return ActionResult.func_226251_d_((Object)gun);
    }

    protected void fireWeapon(World world, PlayerEntity player, ItemStack gun, ItemStack ammo, IBullet bulletItem, boolean bulletFree) {
        ItemStack membrane;
        boolean isPlasma = gun.func_77973_b() == ModItems.plasmaGatling;
        double nextInaccuracy = this.getInaccuracy(gun, player);
        BulletEntity shot = bulletItem.createProjectile(world, ammo, (LivingEntity)player, isPlasma);
        this.shootShot(shot, player, gun, nextInaccuracy);
        Vector3d projectileMotion = player.func_213322_ci();
        shot.func_213317_d(shot.func_213322_ci().func_178786_a(projectileMotion.field_72450_a, player.func_233570_aj_() ? 0.0 : projectileMotion.field_72448_b, projectileMotion.field_72449_c));
        shot.setShootingGun(this);
        shot.setInaccuracy(nextInaccuracy);
        shot.setIgnoreInvulnerability(this.ignoreInvulnerability);
        shot.setHealthRewardChance((double)EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.passionForBlood, (ItemStack)gun) * 0.1);
        shot.setShouldBreakBlock(this.hasBlockMineAbility);
        shot.setShouldCollateral(this.shouldCollateral);
        shot.setBulletSpeed(this.getProjectileSpeed(gun, player));
        shot.setKnockbackStrength(this.myKnockback);
        shot.setExplosive(this.isExplosive);
        shot.setShouldGlow(EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.tracer, (ItemStack)gun) > 0);
        shot.setOrigin(player.func_213303_ch());
        shot.func_189654_d(!this.isGravity);
        double someDamage = (shot.getDamage() + this.getBonusDamage(gun, player)) * this.getDamageMultiplier(gun);
        if (gun.func_77973_b() instanceof ShotgunItem) {
            ShotgunItem thisGun = (ShotgunItem)gun.func_77973_b();
            shot.setDamage(someDamage * ((double)thisGun.getBaseBulletCount() / (double)thisGun.getBulletCount(gun, player)));
        } else if (player.func_184614_ca().func_190926_b() ^ player.func_184592_cb().func_190926_b() && this.twoHandBonus) {
            shot.setDamage(someDamage * (Double)KGConfig.goldShowmanTwoHandedUse.get());
        } else {
            shot.setDamage(someDamage);
        }
        boolean bl = shot.wasRevenge = this.shouldRevenge && (double)player.func_110143_aJ() < (double)player.func_110138_aP() * (Double)KGConfig.emeraldBlessedHealthMinimumRatio.get();
        boolean bl2 = this.isShadow && (!world.func_226690_K_() ? Math.max(world.func_226658_a_(LightType.SKY, player.func_233580_cy_().func_177981_b(1)), world.func_226658_a_(LightType.BLOCK, player.func_233580_cy_().func_177981_b(1))) : world.func_226658_a_(LightType.BLOCK, player.func_233580_cy_().func_177981_b(1))) <= (Integer)KGConfig.shadowRevolverLightLevelRequired.get() ? true : (shot.wasDark = false);
        if (this.hasVoltage) {
            shot.redstoneLevel = this.checkRedstoneLevel(world, player, gun);
        }
        boolean noPhysics = this.shouldCollateral;
        boolean vex = false;
        if (this.isVex && (membrane = this.getOtherHand(player)).func_77973_b() == Items.field_204840_eX) {
            noPhysics = true;
            vex = true;
            if (!player.field_71075_bZ.field_75098_d) {
                membrane.func_190918_g(1);
                if (membrane.func_190926_b()) {
                    player.field_71071_by.func_184437_d(membrane);
                }
            }
        }
        shot.field_70145_X = noPhysics;
        shot.clip = vex;
        shot.isPlasma = this.getItem() == ModItems.plasmaGatling;
        shot.isClean = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.cleanShot, (ItemStack)gun) > 0;
        shot.isWither = this.isWither;
        shot.isCorrupted = this.isCorruption;
        shot.isTorpedo = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.torpedo, (ItemStack)gun) == 1;
        shot.shouldBreakDoors = this.breachDoors;
        shot.shouldFlinch = this.canFlinch;
        shot.healsFriendlies = this.isDefender;
        shot.isMeleeBonus = this.meleeBonusCounter > 0;
        shot.shootsLights = this.isShadow;
        shot.juggle = this.isJuggler;
        shot.interactsWithBlocks = this.interactsWithBlocks;
        shot.silenced = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.silenced, (ItemStack)gun) == 1;
        shot.armorBonus = this.armorBonus;
        shot.shouldSlow = this.shouldSlow;
        shot.hero = false;
        if (this.isHero) {
            Collection effectsOnPlayer = player.func_70651_bq();
            for (EffectInstance effect : effectsOnPlayer) {
                if (effect.func_188419_a().func_220303_e() != EffectType.HARMFUL) continue;
                shot.hero = true;
                break;
            }
        }
        shot.mineChance = player.func_70660_b(Effects.field_76422_e) != null ? this.mineChance + (Double)KGConfig.hasteBonusMineChance.get() * (double)player.func_70660_b(Effects.field_76422_e).func_76458_c() : this.mineChance;
        if (this.isLava) {
            shot.lavaMode = (byte)4;
            ItemStack bucket = this.getOtherHand(player);
            if (bucket.func_77973_b() == Items.field_151129_at) {
                this.hadLava = (Integer)KGConfig.lavaSmgLavaBonusCount.get();
                player.field_71071_by.func_184437_d(bucket);
                player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Items.field_151133_ar));
            }
            if (player.func_70027_ad()) {
                shot.lavaMode = (byte)(shot.lavaMode + 1);
            }
            if (this.hadLava > 0) {
                shot.lavaMode = (byte)(shot.lavaMode + 8);
                --this.hadLava;
            }
        }
        if (this.isPotion) {
            ItemStack potion = this.getOtherHand(player);
            shot.applyMode = BulletEntity.PotionApplyMode.NONE;
            if (potion.func_77973_b() == Items.field_151068_bn) {
                shot.applyMode = BulletEntity.PotionApplyMode.INJECT;
            }
            if (potion.func_77973_b() == Items.field_185156_bI) {
                shot.applyMode = BulletEntity.PotionApplyMode.LINGER;
                shot.lingeringTime = (Integer)KGConfig.potionCannonLingeringTime.get();
            }
            if (potion.func_77973_b() == Items.field_185155_bH) {
                shot.applyMode = BulletEntity.PotionApplyMode.SPLASH;
            }
            if (shot.applyMode != BulletEntity.PotionApplyMode.NONE) {
                Potion actualPotion = PotionUtils.func_185191_c((ItemStack)potion);
                shot.potionInstance = actualPotion.func_185170_a();
                potion.func_190918_g(1);
                if (potion.func_190926_b()) {
                    player.field_71071_by.func_184437_d(potion);
                }
            }
        }
        if (this.meleeBonusCounter > 0) {
            --this.meleeBonusCounter;
        }
        this.changeBullet(world, player, gun, shot, bulletFree);
        CompoundNBT nbt = gun.func_196082_o();
        int base = Math.max(1, this.stabilityTime - (int)((double)(this.stabilityTime * EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.sleightOfHand, (ItemStack)gun)) * (Double)KGConfig.sleightOfHandFireRateDecrease.get()));
        nbt.func_74768_a("stabilizerTimer", base);
        nbt.func_74768_a("shotsBeforeStability", nbt.func_74762_e("shotsBeforeStability") + 1);
        int burstTimer = nbt.func_74762_e("burstTimer");
        if (burstTimer == 0) {
            ItemStack offhand = this.getOtherHand(player);
            if (this.witherHead && offhand.func_77973_b() == Items.field_196183_dw) {
                if (!player.field_71075_bZ.field_75098_d) {
                    offhand.func_190918_g(1);
                    if (offhand.func_190926_b()) {
                        player.field_71071_by.func_184437_d(offhand);
                    }
                }
                burstTimer = this.burstSpeed * this.burstAmount;
            } else if (!this.witherHead) {
                burstTimer = this.burstSpeed * this.burstAmount;
            }
        }
        nbt.func_74768_a("burstTimer", burstTimer);
        gun.func_77982_d(nbt);
        shot.traceHits();
        world.func_217376_c((Entity)shot);
    }

    public ItemStack getOtherHand(PlayerEntity player) {
        ItemStack otherItem = player.func_184600_cs() == Hand.OFF_HAND ? player.func_184586_b(Hand.MAIN_HAND) : player.func_184586_b(Hand.OFF_HAND);
        return otherItem;
    }

    public void shootShot(BulletEntity shot, PlayerEntity player, ItemStack gun, double nextInaccuracy) {
        shot.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, (float)this.getProjectileSpeed(gun, player), KaleidiosGuns.VivecraftForgeExtensionPresent ? 0.0f : (float)nextInaccuracy);
    }

    public void func_77663_a(ItemStack pStack, World pLevel, Entity pEntity, int pItemSlot, boolean pIsSelected) {
        long ticksPassed;
        CompoundNBT nbt = pStack.func_196082_o();
        long currentTime = pLevel.func_82737_E();
        if (!nbt.func_74764_b("ticksPassed")) {
            nbt.func_74772_a("ticksPassed", currentTime);
        }
        if (currentTime > (ticksPassed = nbt.func_74763_f("ticksPassed"))) {
            nbt.func_74772_a("ticksPassed", currentTime);
            pStack.func_77982_d(nbt);
            this.onActualInventoryTick(pLevel, pEntity, pStack);
        }
        super.func_77663_a(pStack, pLevel, pEntity, pItemSlot, pIsSelected);
    }

    public boolean func_77644_a(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        if (this.isMeleeBonus) {
            this.meleeBonusCounter = (Integer)KGConfig.emeraldMusketPostMeleeCount.get();
        }
        return super.func_77644_a(pStack, pTarget, pAttacker);
    }

    protected void onActualInventoryTick(World world, Entity entity, ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        Vector3d previousPos = new Vector3d(nbt.func_74769_h("previousPosX"), nbt.func_74769_h("previousPosY"), nbt.func_74769_h("previousPosZ"));
        int stabilizerTimer = nbt.func_74762_e("stabilizerTimer");
        int burstTimer = nbt.func_74762_e("burstTimer");
        Vector3d playerVelocity = entity.func_213303_ch().func_178788_d(previousPos);
        nbt.func_74780_a("playerVelocityX", playerVelocity.field_72450_a);
        nbt.func_74780_a("playerVelocityY", playerVelocity.field_72448_b);
        nbt.func_74780_a("playerVelocityZ", playerVelocity.field_72449_c);
        nbt.func_74780_a("previousPosX", entity.func_213303_ch().field_72450_a);
        nbt.func_74780_a("previousPosY", entity.func_213303_ch().field_72448_b);
        nbt.func_74780_a("previousPosZ", entity.func_213303_ch().field_72449_c);
        if (stabilizerTimer > 0) {
            --stabilizerTimer;
        }
        if (stabilizerTimer == 0) {
            nbt.func_74768_a("shotsBeforeStability", 0);
        }
        nbt.func_74768_a("stabilizerTimer", stabilizerTimer);
        if (burstTimer > 0) {
            --burstTimer;
        }
        if (this.burstSpeed != 0 && burstTimer % this.burstSpeed == 0 && entity instanceof PlayerEntity && burstTimer > 0) {
            PlayerEntity player = (PlayerEntity)entity;
            if (this == player.func_184614_ca().func_77973_b()) {
                this.func_77659_a(world, (PlayerEntity)entity, Hand.MAIN_HAND);
            }
            if (this == player.func_184592_cb().func_77973_b()) {
                this.func_77659_a(world, (PlayerEntity)entity, Hand.OFF_HAND);
            }
        }
        nbt.func_74768_a("burstTimer", burstTimer);
        stack.func_77982_d(nbt);
    }

    protected void changeBullet(World world, PlayerEntity player, ItemStack gun, BulletEntity bullet, boolean bulletFree) {
    }

    public boolean shouldConsumeAmmo(ItemStack stack, PlayerEntity player) {
        if (this.chanceFreeShot > 0.0 && field_77697_d.nextDouble() < this.chanceFreeShot) {
            return false;
        }
        int preserving = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.preserving, (ItemStack)stack);
        return !((double)preserving * (Double)KGConfig.preservingRateIncrease.get() - field_77697_d.nextDouble() > 0.0);
    }

    public double getBonusDamage(ItemStack stack, @Nullable PlayerEntity player) {
        int impact = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.impact, (ItemStack)stack);
        return (double)this.bonusDamage + (impact >= 1 ? (double)impact * (Double)KGConfig.impactDamageIncrease.get() : 0.0);
    }

    public double getDamageMultiplier(ItemStack stack) {
        return this.damageMultiplier * ((double)this.getFireDelayRaw(stack) / (double)this.fireDelay);
    }

    public int getFireDelayRaw(ItemStack stack) {
        return Math.max(1, this.fireDelay - (int)((double)(this.fireDelay * EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.sleightOfHand, (ItemStack)stack)) * (Double)KGConfig.sleightOfHandFireRateDecrease.get()));
    }

    public int getFireDelay(ItemStack stack, @Nullable PlayerEntity player) {
        int base = this.getFireDelayRaw(stack);
        CompoundNBT nbt = stack.func_196082_o();
        if (!nbt.func_74764_b("chambers")) {
            return base;
        }
        if (nbt.func_74762_e("chambers") == this.revolutions) {
            return base;
        }
        return Math.max(1, base / this.barrelSwitchSpeed);
    }

    public int getActualFireDelay(ItemStack stack, @Nullable PlayerEntity player) {
        int base = this.getFireDelay(stack, player);
        if (player != null) {
            if (player.func_70644_a(Effects.field_76419_f) && !(stack.func_77973_b() instanceof GatlingItem)) {
                base = (int)((double)base * (1.0 + (double)player.func_70660_b(Effects.field_76419_f).func_76458_c() * 0.2));
            }
            if (player.func_70644_a(Effects.field_76422_e) && !(stack.func_77973_b() instanceof GatlingItem)) {
                base = (int)((double)base * (1.0 - 0.1 * (double)player.func_70660_b(Effects.field_76422_e).func_76458_c()));
            }
        }
        if (player != null && EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.cowboy, (ItemStack)stack) == 0 && stack.func_77973_b() instanceof ShotgunItem) {
            if (!player.func_184614_ca().func_190926_b() && !player.func_184592_cb().func_190926_b()) {
                base = (int)((double)base * (Double)KGConfig.oneHandShotgunRateMultiplier.get());
            }
            if (player.func_70644_a(Effects.field_76437_t)) {
                base = (int)((double)base * ((Double)KGConfig.oneHandShotgunRateMultiplier.get() * (double)(player.func_70660_b(Effects.field_76437_t).func_76458_c() + 1)));
            }
        }
        return base;
    }

    public boolean hasPerfectAccuracy() {
        return this.inaccuracy <= 0.0;
    }

    public double getInaccuracy(ItemStack stack, @Nullable PlayerEntity player) {
        double nextInaccuracy = this.baseInaccuracy(stack, player);
        CompoundNBT nbt = stack.func_196082_o();
        nextInaccuracy += (double)nbt.func_74762_e("shotsBeforeStability") * Math.max(0.0, this.instabilitySpreadAdditional / ((double)EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.bullseye, (ItemStack)stack) * (Double)KGConfig.bullseyeAccuracyIncrease.get() + 1.0));
        if (player != null) {
            Vector3d playerVelocity = new Vector3d(nbt.func_74769_h("playerVelocityX"), nbt.func_74769_h("playerVelocityY"), nbt.func_74769_h("playerVelocityZ"));
            if (this.inaccuracy == 0.0 && playerVelocity.func_72433_c() > 0.03 && !(this instanceof GatlingItem) && !(this instanceof ShotgunItem)) {
                nextInaccuracy += (double)this.sniperMovementAim;
            }
            if (!(EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.cowboy, (ItemStack)stack) != 0 || stack.func_77973_b() instanceof ShotgunItem || this.isOneHanded || player.func_184614_ca().func_190926_b() || player.func_184592_cb().func_190926_b())) {
                nextInaccuracy = this.inaccuracy == 0.0 ? (nextInaccuracy += (double)this.sniperReplacementAim) : (nextInaccuracy *= ((Double)KGConfig.oneHandInaccuracyMultiplier.get()).doubleValue());
            }
            if (!player.func_233570_aj_() && EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.cowboy, (ItemStack)stack) == 0 && this.isSensitive) {
                nextInaccuracy *= (Double)KGConfig.sensitivityMultiplier.get() * 1.5;
            } else if (this.isSensitive && !player.func_213453_ef() && (Double)KGConfig.sensitivityMultiplier.get() != 0.0) {
                nextInaccuracy *= ((Double)KGConfig.sensitivityMultiplier.get()).doubleValue();
            }
            if (player.func_70660_b(Effects.field_76437_t) != null && !(stack.func_77973_b() instanceof ShotgunItem)) {
                nextInaccuracy = nextInaccuracy == 0.0 ? (nextInaccuracy += (double)this.sniperReplacementAim * (Double)KGConfig.weaknessEffectInaccuracyMultiplier.get() * (double)(player.func_70660_b(Effects.field_76437_t).func_76458_c() + 1)) : (nextInaccuracy *= (Double)KGConfig.weaknessEffectInaccuracyMultiplier.get() * (double)(player.func_70660_b(Effects.field_76437_t).func_76458_c() + 1));
            }
            if (player.func_70660_b(Effects.field_188425_z) != null && !(stack.func_77973_b() instanceof ShotgunItem)) {
                nextInaccuracy /= (Double)KGConfig.luckEffectInaccuracyDivider.get() * (double)(player.func_70660_b(Effects.field_188425_z).func_76458_c() + 1);
            }
        }
        return nextInaccuracy;
    }

    public double baseInaccuracy(ItemStack stack, @Nullable PlayerEntity player) {
        return Math.max(0.0, this.inaccuracy / ((double)EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.bullseye, (ItemStack)stack) * (Double)KGConfig.bullseyeAccuracyIncrease.get() + 1.0));
    }

    public double getProjectileSpeed(ItemStack stack, @Nullable PlayerEntity player) {
        return this.baseSpeed(stack, player);
    }

    public double baseSpeed(ItemStack stack, @Nullable PlayerEntity player) {
        return Math.max(0.0, this.projectileSpeed + (double)EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.accelerator, (ItemStack)stack) * (Double)KGConfig.acceleratorSpeedIncrease.get() * this.projectileSpeed);
    }

    public double getInverseChanceFreeShot(ItemStack stack, @Nullable PlayerEntity player) {
        double chance = 1.0 - this.chanceFreeShot;
        int preserving = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.preserving, (ItemStack)stack);
        if (preserving >= 1) {
            chance *= (double)preserving * (Double)KGConfig.preservingRateIncrease.get();
        }
        return chance;
    }

    protected boolean isDamageModified(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.impact, (ItemStack)stack) >= 1;
    }

    protected boolean isFireDelayModified(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.sleightOfHand, (ItemStack)stack) >= 1;
    }

    protected boolean isInaccuracyModified(ItemStack stack) {
        return !this.hasPerfectAccuracy() && EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.bullseye, (ItemStack)stack) >= 1;
    }

    protected boolean isChanceFreeShotModified(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.preserving, (ItemStack)stack) >= 1;
    }

    protected boolean isProjectileSpeedModified(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.accelerator, (ItemStack)stack) >= 1;
    }

    public GunItem fireSound(SoundEvent fireSound) {
        this.fireSound = fireSound;
        return this;
    }

    public GunItem reloadSound(SoundEvent newReloadSound) {
        this.reloadSound = newReloadSound;
        return this;
    }

    public GunItem projectileSpeed(double projectileSpeed) {
        this.projectileSpeed = projectileSpeed;
        return this;
    }

    public GunItem canMineBlocks(boolean mineBlocks) {
        this.hasBlockMineAbility = mineBlocks;
        return this;
    }

    public GunItem repair(Supplier<Ingredient> repairMaterial) {
        this.repairMaterial = repairMaterial;
        return this;
    }

    public GunItem chambers(int revolverCount) {
        this.revolutions = revolverCount;
        return this;
    }

    public GunItem collateral(boolean collateralSetting) {
        this.shouldCollateral = collateralSetting;
        return this;
    }

    public GunItem setKnockbackStrength(double newKnockback) {
        this.myKnockback = newKnockback;
        return this;
    }

    public GunItem instabilityAdditionalSpread(double additionalSpread) {
        this.instabilitySpreadAdditional = additionalSpread;
        return this;
    }

    public GunItem setStabilityTime(int stability) {
        this.stabilityTime = stability;
        return this;
    }

    public GunItem setTwoHandBonus(boolean twoHand) {
        this.twoHandBonus = twoHand;
        return this;
    }

    public GunItem setIsExplosive(boolean explosive) {
        this.isExplosive = explosive;
        return this;
    }

    public GunItem setIsWither(boolean wither) {
        this.isWither = wither;
        return this;
    }

    public GunItem setShouldRevenge(boolean revenge) {
        this.shouldRevenge = revenge;
        return this;
    }

    public GunItem setIsShadow(boolean shadow) {
        this.isShadow = shadow;
        return this;
    }

    public GunItem setIsRedstone(boolean redstone) {
        this.isRedstone = redstone;
        return this;
    }

    public GunItem setIsCorruption(boolean corruption) {
        this.isCorruption = corruption;
        return this;
    }

    public GunItem setHasVoltage(boolean voltage) {
        this.hasVoltage = voltage;
        return this;
    }

    public GunItem setIsDefender(boolean defender) {
        this.isDefender = defender;
        return this;
    }

    public GunItem setIsOneHanded(boolean oneHanded) {
        this.isOneHanded = oneHanded;
        return this;
    }

    public GunItem setIsSensitive(boolean sensitive) {
        this.isSensitive = sensitive;
        return this;
    }

    public GunItem setIsJuggler(boolean juggle) {
        this.isJuggler = juggle;
        return this;
    }

    public GunItem setCanFlinch(boolean flinch) {
        this.canFlinch = flinch;
        return this;
    }

    public GunItem setBreachDoors(boolean breach) {
        this.breachDoors = breach;
        return this;
    }

    public GunItem setIsLava(boolean slag) {
        this.isLava = slag;
        return this;
    }

    public GunItem setMeleeBonus(boolean meleeBonus) {
        this.isMeleeBonus = meleeBonus;
        return this;
    }

    public GunItem setMineChance(double newMineChance) {
        this.mineChance = newMineChance;
        return this;
    }

    public GunItem setCost(int cost) {
        this.ammoCost = cost;
        return this;
    }

    public GunItem setVex(boolean vex) {
        this.isVex = vex;
        return this;
    }

    public GunItem setBurst(int burstRate, int burstCount) {
        this.burstSpeed = burstRate;
        this.burstAmount = burstCount;
        return this;
    }

    public GunItem setHero(boolean hero) {
        this.isHero = hero;
        return this;
    }

    public GunItem setSniperAim(double sniperAim) {
        this.sniperMovementAim = (float)sniperAim;
        return this;
    }

    public GunItem setSniperReplacementAim(double sniperReplacement) {
        this.sniperReplacementAim = (float)sniperReplacement;
        return this;
    }

    public GunItem setIsGravity(boolean gravity) {
        this.isGravity = gravity;
        return this;
    }

    public GunItem setIsPotion(boolean potion) {
        this.isPotion = potion;
        return this;
    }

    public GunItem setInteractBlocks(boolean interact) {
        this.interactsWithBlocks = interact;
        return this;
    }

    public GunItem setWitherHead(boolean head) {
        this.witherHead = head;
        return this;
    }

    public GunItem setShouldSlow(boolean slow) {
        this.shouldSlow = slow;
        return this;
    }

    public int getCost(ItemStack stack) {
        return Math.max(1, this.ammoCost - (int)((double)(this.ammoCost * EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.sleightOfHand, (ItemStack)stack)) * (Double)KGConfig.sleightOfHandFireRateDecrease.get()));
    }

    public GunItem setArmorBonus(boolean bonus) {
        this.armorBonus = bonus;
        return this;
    }

    public GunItem setBarrelSwitchSpeed(int barrelSwitch) {
        this.barrelSwitchSpeed = barrelSwitch;
        return this;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return super.isBookEnchantable(stack, book);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        GunItem me = (GunItem)stack.func_77973_b();
        if (enchantment instanceof GunAccuracyEnchantment && this.hasPerfectAccuracy()) {
            return false;
        }
        if (enchantment instanceof GunDamageEnchantment && this.isExplosive) {
            return false;
        }
        if (enchantment == ModEnchantments.cowboy && this.isOneHanded) {
            return false;
        }
        if (enchantment == ModEnchantments.sleightOfHand && (me instanceof GatlingItem || me.isExplosive)) {
            return false;
        }
        if (enchantment == ModEnchantments.impact && (this == ModItems.minegunGatling || this == ModItems.corruptionGatling)) {
            return false;
        }
        if (enchantment == ModEnchantments.division && !(me instanceof ShotgunItem)) {
            return false;
        }
        if (enchantment == ModEnchantments.cleanShot && (me instanceof ShotgunItem || me instanceof GatlingItem || me.isExplosive || me.getInaccuracy(stack, null) != 0.0)) {
            return false;
        }
        if (enchantment == ModEnchantments.signalBoost && !this.isRedstone) {
            return false;
        }
        if (enchantment == ModEnchantments.tracer && (me instanceof ShotgunItem || me instanceof GatlingItem || me.isExplosive || me.getInaccuracy(stack, null) == 0.0)) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_()) {
            int calibur;
            CompoundNBT nbt = stack.func_196082_o();
            if (!nbt.func_74764_b("chambers")) {
                nbt.func_74768_a("chambers", this.revolutions);
            }
            stack.func_77982_d(nbt);
            double damageMultiplier = this.getDamageMultiplier(stack);
            double damageBonus = this.getBonusDamage(stack, null) * damageMultiplier;
            if (this instanceof ShotgunItem) {
                if (this.isExplosive) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.gun.shotgun.damage.explosion", new Object[]{ItemStack.field_111284_a.format(damageMultiplier)}));
                } else if (damageMultiplier != 1.0) {
                    if (damageBonus != 0.0) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.gun.shotgun.damage.both" + (this.isDamageModified(stack) ? ".modified" : ""), new Object[]{ItemStack.field_111284_a.format(damageMultiplier), ItemStack.field_111284_a.format(damageBonus)}));
                    } else {
                        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.gun.shotgun.damage.mult" + (this.isDamageModified(stack) ? ".modified" : ""), new Object[]{ItemStack.field_111284_a.format(damageMultiplier)}));
                    }
                } else if (damageBonus != 0.0) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.gun.shotgun.damage.flat" + (this.isDamageModified(stack) ? ".modified" : ""), new Object[]{ItemStack.field_111284_a.format(damageBonus)}));
                }
            } else if (this.isExplosive) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.gun.damage.explosion", new Object[]{ItemStack.field_111284_a.format(damageMultiplier)}));
            } else if (damageMultiplier != 1.0) {
                if (damageBonus != 0.0) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.gun.damage.both" + (this.isDamageModified(stack) ? ".modified" : ""), new Object[]{ItemStack.field_111284_a.format(damageMultiplier), ItemStack.field_111284_a.format(damageBonus)}));
                } else {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.gun.damage.mult" + (this.isDamageModified(stack) ? ".modified" : ""), new Object[]{ItemStack.field_111284_a.format(damageMultiplier)}));
                }
            } else if (damageBonus != 0.0) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.gun.damage.flat" + (this.isDamageModified(stack) ? ".modified" : ""), new Object[]{ItemStack.field_111284_a.format(damageBonus)}));
            }
            int fireRate = this.getFireDelayRaw(stack);
            if (this.revolutions > 1) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.gun.reloadspeed" + (this.isFireDelayModified(stack) ? ".modified" : ""), new Object[]{ItemStack.field_111284_a.format((double)fireRate / 20.0)}));
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.gun.barrels_left", new Object[]{nbt.func_74762_e("chambers"), this.revolutions}));
                fireRate = Math.max(1, fireRate / this.barrelSwitchSpeed);
            }
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.gun.firerate" + (this.isFireDelayModified(stack) ? ".modified" : ""), new Object[]{1200 / fireRate}));
            double inaccuracy = this.baseInaccuracy(stack, null);
            double projectileSpeed = this.baseSpeed(stack, null) * 16.0;
            inaccuracy = inaccuracy * 0.0075 * 2.5 * projectileSpeed;
            double timeToInaccurate = 0.425 / inaccuracy;
            inaccuracy = projectileSpeed * timeToInaccurate;
            if (inaccuracy == Double.POSITIVE_INFINITY) {
                if (this instanceof GatlingItem || this instanceof ShotgunItem || this.isExplosive || this.isRedstone) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.gun.accuracy.perfect" + (this.isInaccuracyModified(stack) ? ".modified" : "")));
                } else {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.gun.accuracy.perfect.sniper"));
                }
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.gun.accuracy" + (this.isInaccuracyModified(stack) ? ".modified" : ""), new Object[]{ItemStack.field_111284_a.format(inaccuracy)}));
            }
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.gun.speed" + (this.isProjectileSpeedModified(stack) ? ".modified" : ""), new Object[]{ItemStack.field_111284_a.format(projectileSpeed)}));
            int cost = this.getCost(stack);
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.gun.cost" + (this.ammoCost > cost ? ".modified" : ""), new Object[]{cost}));
            double inverseChanceFree = this.getInverseChanceFreeShot(stack, null);
            if (inverseChanceFree < 1.0) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.gun.chance_free" + (this.isChanceFreeShotModified(stack) ? ".modified" : ""), new Object[]{(int)((1.0 - inverseChanceFree) * 100.0)}));
            }
            if ((calibur = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.calibur, (ItemStack)stack)) > 0) {
                String result = "tooltip.kaleidiosguns.calibur";
                if (calibur == 1) {
                    result = result + ".flint";
                }
                if (calibur == 2) {
                    result = result + ".iron";
                }
                if (calibur == 3) {
                    result = result + ".blaze";
                }
                if (calibur == 4) {
                    result = result + ".hunger";
                }
                if (calibur == 5) {
                    result = result + ".xp";
                }
                tooltip.add((ITextComponent)new TranslationTextComponent(result));
            }
            if (((Boolean)KGConfig.showWeaponDetails.get()).booleanValue()) {
                if (this.shouldCollateral) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.collateral"));
                }
                if (this.twoHandBonus) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.showman_handgun"));
                }
                if (this.shouldRevenge) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.blessed"));
                }
                if (this.isShadow) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.shadow"));
                }
                if (this.canFlinch) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.shatter"));
                }
                if (this.isJuggler) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.juggle"));
                }
                if (this.hasVoltage) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.voltage"));
                }
                if (this.isMeleeBonus) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.melee"));
                }
                if (this.isLava) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.lava"));
                }
                if (this.isVex) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.vex"));
                }
                if (this.isHero) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.hero"));
                }
                if (this.isPotion) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.potion"));
                }
                if (this.interactsWithBlocks) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.interact"));
                }
                if (this.breachDoors) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.doors"));
                }
                if (this.isCorruption) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.corruption"));
                }
                if (this.armorBonus) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.armor_bonus", new Object[]{KGConfig.ironCarbineArmorBonus.get()}));
                }
                if (this.getItem() == ModItems.doubleBarrelShotgun) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.knockback"));
                }
                if (this.getItem() == ModItems.plasmaGatling) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.plasma"));
                }
                if (this.witherHead) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.wither_head"));
                }
                if (this.isDefender) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.heals"));
                }
                if (this.shouldSlow) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.slows"));
                }
                if (this.hasBlockMineAbility) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.minegun"));
                }
            }
            if (((Boolean)KGConfig.showWeaponSecrets.get()).booleanValue()) {
                if (this.isShadow) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.shadow_block"));
                }
                if (this.isWither) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.wither"));
                }
                if (this.isDefender) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.defender"));
                }
            }
            if (((Boolean)KGConfig.showClassDetails.get()).booleanValue()) {
                if (this.isRedstone) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.redstone"));
                }
                if (this.revolutions > 1) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.double_barrel"));
                }
                if (stack.func_77973_b() == ModItems.revolver) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.revolver"));
                }
                if (this.isSensitive) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.sensitive"));
                }
                if (this.isExplosive) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.explosive"));
                }
                if (!this.isOneHanded && EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.cowboy, (ItemStack)stack) == 0 && this instanceof ShotgunItem) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.twohands_shotgun"));
                }
                if (!this.isOneHanded && EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.cowboy, (ItemStack)stack) == 0 && !(this instanceof ShotgunItem)) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.twohands"));
                }
                if (inaccuracy == 0.0 && !(this instanceof ShotgunItem) && !(this instanceof GatlingItem)) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.sniper"));
                }
                if (this.isGravity) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.gravity"));
                }
            }
            this.addExtraStatsTooltip(stack, world, tooltip);
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.shift"));
        }
    }

    protected void addExtraStatsTooltip(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip) {
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77619_b() {
        return this.enchantability;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.repairMaterial != null && this.repairMaterial.get().test(repair) || super.func_82789_a(toRepair, repair);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.func_185132_d((ItemStack)oldStack, (ItemStack)newStack);
    }

    public int func_77626_a(ItemStack pStack) {
        return Math.max(this.getFireDelay(pStack, null), 1);
    }
}

