/*
 * Decompiled with CFR 0.152.
 */
package xyz.kaleidiodev.kaleidiosguns.item;

import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import xyz.kaleidiodev.kaleidiosguns.config.KGConfig;
import xyz.kaleidiodev.kaleidiosguns.entity.BulletEntity;
import xyz.kaleidiodev.kaleidiosguns.item.GunItem;
import xyz.kaleidiodev.kaleidiosguns.registry.ModEnchantments;

public interface IBullet {
    public BulletEntity createProjectile(World var1, ItemStack var2, LivingEntity var3, boolean var4);

    public void consume(ItemStack var1, PlayerEntity var2, ItemStack var3);

    default public int costToUse(ItemStack stack) {
        if (stack.func_77973_b() instanceof GunItem) {
            return ((GunItem)stack.func_77973_b()).getCost(stack);
        }
        return 1;
    }

    default public void onLivingEntityHit(BulletEntity projectile, LivingEntity target, @Nullable Entity shooter, World world) {
        if (projectile.rollRewardChance()) {
            float damageDelta = projectile.getPreviousHealthOfVictim() - target.func_110143_aJ();
            LivingEntity shooterEntity = (LivingEntity)shooter;
            if (shooterEntity != null && shooterEntity.func_70089_S()) {
                shooterEntity.func_70691_i(damageDelta * (float)((Double)KGConfig.passionForBloodHealIncrease.get()).doubleValue());
            }
        }
    }

    default public double modifyDamage(double damage, BulletEntity projectile, Entity target, @Nullable Entity shooter, World world) {
        LivingEntity livingTarget;
        double newDamage = damage;
        if (projectile.isPlasma && target instanceof LivingEntity) {
            PlayerEntity victim;
            livingTarget = (LivingEntity)target;
            if (target instanceof PlayerEntity && (victim = (PlayerEntity)target).func_184607_cu().isShield((LivingEntity)victim) && Math.random() < (Double)KGConfig.goldPlasmaShieldAdditional.get()) {
                victim.func_184811_cZ().func_185145_a(victim.func_184607_cu().func_77973_b(), 100);
                victim.func_184602_cy();
                world.func_184148_a(null, victim.func_226277_ct_(), victim.func_226278_cu_(), victim.func_226281_cx_(), SoundEvents.field_187769_eM, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            if (Math.random() < (Double)KGConfig.goldPlasmaSlowChance.get()) {
                livingTarget.func_195064_c(new EffectInstance(Effects.field_76421_d, ((Integer)KGConfig.goldPlasmaSlowTicks.get()).intValue(), 2));
            }
        }
        if (projectile.shouldSlow && target instanceof LivingEntity && Math.random() < (Double)KGConfig.diamondAssaultSlowChance.get()) {
            ((LivingEntity)target).func_195064_c(new EffectInstance(Effects.field_76419_f, ((Integer)KGConfig.diamondAssaultSlowTicks.get()).intValue(), 2));
        }
        if (projectile.shouldFlinch && target instanceof LivingEntity) {
            livingTarget = (LivingEntity)target;
            livingTarget.func_195064_c(new EffectInstance(Effects.field_76437_t, ((Integer)KGConfig.goldShowmanFlinchTicks.get()).intValue(), ((Integer)KGConfig.goldShowmanFlinchEffect.get()).intValue()));
        }
        if (projectile.wasRevenge) {
            newDamage *= ((Double)KGConfig.emeraldBlessedBlessingMultiplier.get()).doubleValue();
        }
        if (projectile.headshotHistory.contains(target)) {
            LivingEntity livingTarget2;
            ItemStack helmet;
            double actualHeadshot = (Double)KGConfig.headshotMultiplierMaximum.get();
            if (target instanceof LivingEntity && (helmet = (livingTarget2 = (LivingEntity)target).func_184582_a(EquipmentSlotType.HEAD)) != ItemStack.field_190927_a) {
                int projectileProtectionLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180308_g, (ItemStack)helmet);
                double headshotTemp = (Double)KGConfig.headshotMultiplierMaximum.get() - (Double)KGConfig.headshotMultiplierMinimum.get();
                actualHeadshot = (Double)KGConfig.headshotMultiplierMinimum.get() + (headshotTemp *= 1.0 / (1.0 + (double)projectileProtectionLevel * (Double)KGConfig.projectileProtectionHelmetHeadshotReduction.get()));
            }
            newDamage *= actualHeadshot;
        }
        if (projectile.wasDark) {
            newDamage /= projectile.getShootingGun().getDamageMultiplier(new ItemStack((IItemProvider)projectile.getShootingGun().getItem()));
            newDamage *= projectile.getShootingGun().getDamageMultiplier(new ItemStack((IItemProvider)projectile.getShootingGun().getItem())) + (Double)KGConfig.shadowRevolverShadowAdditionalMultiplier.get();
        }
        if ((projectile.lavaMode & 4) != 0 && (projectile.lavaMode & 8) != 0) {
            newDamage *= ((Double)KGConfig.lavaSmgLavaMultiplier.get()).doubleValue();
        }
        if (projectile.isMeleeBonus) {
            newDamage *= ((Double)KGConfig.emeraldMusketPostMeleeMultiplier.get()).doubleValue();
        }
        if (projectile.redstoneLevel > 0) {
            double multiplierDelta = (Double)KGConfig.ironVoltgunMaximumDamage.get() - (Double)KGConfig.ironVoltgunMinimumDamage.get();
            int maximumBlocks = (int)(((double)EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.signalBoost, (ItemStack)new ItemStack((IItemProvider)projectile.getShootingGun().getItem())) * (Double)KGConfig.signalMultiplier.get() + 1.0) * (double)((Integer)KGConfig.redstoneRadius.get()).intValue());
            double multiplierPerBlock = multiplierDelta / (double)maximumBlocks;
            newDamage *= (double)(maximumBlocks - projectile.redstoneLevel) * multiplierPerBlock + (Double)KGConfig.ironVoltgunMinimumDamage.get();
        }
        if (projectile.func_225510_bt_() && !projectile.clip) {
            newDamage /= ((Double)KGConfig.glowDamageDivider.get()).doubleValue();
        }
        return newDamage;
    }
}

