/*
 * Decompiled with CFR 0.152.
 */
package xyz.kaleidiodev.kaleidiosguns.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import xyz.kaleidiodev.kaleidiosguns.config.KGConfig;
import xyz.kaleidiodev.kaleidiosguns.entity.BulletEntity;
import xyz.kaleidiodev.kaleidiosguns.item.GunItem;
import xyz.kaleidiodev.kaleidiosguns.item.IBullet;
import xyz.kaleidiodev.kaleidiosguns.registry.ModEnchantments;

public class ShotgunItem
extends GunItem {
    private final int bulletCount;
    protected boolean isVampire;
    private int vampireCount;
    private int currentShot;
    private boolean isWave;
    private boolean isSpread;

    public ShotgunItem(Item.Properties properties, int bonusDamage, double damageMultiplier, int fireDelay, double inaccuracy, int enchantability, int bulletCount, double attackSpeed, double attackDamage) {
        super(properties, bonusDamage, damageMultiplier, fireDelay, inaccuracy, enchantability, attackSpeed, attackDamage);
        this.bulletCount = bulletCount;
    }

    @Override
    protected void fireWeapon(World world, PlayerEntity player, ItemStack gun, ItemStack ammo, IBullet bulletItem, boolean bulletFree) {
        this.vampireBulletCount(player);
        int i = 0;
        while (i < this.getBulletCount(gun, player)) {
            this.currentShot = i++;
            super.fireWeapon(world, player, gun, ammo, bulletItem, bulletFree);
        }
    }

    @Override
    protected void addExtraStatsTooltip(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.shotgun.shots" + (this.isProjectileCountModified(stack) ? ".modified" : ""), new Object[]{this.getBulletCount(stack, null)}));
        if (this.isVampire) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.vampire_shotgun"));
        }
        if (this.isWave) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.wave"));
        }
        if (this.isSpread) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.kaleidiosguns.spread"));
        }
    }

    @Override
    public void shootShot(BulletEntity shot, PlayerEntity player, ItemStack gun, double nextInaccuracy) {
        super.shootShot(shot, player, gun, nextInaccuracy);
    }

    @Override
    public double getProjectileSpeed(ItemStack stack, @Nullable PlayerEntity player) {
        if (this.isSpread) {
            return super.baseSpeed(stack, null) * ((Double)KGConfig.blunderbussMinimumSpeed.get() + Math.random() * ((Double)KGConfig.blunderbussMaximumSpeed.get() - (Double)KGConfig.blunderbussMinimumSpeed.get()));
        }
        return super.baseSpeed(stack, null);
    }

    protected int getBulletCount(ItemStack stack, @Nullable PlayerEntity player) {
        int divisionFactor = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.division, (ItemStack)stack) * (Integer)KGConfig.divisionCountIncrease.get();
        return this.getBaseBulletCount() + divisionFactor;
    }

    @Override
    public double getInaccuracy(ItemStack stack, @Nullable PlayerEntity player) {
        if (this.isWave) {
            return 0.0;
        }
        return super.getInaccuracy(stack, player);
    }

    protected void vampireBulletCount(@Nullable PlayerEntity player) {
        int entityCount = 0;
        this.vampireCount = 0;
        if (this.isVampire && player != null) {
            List victims = player.field_70170_p.func_217357_a(Entity.class, AxisAlignedBB.func_241550_g_((double)((Double)KGConfig.netheriteShotgunEntityRadius.get() * 2.0), (double)((Double)KGConfig.netheriteShotgunEntityRadius.get() * 2.0), (double)((Double)KGConfig.netheriteShotgunEntityRadius.get() * 2.0)).func_191194_a(player.func_213303_ch()));
            for (Entity mob : victims) {
                LivingEntity creature;
                if (!(mob instanceof LivingEntity) || (creature = (LivingEntity)mob).func_110124_au() == player.func_110124_au() || entityCount >= (Integer)KGConfig.netheriteShotgunEntityCap.get() || this.checkIsSameTeam((Entity)player, mob)) continue;
                creature.func_70097_a((DamageSource)new EntityDamageSource("magic", (Entity)player), (float)((Double)KGConfig.netheriteShotgunEntityHurt.get()).doubleValue());
                this.vampireCount += ((Integer)KGConfig.netheriteShotgunBulletsPerEntity.get()).intValue();
                ++entityCount;
            }
        }
    }

    protected boolean checkIsSameTeam(Entity player, Entity victim) {
        if (victim instanceof TameableEntity) {
            return ((TameableEntity)victim).func_70902_q() == player;
        }
        if (player.func_96124_cp() == null && victim.func_96124_cp() == null) {
            return false;
        }
        return player.func_96124_cp() == victim.func_96124_cp() && !player.func_96124_cp().func_96665_g();
    }

    protected boolean isProjectileCountModified(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.division, (ItemStack)stack) >= 1;
    }

    public int getBaseBulletCount() {
        return this.bulletCount + this.vampireCount;
    }

    public ShotgunItem setIsVampire(boolean vampire) {
        this.isVampire = vampire;
        return this;
    }

    public ShotgunItem setIsWave(boolean wave) {
        this.isWave = wave;
        return this;
    }

    public ShotgunItem setIsSpread(boolean spread) {
        this.isSpread = spread;
        return this;
    }
}

