/*
 * Decompiled with CFR 0.152.
 */
package xyz.kaleidiodev.kaleidiosguns.network;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.network.INetHandler;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.kaleidiodev.kaleidiosguns.entity.BulletEntity;

public class ClientPacketHandler {
    @SubscribeEvent
    public void onClientPayload(NetworkEvent.ServerCustomPayloadEvent event) {
        if (event instanceof NetworkEvent.ServerCustomPayloadLoginEvent) {
            return;
        }
        PacketBuffer buffer = event.getPayload();
        NetworkEvent.Context ctx = (NetworkEvent.Context)event.getSource().get();
        INetHandler netHandler = ctx.getNetworkManager().func_150729_e();
        ctx.setPacketHandled(true);
        if (netHandler instanceof ClientPlayNetHandler) {
            ClientPlayNetHandler cnh = (ClientPlayNetHandler)netHandler;
            ctx.enqueueWork(() -> this.handlePacket(buffer, Minecraft.func_71410_x(), cnh));
        }
    }

    private void handlePacket(PacketBuffer buffer, Minecraft minecraft, ClientPlayNetHandler netHandler) {
        int packet = buffer.readInt();
        if (packet == 10) {
            this.entitySpawnPacket(buffer, minecraft);
        } else if (packet == 11) {
            this.entityVelocityPacket(buffer, minecraft);
        }
    }

    private void entitySpawnPacket(PacketBuffer packet, Minecraft mc) {
        if (mc.field_71441_e == null) {
            return;
        }
        EntityType type = (EntityType)Registry.field_212629_r.func_148745_a(packet.func_150792_a());
        int entityID = packet.readInt();
        UUID uuid = packet.func_179253_g();
        double posX = packet.readDouble();
        double posY = packet.readDouble();
        double posZ = packet.readDouble();
        byte yaw = packet.readByte();
        byte pitch = packet.readByte();
        byte headYaw = packet.readByte();
        boolean noGravity = packet.readBoolean();
        Vector3d velocity = new Vector3d((double)packet.readFloat(), (double)packet.readFloat(), (double)packet.readFloat());
        Entity entity = type.func_200721_a((World)mc.field_71441_e);
        if (entity == null) {
            return;
        }
        entity.func_213312_b(posX, posY, posZ);
        entity.func_70080_a(posX, posY, posZ, (float)(pitch * 360) / 256.0f, (float)(yaw * 360) / 256.0f);
        entity.func_70034_d((float)(headYaw * 360) / 256.0f);
        entity.func_181013_g((float)(headYaw * 360) / 256.0f);
        entity.func_145769_d(entityID);
        entity.func_184221_a(uuid);
        entity.func_189654_d(noGravity);
        BulletEntity bullet = (BulletEntity)entity;
        bullet.isExplosive = packet.readBoolean();
        bullet.isPlasma = packet.readBoolean();
        bullet.wasRevenge = packet.readBoolean();
        bullet.wasDark = packet.readBoolean();
        bullet.isTorpedo = packet.readBoolean();
        bullet.isMeleeBonus = packet.readBoolean();
        bullet.lavaMode = packet.readByte();
        bullet.clip = packet.readBoolean();
        bullet.hero = packet.readBoolean();
        bullet.hitEntity = packet.readBoolean();
        bullet.hitBlock = packet.readBoolean();
        bullet.lastPos = new Vector3d(packet.readDouble(), packet.readDouble(), packet.readDouble());
        bullet.setOrigin(new Vector3d(packet.readDouble(), packet.readDouble(), packet.readDouble()));
        mc.field_71441_e.func_217411_a(entityID, (Entity)bullet);
        entity.func_70016_h(velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
    }

    private void entityVelocityPacket(PacketBuffer packet, Minecraft mc) {
        if (mc.field_71441_e == null) {
            return;
        }
        int entityID = packet.readInt();
        Entity entity = mc.field_71441_e.func_73045_a(entityID);
        if (entity != null) {
            Vector3f motion = new Vector3f(packet.readFloat(), packet.readFloat(), packet.readFloat());
            entity.func_70016_h((double)motion.func_195899_a(), (double)motion.func_195900_b(), (double)motion.func_195902_c());
            if (packet.readBoolean()) {
                entity.field_70125_A = packet.readFloat();
                entity.field_70177_z = packet.readFloat();
                entity.func_230245_c_(packet.readBoolean());
            }
        }
    }
}

