/*
 * Decompiled with CFR 0.152.
 */
package net.yonchi.refm.gameasset;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.common.util.ForgeSoundType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RapierSounds {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"refm");
    public static final RegistryObject<SoundEvent> RAPIER_HIT = RapierSounds.registerRapierSound("entity.weapon.rapier_hit");
    public static final RegistryObject<SoundEvent> RAPIER_SWING = RapierSounds.registerRapierSound("entity.weapon.rapier_swing");
    public static final RegistryObject<SoundEvent> RAPIER_STAB = RapierSounds.registerRapierSound("entity.weapon.rapier_stab");
    public static final RegistryObject<SoundEvent> RAPIER_JUMP = RapierSounds.registerRapierSound("entity.weapon.rapier_jump");
    public static final RegistryObject<SoundEvent> RAPIER_SKILL = RapierSounds.registerRapierSound("entity.weapon.rapier_skill");
    public static final ForgeSoundType SOUND_RAPIER_SOUNDS = new ForgeSoundType(1.0f, 1.0f, RAPIER_HIT, RAPIER_SWING, RAPIER_STAB, RAPIER_JUMP, RAPIER_SKILL);

    private static RegistryObject<SoundEvent> registerRapierSound(String name) {
        LOGGER.debug("Registering rapier sound: " + name);
        return SOUNDS.register(name, () -> {
            LOGGER.debug("Creating SoundEvent for: " + name);
            return SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("refm", name));
        });
    }

    public static void register(IEventBus eventBus) {
        LOGGER.debug("Registering sounds to event bus");
        SOUNDS.register(eventBus);
    }
}

