/*
 * Decompiled with CFR 0.152.
 */
package net.yonchi.refm.world.capabilities.item;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.yonchi.refm.gameasset.RapierAnimations;
import net.yonchi.refm.gameasset.RapierColliderPreset;
import net.yonchi.refm.gameasset.RapierSkills;
import net.yonchi.refm.gameasset.RapierSounds;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.forgeevent.WeaponCapabilityPresetRegistryEvent;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCapability;
import yesman.epicfight.world.capabilities.item.WeaponCategory;

@Mod.EventBusSubscriber(modid="refm", bus=Mod.EventBusSubscriber.Bus.MOD)
public class WeaponCapabilityPresets {
    public static final Function<Item, CapabilityItem.Builder> RAPIER = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category((WeaponCategory)CapabilityItem.WeaponCategories.SWORD).styleProvider(playerpatch -> CapabilityItem.Styles.ONE_HAND).collider(RapierColliderPreset.RAPIER).swingSound((SoundEvent)RapierSounds.RAPIER_STAB.get()).hitSound((SoundEvent)RapierSounds.RAPIER_HIT.get()).canBePlacedOffhand(false).newStyleCombo((Style)CapabilityItem.Styles.ONE_HAND, new StaticAnimation[]{RapierAnimations.RAPIER_AUTO1, RapierAnimations.RAPIER_AUTO2, RapierAnimations.RAPIER_AUTO3, RapierAnimations.RAPIER_DASH, RapierAnimations.RAPIER_AIR_SLASH}).innateSkill((Style)CapabilityItem.Styles.ONE_HAND, itemstack -> RapierSkills.DEADLYBACKFLIP).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.IDLE, RapierAnimations.BIPED_HOLD_RAPIER).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.WALK, RapierAnimations.BIPED_WALK_RAPIER).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.CHASE, RapierAnimations.BIPED_WALK_RAPIER).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.RUN, RapierAnimations.BIPED_RUN_RAPIER).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.JUMP, RapierAnimations.BIPED_HOLD_RAPIER).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.KNEEL, RapierAnimations.BIPED_SNEAK_RAPIER).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.SNEAK, RapierAnimations.BIPED_SNEAK_RAPIER).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.SWIM, RapierAnimations.BIPED_HOLD_RAPIER).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.BLOCK, RapierAnimations.RAPIER_GUARD);
        return builder;
    };
    private static final Map<String, Function<Item, CapabilityItem.Builder>> PRESETS = Maps.newHashMap();

    private static boolean CheckPlayer(LivingEntityPatch<?> playerPatch) {
        return ((LivingEntity)playerPatch.getOriginal()).m_6095_() != EntityType.f_20532_;
    }

    @SubscribeEvent
    public static void register(WeaponCapabilityPresetRegistryEvent event) {
        event.getTypeEntry().put(new ResourceLocation("refm", "rapier"), RAPIER);
    }
}

