/*
 * Decompiled with CFR 0.152.
 */
package li.cil.manual.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import li.cil.manual.api.ManualModel;
import li.cil.manual.api.ManualScreenStyle;
import li.cil.manual.api.ManualStyle;
import li.cil.manual.api.Tab;
import li.cil.manual.api.content.Document;
import li.cil.manual.client.document.DocumentRenderer;
import li.cil.manual.client.document.segment.InteractiveSegment;
import li.cil.manual.client.util.IterableUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.joml.Vector2i;

public final class ManualScreen
extends Screen {
    private final ManualModel model;
    private final ManualStyle manualStyle;
    private final ManualScreenStyle screenStyle;
    private final DocumentRenderer documentRenderer;
    private String currentPath;
    private int leftPos = 0;
    private int topPos = 0;
    private float scrollPos = 0.0f;
    private boolean isDraggingScrollButton = false;
    private int documentHeight = 0;
    private Optional<InteractiveSegment> currentSegment = Optional.empty();
    private ScrollButton scrollButton = null;

    public ManualScreen(ManualModel model, ManualStyle manualStyle, ManualScreenStyle screenStyle) {
        super((Component)Component.m_237113_((String)"Manual"));
        this.model = model;
        this.manualStyle = manualStyle;
        this.screenStyle = screenStyle;
        this.documentRenderer = new DocumentRenderer(model, manualStyle);
    }

    public void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.screenStyle.getWindowRect().m_110090_()) / 2 + this.screenStyle.getWindowRect().m_110085_();
        this.topPos = (this.f_96544_ - this.screenStyle.getWindowRect().m_110091_()) / 2 + this.screenStyle.getWindowRect().m_110086_();
        IterableUtils.forEachWithIndex(this.model.getTabs(), (i, tab) -> {
            int x = this.screenStyle.getTabAreaRect().m_110085_();
            int y = this.screenStyle.getTabAreaRect().m_110086_() + i * this.getTabClickableHeight();
            if (y + this.screenStyle.getTabRect().m_110091_() > this.screenStyle.getTabAreaRect().m_110091_()) {
                return;
            }
            this.m_142416_((GuiEventListener)new TabButton(this.leftPos + x, this.topPos + y, (Tab)tab, button -> this.pushManualPage((Tab)tab)));
        });
        this.scrollButton = (ScrollButton)this.m_7787_((GuiEventListener)new ScrollButton(this.leftPos + this.screenStyle.getScrollBarRect().m_110085_() + this.screenStyle.getScrollButtonRect().m_110085_(), this.topPos + this.screenStyle.getScrollBarRect().m_110086_() + this.screenStyle.getScrollButtonRect().m_110086_(), this.screenStyle.getScrollButtonRect().m_110090_(), this.screenStyle.getScrollButtonRect().m_110091_()));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        if (!Objects.equals(this.currentPath, this.model.peek())) {
            this.refreshPage();
            this.currentPath = this.model.peek();
            SoundManager soundHandler = Minecraft.m_91087_().m_91106_();
            soundHandler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)this.manualStyle.getPageChangeSound(), (float)1.0f));
        }
        this.scrollPos = Mth.m_14179_((float)(partialTicks * 0.5f), (float)this.scrollPos, (float)this.getScrollPosition());
        RenderSystem.enableBlend();
        this.scrollButton.f_93623_ = false;
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        Rect2i windowRect = this.screenStyle.getWindowRect();
        graphics.m_280163_(this.screenStyle.getWindowBackground(), this.leftPos, this.topPos, 0.0f, 0.0f, windowRect.m_110090_(), windowRect.m_110091_(), windowRect.m_110090_(), windowRect.m_110091_());
        this.renderScrollbarTooltip(mouseX, mouseY);
        this.scrollButton.f_93623_ = this.canScroll();
        this.scrollButton.m_88315_(graphics, mouseX, mouseY, partialTicks);
        Rect2i documentRect = this.screenStyle.getDocumentRect();
        int documentX = this.leftPos + documentRect.m_110085_();
        int documentY = this.topPos + documentRect.m_110086_();
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_((float)documentX, (float)documentY, 0.0f);
        this.currentSegment = this.documentRenderer.render(graphics, this.getSmoothScrollPosition(), documentRect.m_110090_(), documentRect.m_110091_(), mouseX - documentX, mouseY - documentY);
        pose.m_85849_();
        this.currentSegment.flatMap(InteractiveSegment::getTooltip).ifPresent(t -> graphics.m_280666_(this.f_96547_, Collections.singletonList(t), mouseX, mouseY));
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (super.m_6050_(mouseX, mouseY, delta)) {
            return true;
        }
        this.scrollBy(delta);
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        Minecraft mc = Objects.requireNonNull(this.f_96541_);
        if (mc.f_91066_.f_92089_.m_90832_(keyCode, scanCode)) {
            this.popManualPage();
            return true;
        }
        if (mc.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            LocalPlayer player = mc.f_91074_;
            if (player != null) {
                player.m_6915_();
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.canScroll() && button == 0 && this.isCoordinateOverScrollBar(mouseX, mouseY)) {
            this.isDraggingScrollButton = true;
            this.scrollButton.m_7435_(Minecraft.m_91087_().m_91106_());
            this.scrollTo(mouseY);
            return true;
        }
        if (button == 0) {
            return this.currentSegment.map(InteractiveSegment::mouseClicked).orElse(false);
        }
        if (button == 1) {
            this.popManualPage();
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (super.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (this.isDraggingScrollButton) {
            this.scrollTo(mouseY);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        super.m_6348_(mouseX, mouseY, button);
        if (button == 0) {
            this.isDraggingScrollButton = false;
        }
        return true;
    }

    public boolean m_7043_() {
        return false;
    }

    private void renderScrollbarTooltip(int mouseX, int mouseY) {
        if (this.isCoordinateOverScrollBar(mouseX, mouseY)) {
            this.scrollButton.applyTooltip(false);
        }
    }

    private void pushManualPage(Tab tab) {
        this.model.push(tab.getPath());
    }

    private void popManualPage() {
        if (!this.model.pop()) {
            this.m_7379_();
        }
    }

    private boolean canScroll() {
        return this.maxScrollPosition() > 0;
    }

    private int getScrollPosition() {
        return this.model.getUserData(ScrollOffset.class).map(offset -> offset.value).orElse(0);
    }

    private void setScrollPosition(int value) {
        this.model.setUserData(new ScrollOffset(value));
    }

    private int maxScrollPosition() {
        return Math.max(0, this.documentHeight - this.screenStyle.getDocumentRect().m_110091_());
    }

    private void refreshPage() {
        Optional<Document> document = this.model.documentFor(this.model.peek());
        this.documentRenderer.parse(document.orElse(new Document(Collections.singletonList("Page not found: " + this.model.peek()))));
        this.documentHeight = this.documentRenderer.height(this.screenStyle.getDocumentRect().m_110090_());
        this.scrollPos = this.getScrollPosition() - this.manualStyle.getLineHeight() * 3;
    }

    private void scrollTo(double mouseY) {
        int scrollButtonHeight = this.screenStyle.getScrollButtonRect().m_110091_();
        int halfScrollButtonHeight = (int)Math.ceil((double)scrollButtonHeight * 0.5);
        int scrollMinY = this.topPos + this.screenStyle.getScrollBarRect().m_110086_() + halfScrollButtonHeight;
        int scrollHeight = this.screenStyle.getScrollBarRect().m_110091_() - scrollButtonHeight;
        int localMouseY = (int)(mouseY - (double)scrollMinY);
        this.scrollTo(this.maxScrollPosition() * localMouseY / scrollHeight, true);
    }

    private void scrollBy(double amount) {
        this.scrollTo(this.getScrollPosition() - (int)Math.round((double)(this.manualStyle.getLineHeight() * 3) * amount), false);
    }

    private void scrollTo(int y, boolean immediate) {
        this.setScrollPosition(Math.max(0, Math.min(this.maxScrollPosition(), y)));
        if (immediate) {
            this.scrollPos = this.getScrollPosition();
        }
    }

    private int getSmoothScrollPosition() {
        if (this.scrollPos < (float)this.getScrollPosition()) {
            return (int)Math.ceil(this.scrollPos);
        }
        return (int)Math.floor(this.scrollPos);
    }

    private int getScrollButtonY() {
        if (this.canScroll()) {
            int yMax = this.screenStyle.getScrollBarRect().m_110091_() - this.screenStyle.getScrollButtonRect().m_110091_();
            return Math.max(0, Math.min(yMax, yMax * this.getSmoothScrollPosition() / this.maxScrollPosition()));
        }
        return 0;
    }

    private boolean isCoordinateOverScrollBar(double x, double y) {
        return this.screenStyle.getScrollBarRect().m_110087_((int)(x - (double)this.leftPos), (int)(y - (double)this.topPos));
    }

    private int getTabClickableHeight() {
        return this.screenStyle.getTabRect().m_110091_() - this.screenStyle.getTabOverlap();
    }

    private class ScrollButton
    extends Button {
        private static final int TOOLTIP_HEIGHT = 18;
        private final int baseY;

        ScrollButton(int x, int y, int w, int h) {
            super(x, y, w, h, (Component)Component.m_237119_(), button -> {}, f_252438_);
            this.baseY = y;
        }

        protected boolean m_93680_(double mouseX, double mouseY) {
            if (super.m_93680_(mouseX, mouseY)) {
                this.m_7435_(Minecraft.m_91087_().m_91106_());
            }
            return false;
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            this.m_253211_(this.baseY + ManualScreen.this.getScrollButtonY());
            int vOffset = ManualScreen.this.isDraggingScrollButton || this.isHoveredOrFocusedUsingKeyboard() ? this.f_93619_ : 0;
            graphics.m_280163_(ManualScreen.this.screenStyle.getScrollButtonTexture(), this.m_252754_(), this.m_252907_(), 0.0f, (float)vOffset, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_ * 2);
            this.updateTooltip();
        }

        public void applyTooltip(boolean fixedY) {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen != null && ManualScreen.this.canScroll()) {
                screen.m_262861_(this.getTooltipContent(), this.getClientTooltipPositioner(fixedY), true);
            }
        }

        private void updateTooltip() {
            if (!this.isHoveredOrFocusedUsingKeyboard() && !ManualScreen.this.isDraggingScrollButton) {
                return;
            }
            this.applyTooltip(true);
        }

        private List<FormattedCharSequence> getTooltipContent() {
            return List.of(Component.m_237113_((String)(100 * ManualScreen.this.getScrollPosition() / ManualScreen.this.maxScrollPosition() + "%")).m_7532_());
        }

        private ClientTooltipPositioner getClientTooltipPositioner(boolean fixedY) {
            return (screenWidth, screenHeight, mouseX, mouseY, tooltipWidth, tooltipHeight) -> new Vector2i(ManualScreen.this.leftPos + ManualScreen.this.screenStyle.getScrollBarRect().m_110085_() + ManualScreen.this.screenStyle.getScrollBarRect().m_110090_(), fixedY ? this.m_252907_() + (this.m_93694_() + 18) / 2 : mouseY);
        }

        private boolean isHoveredOrFocusedUsingKeyboard() {
            return this.m_274382_() || this.m_93696_() && Minecraft.m_91087_().m_264529_().m_264505_();
        }
    }

    private record ScrollOffset(int value) {
    }

    private class TabButton
    extends Button {
        private final Tab tab;
        private final int baseX;
        private float currentX;
        private int targetX;

        TabButton(int x, int y, Tab tab, Button.OnPress action) {
            super(x, y, ManualScreen.this.screenStyle.getTabRect().m_110090_(), ManualScreen.this.getTabClickableHeight(), (Component)Component.m_237119_(), action, f_252438_);
            this.tab = tab;
            this.baseX = x;
            this.currentX = x + ManualScreen.this.screenStyle.getTabHoverShift();
            this.targetX = (int)this.currentX;
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            this.targetX = this.isHoveredOrFocusedUsingKeyboard() ? this.baseX : this.baseX + ManualScreen.this.screenStyle.getTabHoverShift();
            this.currentX = Mth.m_14179_((float)(partialTicks * 0.5f), (float)this.currentX, (float)this.targetX);
            if (this.currentX < (float)this.targetX) {
                this.m_252865_((int)Math.ceil(this.currentX));
            } else {
                this.m_252865_((int)Math.floor(this.currentX));
            }
            this.f_93618_ = ManualScreen.this.screenStyle.getTabAreaRect().m_110090_() - (this.m_252754_() - this.baseX);
            int v0 = this.isHoveredOrFocusedUsingKeyboard() ? ManualScreen.this.screenStyle.getTabRect().m_110091_() : 0;
            int visualWidth = ManualScreen.this.screenStyle.getTabRect().m_110090_();
            int visualHeight = ManualScreen.this.screenStyle.getTabRect().m_110091_();
            int textureWidth = ManualScreen.this.screenStyle.getTabRect().m_110090_();
            int textureHeight = ManualScreen.this.screenStyle.getTabRect().m_110091_() * 2;
            graphics.m_280163_(ManualScreen.this.screenStyle.getTabButtonTexture(), this.m_252754_(), this.m_252907_(), 0.0f, (float)v0, visualWidth, visualHeight, textureWidth, textureHeight);
            PoseStack pose = graphics.m_280168_();
            pose.m_85836_();
            pose.m_252880_((float)(this.m_252754_() + 12), (float)(this.m_252907_() + (ManualScreen.this.screenStyle.getTabRect().m_110091_() - 18) / 2), 0.0f);
            this.tab.renderIcon(graphics);
            pose.m_85849_();
            this.updateTooltip();
        }

        private void updateTooltip() {
            if (!this.isHoveredOrFocusedUsingKeyboard() || ManualScreen.this.isDraggingScrollButton) {
                return;
            }
            ArrayList<Component> tooltip = new ArrayList<Component>();
            this.tab.getTooltip(tooltip);
            if (tooltip.isEmpty()) {
                return;
            }
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen != null) {
                screen.m_257959_(tooltip.stream().map(Component::m_7532_).toList());
            }
        }

        public void m_7435_(SoundManager soundHandler) {
        }

        private boolean isHoveredOrFocusedUsingKeyboard() {
            return this.m_274382_() || this.m_93696_() && Minecraft.m_91087_().m_264529_().m_264505_();
        }
    }
}

