/*
 * Decompiled with CFR 0.152.
 */
package li.cil.ceres;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import li.cil.ceres.api.SerializationException;
import li.cil.ceres.api.Serializer;
import li.cil.ceres.internal.SerializerFactory;
import li.cil.ceres.serializers.ArraySerializer;
import li.cil.ceres.serializers.ByteBufferSerializer;
import li.cil.ceres.serializers.UUIDSerializer;

public final class Ceres {
    private static final Map<Class<?>, Serializer<?>> SERIALIZERS = new HashMap();
    private static boolean isInitialized = false;

    public static void initialize() {
        if (isInitialized) {
            return;
        }
        isInitialized = true;
        Ceres.putSerializer(ByteBuffer.class, new ByteBufferSerializer());
        Ceres.putSerializer(UUID.class, new UUIDSerializer());
    }

    public static <T> Serializer<T> getSerializer(Class<T> type) throws SerializationException {
        return Ceres.getSerializer(type, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <T> Serializer<T> getSerializer(Class<T> type, boolean generateMissing) throws SerializationException {
        Map<Class<?>, Serializer<?>> map = SERIALIZERS;
        synchronized (map) {
            if (SERIALIZERS.containsKey(type)) {
                return SERIALIZERS.get(type);
            }
            if (type.isArray()) {
                return ArraySerializer.INSTANCE;
            }
            if (generateMissing) {
                Serializer<T> serializer = SerializerFactory.generateSerializer(type);
                SERIALIZERS.put(type, serializer);
                return serializer;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void putSerializer(Class<T> type, @Nullable Serializer<T> serializer) {
        Map<Class<?>, Serializer<?>> map = SERIALIZERS;
        synchronized (map) {
            if (serializer != null) {
                SERIALIZERS.put(type, serializer);
            } else {
                SERIALIZERS.remove(type);
            }
        }
    }

    static {
        Ceres.initialize();
    }
}

