/*
 * Decompiled with CFR 0.152.
 */
package li.cil.ceres.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import javax.annotation.Nullable;
import li.cil.ceres.Ceres;
import li.cil.ceres.api.DeserializationVisitor;
import li.cil.ceres.api.SerializationException;
import li.cil.ceres.api.SerializationVisitor;
import li.cil.ceres.api.Serializer;
import li.cil.ceres.internal.GeneratedSerializer;
import li.cil.ceres.internal.SerializerUtils;

final class ReflectionSerializer
implements Serializer,
GeneratedSerializer {
    private final ArrayList<Field> fields;

    public static <T> Serializer<T> generateSerializer(Class<T> type) throws SerializationException {
        if (type.isInterface()) {
            throw new SerializationException(String.format("Cannot generate serializer for interface [%s].", type));
        }
        ArrayList<Field> fields = SerializerUtils.collectSerializableFields(type);
        for (Field field : fields) {
            field.setAccessible(true);
        }
        return new ReflectionSerializer(fields);
    }

    private ReflectionSerializer(ArrayList<Field> fields) {
        this.fields = fields;
    }

    @Override
    public boolean hasSerializedFields() {
        return !this.fields.isEmpty();
    }

    public void serialize(SerializationVisitor visitor, Class type, Object value) throws SerializationException {
        for (Field field : this.fields) {
            try {
                Serializer<?> serializer;
                Class<?> fieldType = field.getType();
                if (fieldType == Boolean.TYPE) {
                    visitor.putBoolean(field.getName(), field.getBoolean(value));
                    continue;
                }
                if (fieldType == Byte.TYPE) {
                    visitor.putByte(field.getName(), field.getByte(value));
                    continue;
                }
                if (fieldType == Character.TYPE) {
                    visitor.putChar(field.getName(), field.getChar(value));
                    continue;
                }
                if (fieldType == Short.TYPE) {
                    visitor.putShort(field.getName(), field.getShort(value));
                    continue;
                }
                if (fieldType == Integer.TYPE) {
                    visitor.putInt(field.getName(), field.getInt(value));
                    continue;
                }
                if (fieldType == Long.TYPE) {
                    visitor.putLong(field.getName(), field.getLong(value));
                    continue;
                }
                if (fieldType == Float.TYPE) {
                    visitor.putFloat(field.getName(), field.getFloat(value));
                    continue;
                }
                if (fieldType == Double.TYPE) {
                    visitor.putDouble(field.getName(), field.getDouble(value));
                    continue;
                }
                Object fieldValue = field.get(value);
                if (fieldValue != null && fieldValue.getClass() != fieldType && ((serializer = Ceres.getSerializer(fieldType, false)) == null || serializer instanceof GeneratedSerializer)) {
                    throw new SerializationException(String.format("Value type [%s] does not match field type in field [%s.%s] and no explicit serializer has been registered for field type [%s]. Polymorphism is not supported when using generated serializers.", value.getClass().getName(), type.getName(), field.getName(), fieldType.getName()));
                }
                visitor.putObject(field.getName(), fieldType, fieldValue);
            }
            catch (Throwable e) {
                throw new SerializationException(String.format("Failed serializing field [%s.%s]", type.getName(), field.getName()), e);
            }
        }
        Class parentType = type.getSuperclass();
        if (parentType != null && parentType != Object.class) {
            visitor.putObject("<super>", parentType, value);
        }
    }

    public Object deserialize(DeserializationVisitor visitor, Class type, @Nullable Object value) throws SerializationException {
        if (value == null) {
            if (Modifier.isAbstract(type.getModifiers())) {
                throw new SerializationException(String.format("Cannot create new instance of abstract type [%s].", type));
            }
            try {
                Constructor constructor = type.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                value = constructor.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new SerializationException(String.format("Cannot create new instance of type without a default constructor [%s].", type));
            }
            catch (Throwable e) {
                throw new SerializationException(String.format("Failed instantiating type [%s]", type.getName()), e);
            }
        }
        for (Field field : this.fields) {
            try {
                if (!visitor.exists(field.getName())) continue;
                Class<?> fieldType = field.getType();
                if (fieldType == Boolean.TYPE) {
                    field.setBoolean(value, visitor.getBoolean(field.getName()));
                    continue;
                }
                if (fieldType == Byte.TYPE) {
                    field.setByte(value, visitor.getByte(field.getName()));
                    continue;
                }
                if (fieldType == Character.TYPE) {
                    field.setChar(value, visitor.getChar(field.getName()));
                    continue;
                }
                if (fieldType == Short.TYPE) {
                    field.setShort(value, visitor.getShort(field.getName()));
                    continue;
                }
                if (fieldType == Integer.TYPE) {
                    field.setInt(value, visitor.getInt(field.getName()));
                    continue;
                }
                if (fieldType == Long.TYPE) {
                    field.setLong(value, visitor.getLong(field.getName()));
                    continue;
                }
                if (fieldType == Float.TYPE) {
                    field.setFloat(value, visitor.getFloat(field.getName()));
                    continue;
                }
                if (fieldType == Double.TYPE) {
                    field.setDouble(value, visitor.getDouble(field.getName()));
                    continue;
                }
                if (Modifier.isFinal(field.getModifiers())) {
                    visitor.getObject(field.getName(), fieldType, field.get(value));
                    continue;
                }
                field.set(value, visitor.getObject(field.getName(), fieldType, field.get(value)));
            }
            catch (Throwable e) {
                throw new SerializationException(String.format("Failed deserializing field [%s.%s]", type.getName(), field.getName()), e);
            }
        }
        Class parentType = type.getSuperclass();
        if (parentType != null && parentType != Object.class) {
            visitor.getObject("<super>", parentType, value);
        }
        return value;
    }
}

