/*
 * Decompiled with CFR 0.152.
 */
package li.cil.ceres.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import li.cil.ceres.Ceres;
import li.cil.ceres.api.SerializationException;
import li.cil.ceres.api.Serialized;
import li.cil.ceres.api.Serializer;
import li.cil.ceres.internal.GeneratedSerializer;

final class SerializerUtils {
    SerializerUtils() {
    }

    static ArrayList<Field> collectSerializableFields(Class<?> type) throws SerializationException {
        return SerializerUtils.collectSerializableFields(type, new ArrayList());
    }

    private static ArrayList<Field> collectSerializableFields(Class<?> type, ArrayList<Class<?>> seenTypes) {
        boolean serializeFields = type.isAnnotationPresent(Serialized.class);
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : type.getDeclaredFields()) {
            if (field.isSynthetic()) continue;
            if (Modifier.isStatic(field.getModifiers())) {
                if (!field.isAnnotationPresent(Serialized.class)) continue;
                throw new SerializationException(String.format("Trying to use serialization on static field [%s.%s].", type.getName(), field.getName()));
            }
            if (Modifier.isTransient(field.getModifiers())) {
                if (!field.isAnnotationPresent(Serialized.class)) continue;
                throw new SerializationException(String.format("Trying to use serialization on transient field [%s.%s].", type.getName(), field.getName()));
            }
            if (Modifier.isFinal(field.getModifiers()) && SerializerUtils.isImmutable(field.getType(), SerializerUtils.concat(seenTypes, type))) {
                if (!field.isAnnotationPresent(Serialized.class)) continue;
                throw new SerializationException(String.format("Trying to use serialization on immutable field [%s.%s].", type.getName(), field.getName()));
            }
            if (!serializeFields && !field.isAnnotationPresent(Serialized.class)) continue;
            fields.add(field);
        }
        return fields;
    }

    private static boolean isImmutable(Class<?> type, ArrayList<Class<?>> seenTypes) {
        if (type.isPrimitive()) {
            return true;
        }
        if (type.isEnum()) {
            return true;
        }
        if (type.isArray()) {
            return false;
        }
        Serializer<?> serializer = Ceres.getSerializer(type, false);
        if (serializer != null && (!(serializer instanceof GeneratedSerializer) || ((GeneratedSerializer)((Object)serializer)).hasSerializedFields())) {
            return false;
        }
        return !SerializerUtils.hasSerializableFields(type, seenTypes);
    }

    private static boolean hasSerializableFields(Class<?> type, ArrayList<Class<?>> seenTypes) {
        if (seenTypes.contains(type)) {
            return false;
        }
        if (!SerializerUtils.collectSerializableFields(type, seenTypes).isEmpty()) {
            return true;
        }
        Class<?> parentType = type.getSuperclass();
        if (parentType == null || parentType == Object.class) {
            return false;
        }
        return SerializerUtils.hasSerializableFields(parentType, seenTypes);
    }

    private static <T> ArrayList<T> concat(ArrayList<T> list, T value) {
        ArrayList<T> newList = new ArrayList<T>(list);
        newList.add(value);
        return newList;
    }
}

