/*
 * Decompiled with CFR 0.152.
 */
package li.cil.ceres.serializers;

import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;
import javax.annotation.Nullable;
import li.cil.ceres.api.DeserializationVisitor;
import li.cil.ceres.api.SerializationException;
import li.cil.ceres.api.SerializationVisitor;
import li.cil.ceres.api.Serializer;

public final class ByteBufferSerializer
implements Serializer<ByteBuffer> {
    @Override
    public void serialize(SerializationVisitor visitor, Class<ByteBuffer> type, Object value) throws SerializationException {
        ByteBuffer buffer = (ByteBuffer)value;
        visitor.putInt("capacity", buffer.capacity());
        visitor.putInt("position", buffer.position());
        visitor.putInt("limit", buffer.limit());
        int pos = buffer.position();
        int mark = -1;
        try {
            buffer.reset();
            mark = buffer.position();
            buffer.position(pos);
        }
        catch (InvalidMarkException invalidMarkException) {
            // empty catch block
        }
        visitor.putInt("mark", mark);
        byte[] data = new byte[buffer.remaining()];
        for (int i = 0; i < buffer.remaining(); ++i) {
            data[i] = buffer.get();
        }
        buffer.position(pos);
        visitor.putObject("value", byte[].class, data);
    }

    @Override
    public ByteBuffer deserialize(DeserializationVisitor visitor, Class<ByteBuffer> type, @Nullable Object value) throws SerializationException {
        ByteBuffer buffer = (ByteBuffer)value;
        if (!(visitor.exists("capacity") && visitor.exists("position") && visitor.exists("limit") && visitor.exists("mark") && visitor.exists("value"))) {
            return buffer;
        }
        int capacity = visitor.getInt("capacity");
        int position = visitor.getInt("position");
        int limit = visitor.getInt("limit");
        int mark = visitor.getInt("mark");
        byte[] data = (byte[])visitor.getObject("value", byte[].class, null);
        if (data == null) {
            return null;
        }
        if (buffer == null || buffer.capacity() < capacity) {
            buffer = ByteBuffer.allocate(capacity);
        }
        buffer.clear();
        if (mark >= 0) {
            buffer.position(mark);
            buffer.mark();
        }
        buffer.position(position);
        buffer.put(data);
        buffer.position(position);
        buffer.limit(limit);
        return buffer;
    }
}

