/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.api.devicetree;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import li.cil.sedna.api.device.Device;
import li.cil.sedna.devicetree.FlattenedDeviceTree;

public interface DeviceTree {
    public FlattenedDeviceTree flatten();

    public int getPHandle(Device var1);

    public DeviceTree find(String var1);

    public String getPath();

    public DeviceTree addProp(String var1, Object ... var2);

    public DeviceTree getChild(String var1, @Nullable String var2);

    default public DeviceTree getChild(String name, long address) {
        return this.getChild(name, String.format("%x", address));
    }

    default public DeviceTree getChild(String name) {
        return this.getChild(name, null);
    }

    default public DeviceTree putChild(String name, @Nullable String address, Consumer<DeviceTree> builder) {
        builder.accept(this.getChild(name, address));
        return this;
    }

    default public DeviceTree putChild(String name, long address, Consumer<DeviceTree> builder) {
        return this.putChild(name, String.format("%x", address), builder);
    }

    default public DeviceTree putChild(String name, Consumer<DeviceTree> builder) {
        return this.putChild(name, null, builder);
    }
}

