/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.device.block;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import li.cil.sedna.api.device.BlockDevice;
import li.cil.sedna.utils.ByteBufferInputStream;
import li.cil.sedna.utils.ByteBufferOutputStream;
import li.cil.sedna.utils.DirectByteBufferUtils;
import org.apache.commons.io.IOUtils;

public class ByteBufferBlockDevice
implements BlockDevice {
    private final ByteBuffer data;
    private final boolean readonly;
    private int capacity;

    public static ByteBufferBlockDevice create(int size, boolean readonly) {
        return new ByteBufferBlockDevice(ByteBuffer.allocate(size), readonly);
    }

    public static ByteBufferBlockDevice createFromStream(InputStream stream, boolean readonly) throws IOException {
        return new ByteBufferBlockDevice(ByteBuffer.wrap(IOUtils.toByteArray((InputStream)stream)), readonly);
    }

    public static ByteBufferBlockDevice createFromFile(File file, boolean readonly) throws IOException {
        return ByteBufferBlockDevice.createFromFile(file, file.length(), readonly);
    }

    public static ByteBufferBlockDevice createFromFile(File file, long length, boolean readonly) throws IOException {
        return new FileByteBufferBlockDevice(new RandomAccessFile(file, readonly ? "r" : "rw"), length, readonly);
    }

    public static ByteBufferBlockDevice createFromFileChannel(FileChannel channel, long length, boolean readonly) throws IOException {
        return new FileByteBufferBlockDevice(channel, length, readonly);
    }

    public static ByteBufferBlockDevice wrap(ByteBuffer buffer, boolean readonly) {
        return new ByteBufferBlockDevice(buffer, readonly);
    }

    private ByteBufferBlockDevice(ByteBuffer data, boolean readonly) {
        this.data = data;
        this.readonly = readonly;
        this.capacity = data.capacity();
    }

    @Override
    public void close() throws IOException {
        this.capacity = 0;
        DirectByteBufferUtils.release(this.data);
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public InputStream getInputStream(long offset) {
        if (offset < 0L || offset > (long)this.capacity) {
            throw new IllegalArgumentException();
        }
        this.data.position((int)offset);
        return new ByteBufferInputStream(this.data);
    }

    @Override
    public OutputStream getOutputStream(long offset) {
        if (this.isReadonly()) {
            throw new UnsupportedOperationException();
        }
        if (offset < 0L || offset > (long)this.capacity) {
            throw new IllegalArgumentException();
        }
        this.data.position((int)offset);
        return new ByteBufferOutputStream(this.data);
    }

    private static final class FileByteBufferBlockDevice
    extends ByteBufferBlockDevice {
        private final FileChannel channel;

        public FileByteBufferBlockDevice(RandomAccessFile file, long length, boolean readonly) throws IOException {
            this(file.getChannel(), length, readonly);
        }

        public FileByteBufferBlockDevice(FileChannel channel, long length, boolean readonly) throws IOException {
            super(channel.map(readonly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE, 0L, length), readonly);
            this.channel = channel;
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
            super.close();
        }
    }
}

