/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.device.block;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import li.cil.sedna.api.device.BlockDevice;

public final class NullBlockDevice
implements BlockDevice {
    private static final NullBlockDevice READONLY_INSTANCE = new NullBlockDevice(true);
    private static final NullBlockDevice WRITABLE_INSTANCE = new NullBlockDevice(false);
    private final boolean readonly;

    public static NullBlockDevice get(boolean readonly) {
        return readonly ? READONLY_INSTANCE : WRITABLE_INSTANCE;
    }

    public NullBlockDevice(boolean readonly) {
        this.readonly = readonly;
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public long getCapacity() {
        return 0L;
    }

    @Override
    public InputStream getInputStream(long offset) {
        return NullInputStream.INSTANCE;
    }

    @Override
    public OutputStream getOutputStream(long offset) {
        throw new UnsupportedOperationException();
    }

    private static final class NullInputStream
    extends InputStream {
        public static final NullInputStream INSTANCE = new NullInputStream();

        private NullInputStream() {
        }

        @Override
        public int read() throws IOException {
            return -1;
        }
    }
}

