/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.device.memory;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import li.cil.sedna.api.device.PhysicalMemory;
import li.cil.sedna.api.memory.MemoryAccessException;
import li.cil.sedna.utils.DirectByteBufferUtils;

public class ByteBufferMemory
extends PhysicalMemory {
    private final ByteBuffer data;
    private final int size;

    public ByteBufferMemory(int size) {
        if ((size & 3) != 0) {
            throw new IllegalArgumentException("size must be a multiple of four");
        }
        this.data = ByteBuffer.allocateDirect(size);
        this.data.order(ByteOrder.LITTLE_ENDIAN);
        this.size = size;
    }

    public ByteBufferMemory(int size, ByteBuffer buffer) {
        if ((size & 3) != 0) {
            throw new IllegalArgumentException("size must be a multiple of four");
        }
        this.data = buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.size = size;
    }

    @Override
    public void close() throws Exception {
        DirectByteBufferUtils.release(this.data);
    }

    @Override
    public int getLength() {
        return this.size;
    }

    @Override
    public long load(int offset, int sizeLog2) throws MemoryAccessException {
        if (offset < 0 || offset > this.getLength() - (1 << sizeLog2)) {
            throw new MemoryAccessException();
        }
        return switch (sizeLog2) {
            case 0 -> this.data.get(offset);
            case 1 -> this.data.getShort(offset);
            case 2 -> this.data.getInt(offset);
            case 3 -> this.data.getLong(offset);
            default -> throw new IllegalArgumentException();
        };
    }

    @Override
    public void store(int offset, long value, int sizeLog2) throws MemoryAccessException {
        if (offset < 0 || offset > this.getLength() - (1 << sizeLog2)) {
            throw new MemoryAccessException();
        }
        switch (sizeLog2) {
            case 0: {
                this.data.put(offset, (byte)value);
                break;
            }
            case 1: {
                this.data.putShort(offset, (short)value);
                break;
            }
            case 2: {
                this.data.putInt(offset, (int)value);
                break;
            }
            case 3: {
                this.data.putLong(offset, value);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void load(int offset, ByteBuffer dst) throws MemoryAccessException {
        if (offset < 0 || offset > this.getLength() - dst.remaining()) {
            throw new MemoryAccessException();
        }
        ByteBuffer slice = this.data.slice();
        slice.position(offset);
        slice.limit(offset + dst.remaining());
        dst.put(slice);
    }

    @Override
    public void store(int offset, ByteBuffer src) throws MemoryAccessException {
        if (offset < 0 || offset > this.getLength() - src.remaining()) {
            throw new MemoryAccessException();
        }
        ByteBuffer slice = this.data.slice();
        slice.position(offset);
        slice.limit(offset + src.remaining());
        slice.put(src);
    }
}

