/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.device.memory;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import li.cil.sedna.api.device.PhysicalMemory;
import li.cil.sedna.api.memory.MemoryAccessException;
import li.cil.sedna.device.memory.ByteBufferMemory;
import li.cil.sedna.utils.DirectByteBufferUtils;
import li.cil.sedna.utils.UnsafeGetter;
import sun.misc.Unsafe;

public final class UnsafeMemory
extends PhysicalMemory {
    private static final Unsafe UNSAFE = UnsafeGetter.get();
    private final ByteBuffer buffer;
    private final long address;
    private long size;

    public static PhysicalMemory create(int size) {
        if ((size & 3) != 0) {
            throw new IllegalArgumentException("size must be a multiple of four");
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(size + 8).order(ByteOrder.LITTLE_ENDIAN);
        try {
            Field addressField = Buffer.class.getDeclaredField("address");
            long addressFieldOffset = UNSAFE.objectFieldOffset(addressField);
            long address = UNSAFE.getLong(buffer, addressFieldOffset);
            return new UnsafeMemory(buffer, address, size);
        }
        catch (Throwable e) {
            return new ByteBufferMemory(size, buffer);
        }
    }

    private UnsafeMemory(ByteBuffer buffer, long address, int size) {
        this.buffer = buffer;
        this.address = address;
        this.size = size;
    }

    @Override
    public void close() throws Exception {
        this.dispose();
    }

    public void dispose() {
        this.size = 0L;
        DirectByteBufferUtils.release(this.buffer);
    }

    @Override
    public int getLength() {
        return (int)this.size;
    }

    @Override
    public long load(int offset, int sizeLog2) throws MemoryAccessException {
        if (offset < 0 || offset > this.getLength() - (1 << sizeLog2)) {
            throw new MemoryAccessException();
        }
        return switch (sizeLog2) {
            case 0 -> UNSAFE.getByte(this.address + (long)offset);
            case 1 -> UNSAFE.getShort(this.address + (long)offset);
            case 2 -> UNSAFE.getInt(this.address + (long)offset);
            case 3 -> UNSAFE.getLong(this.address + (long)offset);
            default -> throw new IllegalArgumentException();
        };
    }

    @Override
    public void store(int offset, long value, int sizeLog2) throws MemoryAccessException {
        if (offset < 0 || offset > this.getLength() - (1 << sizeLog2)) {
            throw new MemoryAccessException();
        }
        switch (sizeLog2) {
            case 0: {
                UNSAFE.putByte(this.address + (long)offset, (byte)value);
                break;
            }
            case 1: {
                UNSAFE.putShort(this.address + (long)offset, (short)value);
                break;
            }
            case 2: {
                UNSAFE.putInt(this.address + (long)offset, (int)value);
                break;
            }
            case 3: {
                UNSAFE.putLong(this.address + (long)offset, value);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void load(int offset, ByteBuffer dst) throws MemoryAccessException {
        if (offset < 0 || offset > this.getLength() - dst.remaining()) {
            throw new MemoryAccessException();
        }
        while (dst.hasRemaining()) {
            dst.put(UNSAFE.getByte(this.address + (long)offset++));
        }
    }

    @Override
    public void store(int offset, ByteBuffer src) throws MemoryAccessException {
        if (offset < 0 || offset > this.getLength() - src.remaining()) {
            throw new MemoryAccessException();
        }
        while (src.hasRemaining()) {
            UNSAFE.putByte(this.address + (long)offset++, src.get());
        }
    }
}

