/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.device.rtc;

import li.cil.sedna.api.device.rtc.RealTimeCounter;

public final class SystemTimeRealTimeCounter
implements RealTimeCounter {
    private static final SystemTimeRealTimeCounter INSTANCE = new SystemTimeRealTimeCounter();
    private static final int NANOSECONDS_PER_SECOND = 1000000000;
    private static final int FREQUENCY = 10000000;

    public static RealTimeCounter get() {
        return INSTANCE;
    }

    @Override
    public long getTime() {
        long milliseconds = System.currentTimeMillis();
        long seconds = milliseconds / 1000L;
        long nanoseconds = System.nanoTime() % 1000000000L;
        return seconds * 10000000L + nanoseconds / 100L;
    }

    @Override
    public int getFrequency() {
        return 10000000;
    }
}

