/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.device.serial;

import it.unimi.dsi.fastutil.bytes.ByteArrayFIFOQueue;
import java.util.Collections;
import li.cil.ceres.api.Serialized;
import li.cil.sedna.api.Interrupt;
import li.cil.sedna.api.device.InterruptSource;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.api.device.Resettable;
import li.cil.sedna.api.device.Steppable;
import li.cil.sedna.api.device.serial.SerialDevice;

@Serialized
public final class UART16550A
implements Resettable,
Steppable,
MemoryMappedDevice,
SerialDevice,
InterruptSource {
    private static final int UART_RBR_OFFSET = 0;
    private static final int UART_THR_OFFSET = 0;
    private static final int UART_IER_OFFSET = 1;
    private static final int UART_FCR_OFFSET = 2;
    private static final int UART_IIR_OFFSET = 2;
    private static final int UART_LCR_OFFSET = 3;
    private static final int UART_MCR_OFFSET = 4;
    private static final int UART_LSR_OFFSET = 5;
    private static final int UART_MSR_OFFSET = 6;
    private static final int UART_SCR_OFFSET = 7;
    private static final int UART_DLL_OFFSET = 0;
    private static final int UART_DLM_OFFSET = 1;
    private static final int UART_IER_RDI = 1;
    private static final int UART_IER_THRI = 2;
    private static final int UART_IER_RLSI = 4;
    private static final int UART_IER_MSI = 8;
    private static final int UART_IIR_NO_INTERRUPT = 1;
    private static final int UART_IIR_ID_MASK = 14;
    private static final int UART_IIR_MSI = 0;
    private static final int UART_IIR_THRI = 2;
    private static final int UART_IIR_RDI = 4;
    private static final int UART_IIR_RLSI = 6;
    private static final int UART_IIR_CTI = 12;
    private static final int UART_IIR_NO_FIFO = 0;
    private static final int UART_IIR_UNUSABLE_FIFO = 128;
    private static final int UART_IIR_FIFO_ENABLED = 192;
    private static final int UART_LCR_WORD_LENGTH_8 = 3;
    private static final int UART_LCR_STOP_BITS = 4;
    private static final int UART_LCR_ODD_PARITY = 8;
    private static final int UART_LCR_EVEN_PARITY = 24;
    private static final int UART_LCR_HIGH_PARITY = 40;
    private static final int UART_LCR_LOW_PARITY = 56;
    private static final int UART_LCR_BREAK_SIGNAL = 64;
    private static final int UART_LCR_DLAB = 128;
    private static final int UART_LCR_MUTABLE_BITS_MASK = 128;
    private static final int UART_MCR_DTR = 1;
    private static final int UART_MCR_RTS = 2;
    private static final int UART_MCR_AO1 = 4;
    private static final int UART_MCR_AO2 = 8;
    private static final int UART_MCR_LBM = 16;
    private static final int UART_LSR_DR = 1;
    private static final int UART_LSR_OE = 2;
    private static final int UART_LSR_PE = 4;
    private static final int UART_LSR_FE = 8;
    private static final int UART_LSR_BI = 16;
    private static final int UART_LSR_THRE = 32;
    private static final int UART_LSR_TEMT = 64;
    private static final int UART_LSR_FIFOE = 128;
    private static final int UART_LSR_IRQ_MASK = 30;
    private static final int UART_MSR_DCTS = 1;
    private static final int UART_MSR_DDSR = 2;
    private static final int UART_MSR_TERI = 4;
    private static final int UART_MSR_DDCD = 8;
    private static final int UART_MSR_CTS = 16;
    private static final int UART_MSR_DSR = 32;
    private static final int UART_MSR_RI = 64;
    private static final int UART_MSR_DCD = 128;
    private static final int UART_MSR_DIRTY = 15;
    private static final int UART_FCR_FE = 1;
    private static final int UART_FCR_RFR = 2;
    private static final int UART_FCR_XFR = 4;
    private static final int UART_FCR_DMS = 8;
    private static final int UART_FCR_ITL_MASK = 192;
    private static final int UART_FCR_ITL1 = 0;
    private static final int UART_FCR_ITL2 = 64;
    private static final int UART_FCR_ITL3 = 128;
    private static final int UART_FCR_ITL4 = 192;
    private static final int UART_DL_2304 = 2304;
    private static final int UART_DL_384 = 384;
    private static final int UART_DL_96 = 96;
    private static final int UART_DL_48 = 48;
    private static final int UART_DL_24 = 24;
    private static final int UART_DL_12 = 12;
    private static final int UART_DL_6 = 6;
    private static final int UART_DL_3 = 3;
    private static final int UART_DL_2 = 2;
    private static final int UART_DL_1 = 1;
    private static final int FIFO_QUEUE_CAPACITY = 16;
    private byte rbr;
    private byte thr;
    private byte ier;
    private byte iir;
    private byte fcr;
    private byte lcr;
    private byte mcr;
    private byte lsr;
    private byte msr;
    private byte scr;
    private short dl;
    private int triggerLevel;
    private final ByteArrayFIFOQueue receiveFifo = new ByteArrayFIFOQueue(16);
    private final ByteArrayFIFOQueue transmitFifo = new ByteArrayFIFOQueue(16);
    private boolean interruptUpdatePending;
    private boolean transmitInterruptPending;
    private boolean timeoutInterruptPending;
    private final transient Interrupt interrupt = new Interrupt();
    private final transient Object lock = new Object();

    public UART16550A() {
        this.reset();
    }

    public Interrupt getInterrupt() {
        return this.interrupt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() {
        Object object = this.lock;
        synchronized (object) {
            byte value;
            if ((this.lsr & 0x40) != 0) {
                return -1;
            }
            if ((this.fcr & 1) != 0) {
                value = this.transmitFifo.dequeueByte();
                if (this.transmitFifo.isEmpty()) {
                    this.lsr = (byte)(this.lsr | 0x60);
                }
            } else {
                value = this.thr;
                this.lsr = (byte)(this.lsr | 0x60);
            }
            if ((this.lsr & 0x20) != 0 && !this.transmitInterruptPending) {
                this.transmitInterruptPending = true;
                this.interruptUpdatePending = true;
            }
            return value;
        }
    }

    @Override
    public boolean canPutByte() {
        return this.receiveFifo.size() < 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putByte(byte value) {
        Object object = this.lock;
        synchronized (object) {
            if ((this.fcr & 1) != 0) {
                if (this.receiveFifo.size() < 16) {
                    this.receiveFifo.enqueue(value);
                } else {
                    this.lsr = (byte)(this.lsr | 2);
                }
            } else {
                if ((this.lsr & 1) != 0) {
                    this.lsr = (byte)(this.lsr | 2);
                }
                this.rbr = value;
            }
            this.lsr = (byte)(this.lsr | 1);
            this.timeoutInterruptPending = true;
            this.interruptUpdatePending = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBreak() {
        Object object = this.lock;
        synchronized (object) {
            this.rbr = 0;
            this.putByte((byte)0);
            this.lsr = (byte)(this.lsr | 0x11);
        }
    }

    @Override
    public void reset() {
        this.rbr = 0;
        this.thr = 0;
        this.ier = 0;
        this.iir = 1;
        this.fcr = 0;
        this.lcr = 0;
        this.mcr = (byte)8;
        this.lsr = (byte)96;
        this.msr = (byte)-80;
        this.scr = 0;
        this.dl = (short)12;
        this.triggerLevel = 1;
        this.receiveFifo.clear();
        this.transmitFifo.clear();
        this.interruptUpdatePending = false;
        this.transmitInterruptPending = false;
        this.timeoutInterruptPending = false;
        this.interrupt.lowerInterrupt();
    }

    @Override
    public void step(int cycles) {
        if (this.interruptUpdatePending) {
            this.updateInterrupts();
        }
    }

    @Override
    public int getLength() {
        return 256;
    }

    @Override
    public int getSupportedSizes() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long load(int offset, int sizeLog2) {
        assert (sizeLog2 == 0);
        switch (offset) {
            case 0: {
                byte result;
                if ((this.lcr & 0x80) != 0) {
                    return (byte)this.dl;
                }
                Object object = this.lock;
                synchronized (object) {
                    if ((this.fcr & 1) != 0) {
                        byte by = result = this.receiveFifo.isEmpty() ? (byte)0 : this.receiveFifo.dequeueByte();
                        if (this.receiveFifo.isEmpty()) {
                            this.lsr = (byte)(this.lsr & 0xFFFFFFEE);
                            this.timeoutInterruptPending = false;
                        } else {
                            this.timeoutInterruptPending = true;
                        }
                    } else {
                        result = this.rbr;
                        this.lsr = (byte)(this.lsr & 0xFFFFFFEE);
                    }
                    this.updateInterrupts();
                }
                if ((this.mcr & 0x10) == 0) {
                    // empty if block
                }
                return result;
            }
            case 1: {
                if ((this.lcr & 0x80) != 0) {
                    return (byte)(this.dl >>> 8);
                }
                return this.ier;
            }
            case 2: {
                Object object = this.lock;
                synchronized (object) {
                    byte result = this.iir;
                    if ((this.iir & 0xE) == 2) {
                        this.transmitInterruptPending = false;
                        this.updateInterrupts();
                    }
                    return result;
                }
            }
            case 3: {
                return this.lcr;
            }
            case 4: {
                return this.mcr;
            }
            case 5: {
                Object object = this.lock;
                synchronized (object) {
                    byte result = this.lsr;
                    if ((this.lsr & 0x12) != 0) {
                        this.lsr = (byte)(this.lsr & 0xFFFFFFED);
                        this.updateInterrupts();
                    }
                    return result;
                }
            }
            case 6: {
                if ((this.mcr & 0x10) != 0) {
                    return (byte)((this.mcr & 0xC) << 4 | (this.mcr & 2) << 3 | (this.mcr & 1) << 5);
                }
                Object object = this.lock;
                synchronized (object) {
                    byte result = this.msr;
                    if ((this.msr & 0xF) != 0) {
                        this.msr = (byte)(this.msr & 0xFFFFFFF0);
                        this.updateInterrupts();
                    }
                    return result;
                }
            }
            case 7: {
                return this.scr;
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(int offset, long value, int sizeLog2) {
        assert (sizeLog2 == 0);
        switch (offset) {
            case 0: {
                if ((this.lcr & 0x80) != 0) {
                    this.dl = (short)((long)(this.dl & 0xFF00) | value & 0xFFL);
                    break;
                }
                Object object = this.lock;
                synchronized (object) {
                    this.thr = (byte)value;
                    if ((this.fcr & 1) != 0) {
                        if (this.transmitFifo.size() >= 16) {
                            this.transmitFifo.dequeueByte();
                        }
                        this.transmitFifo.enqueue(this.thr);
                    }
                    this.transmitInterruptPending = false;
                    this.lsr = (byte)(this.lsr & 0xFFFFFF9F);
                    this.updateInterrupts();
                    break;
                }
            }
            case 1: {
                if ((this.lcr & 0x80) != 0) {
                    this.dl = (short)(value << 8 | (long)(this.dl & 0xFF));
                    break;
                }
                Object object = this.lock;
                synchronized (object) {
                    int changes = this.ier ^ (byte)value;
                    this.ier = (byte)(value & 0xFL);
                    if ((changes & 2) != 0) {
                        boolean bl = this.transmitInterruptPending = (this.ier & 2) != 0 && (this.lsr & 0x20) != 0;
                    }
                    if (changes != 0) {
                        this.updateInterrupts();
                    }
                    break;
                }
            }
            case 2: {
                Object object = this.lock;
                synchronized (object) {
                    ByteArrayFIFOQueue byteArrayFIFOQueue;
                    boolean forceClear;
                    int changes = this.fcr ^ (byte)value;
                    boolean bl = forceClear = (changes & 1) != 0;
                    if (forceClear || (value & 2L) != 0L) {
                        byteArrayFIFOQueue = this.receiveFifo;
                        synchronized (byteArrayFIFOQueue) {
                            this.lsr = (byte)(this.lsr & 0xFFFFFFEE);
                            this.timeoutInterruptPending = false;
                            this.receiveFifo.clear();
                        }
                    }
                    if (forceClear || (value & 4L) != 0L) {
                        byteArrayFIFOQueue = this.transmitFifo;
                        synchronized (byteArrayFIFOQueue) {
                            this.lsr = (byte)(this.lsr | 0x60);
                            this.transmitInterruptPending = true;
                            this.transmitFifo.clear();
                        }
                    }
                    this.fcr = (byte)(value & 0xC9L);
                    if ((this.fcr & 1) != 0) {
                        this.iir = (byte)(this.iir | 0xC0);
                        switch (this.fcr & 0xC0) {
                            case 0: {
                                this.triggerLevel = 1;
                                break;
                            }
                            case 64: {
                                this.triggerLevel = 4;
                                break;
                            }
                            case 128: {
                                this.triggerLevel = 8;
                                break;
                            }
                            case 192: {
                                this.triggerLevel = 14;
                            }
                        }
                    } else {
                        this.iir = (byte)(this.iir & 0xFFFFFF3F);
                    }
                    this.updateInterrupts();
                    break;
                }
            }
            case 3: {
                this.lcr = (byte)value;
                break;
            }
            case 4: {
                this.mcr = (byte)(value & 0x1FL);
                break;
            }
            case 7: {
                this.scr = (byte)value;
            }
        }
    }

    @Override
    public Iterable<Interrupt> getInterrupts() {
        return Collections.singleton(this.interrupt);
    }

    private void updateInterrupts() {
        int niir = (this.ier & 4) != 0 && (this.lsr & 0x1E) != 0 ? 6 : ((this.ier & 1) != 0 && this.timeoutInterruptPending ? 12 : ((this.ier & 1) != 0 && (this.lsr & 1) != 0 && ((this.fcr & 1) == 0 || this.receiveFifo.size() > this.triggerLevel) ? 4 : ((this.ier & 2) != 0 && this.transmitInterruptPending ? 2 : ((this.ier & 8) != 0 && (this.msr & 0xF) != 0 ? 0 : 1))));
        this.iir = (byte)(niir | this.iir & 0xFFFFFFF0);
        if ((this.iir & 1) != 0) {
            this.interrupt.lowerInterrupt();
        } else {
            this.interrupt.raiseInterrupt();
        }
    }
}

