/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.device.syscon;

import li.cil.sedna.api.device.MemoryMappedDevice;

public abstract class AbstractSystemController
implements MemoryMappedDevice {
    public static final int SYSCON_RESET = 4096;
    public static final int SYSCON_POWEROFF = 8192;

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public long load(int offset, int sizeLog2) {
        return 0L;
    }

    @Override
    public void store(int offset, long value, int sizeLog2) {
        if (offset == 0) {
            switch ((int)(value & 0xFFFFL)) {
                case 4096: {
                    this.handleReset();
                    break;
                }
                case 8192: {
                    this.handlePowerOff();
                }
            }
        }
    }

    protected abstract void handleReset();

    protected abstract void handlePowerOff();
}

