/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.device.virtio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import li.cil.ceres.api.Serialized;
import li.cil.sedna.api.Interrupt;
import li.cil.sedna.api.device.InterruptSource;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.api.device.Resettable;
import li.cil.sedna.api.memory.MemoryAccessException;
import li.cil.sedna.api.memory.MemoryMap;
import li.cil.sedna.device.virtio.DescriptorChain;
import li.cil.sedna.device.virtio.VirtIODeviceException;
import li.cil.sedna.device.virtio.VirtIODeviceSpec;
import li.cil.sedna.device.virtio.VirtqueueIterator;
import li.cil.sedna.memory.MemoryMaps;

@Serialized
public abstract class AbstractVirtIODevice
implements MemoryMappedDevice,
InterruptSource,
Resettable {
    protected static final int VIRTIO_VENDOR_ID_GENERIC = 65535;
    protected static final long VIRTIO_F_RING_INDIRECT_DESC = 0x10000000L;
    protected static final long VIRTIO_F_RING_EVENT_IDX = 0x20000000L;
    protected static final long VIRTIO_F_VERSION_1 = 0x100000000L;
    protected static final long VIRTIO_F_ACCESS_PLATFORM = 0x200000000L;
    protected static final long VIRTIO_F_RING_PACKED = 0x400000000L;
    protected static final long VIRTIO_F_IN_ORDER = 0x800000000L;
    protected static final long VIRTIO_F_ORDER_PLATFORM = 0x1000000000L;
    protected static final long VIRTIO_F_SR_IOV = 0x2000000000L;
    protected static final long VIRTIO_F_NOTIFICATION_DATA = 0x4000000000L;
    protected static final int VIRTIO_STATUS_ACKNOWLEDGE = 1;
    protected static final int VIRTIO_STATUS_DRIVER = 2;
    protected static final int VIRTIO_STATUS_DRIVER_OK = 4;
    protected static final int VIRTIO_STATUS_FEATURES_OK = 8;
    protected static final int VIRTIO_STATUS_DEVICE_NEEDS_RESET = 64;
    protected static final int VIRTIO_STATUS_FAILED = 128;
    private static final int VIRTIO_IRQ_USED_BUFFER_MASK = 1;
    private static final int VIRTIO_IRQ_CONFIGURATION_CHANGE_MASK = 2;
    private static final int VIRTIO_MAGIC = 1953655158;
    private static final int VIRTIO_VERSION = 2;
    private static final int VIRTIO_MMIO_MAGIC = 0;
    private static final int VIRTIO_MMIO_VERSION = 4;
    private static final int VIRTIO_MMIO_DEVICE_ID = 8;
    private static final int VIRTIO_MMIO_VENDOR_ID = 12;
    private static final int VIRTIO_MMIO_DEVICE_FEATURES = 16;
    private static final int VIRTIO_MMIO_DEVICE_FEATURES_SEL = 20;
    private static final int VIRTIO_MMIO_DRIVER_FEATURES = 32;
    private static final int VIRTIO_MMIO_DRIVER_FEATURES_SEL = 36;
    private static final int VIRTIO_MMIO_QUEUE_SEL = 48;
    private static final int VIRTIO_MMIO_QUEUE_NUM_MAX = 52;
    private static final int VIRTIO_MMIO_QUEUE_NUM = 56;
    private static final int VIRTIO_MMIO_QUEUE_READY = 68;
    private static final int VIRTIO_MMIO_QUEUE_NOTIFY = 80;
    private static final int VIRTIO_MMIO_INTERRUPT_STATUS = 96;
    private static final int VIRTIO_MMIO_INTERRUPT_ACK = 100;
    private static final int VIRTIO_MMIO_STATUS = 112;
    private static final int VIRTIO_MMIO_QUEUE_DESC_LOW = 128;
    private static final int VIRTIO_MMIO_QUEUE_DESC_HIGH = 132;
    private static final int VIRTIO_MMIO_QUEUE_DRIVER_LOW = 144;
    private static final int VIRTIO_MMIO_QUEUE_DRIVER_HIGH = 148;
    private static final int VIRTIO_MMIO_QUEUE_DEVICE_LOW = 160;
    private static final int VIRTIO_MMIO_QUEUE_DEVICE_HIGH = 164;
    private static final int VIRTIO_MMIO_CONFIG_GENERATION = 252;
    private static final int VIRTIO_MMIO_CONFIG = 256;
    private static final int VIRTQ_MAX_QUEUE_SIZE = 256;
    private static final int VIRTQ_MAX_CHAIN_LENGTH = 128;
    private final transient MemoryMap memoryMap;
    private final transient VirtIODeviceSpec spec;
    private final transient Interrupt interrupt = new Interrupt();
    private final ByteBuffer configuration;
    private final SplitVirtqueue[] queues;
    private int status = 0;
    private int interruptStatus = 0;
    private int deviceFeaturesSel;
    private long driverFeatures;
    private int driverFeaturesSel;
    private int queueSel;
    private int configGeneration;

    protected AbstractVirtIODevice(MemoryMap memoryMap, VirtIODeviceSpec spec) {
        this.memoryMap = memoryMap;
        this.spec = spec;
        this.configuration = ByteBuffer.allocate(spec.configSpaceSizeInBytes);
        this.configuration.order(ByteOrder.LITTLE_ENDIAN);
        this.queues = new SplitVirtqueue[spec.virtQueueCount];
        for (int i = 0; i < this.queues.length; ++i) {
            this.queues[i] = new SplitVirtqueue();
        }
    }

    public Interrupt getInterrupt() {
        return this.interrupt;
    }

    protected void initializeConfig() {
    }

    protected final ByteBuffer getConfiguration() {
        return this.configuration;
    }

    protected final void setConfigValue(int offset, byte value) {
        this.configuration.put(offset, value);
        this.notifyConfigChanged();
    }

    protected final void setConfigValue(int offset, short value) {
        this.configuration.putShort(offset, value);
        this.notifyConfigChanged();
    }

    protected final void setConfigValue(int offset, int value) {
        this.configuration.putInt(offset, value);
        this.notifyConfigChanged();
    }

    protected final void setConfigValue(int offset, byte[] value) {
        for (int i = 0; i < value.length; ++i) {
            this.configuration.put(offset + i, value[i]);
        }
        this.notifyConfigChanged();
    }

    protected int loadConfig(int offset, int sizeLog2) {
        switch (sizeLog2) {
            case 0: {
                if (offset < 0 || offset >= this.configuration.limit()) break;
                return this.configuration.get(offset);
            }
            case 1: {
                if (offset < 0 || offset >= this.configuration.limit() - 1) break;
                return this.configuration.getShort(offset);
            }
            case 2: {
                if (offset < 0 || offset >= this.configuration.limit() - 3) break;
                return this.configuration.getInt(offset);
            }
        }
        return 0;
    }

    protected void storeConfig(int offset, long value, int sizeLog2) {
        switch (sizeLog2) {
            case 0: {
                if (offset < 0 || offset >= this.configuration.limit()) break;
                this.configuration.put(offset, (byte)value);
                break;
            }
            case 1: {
                if (offset < 0 || offset >= this.configuration.limit() - 1) break;
                this.configuration.putShort(offset, (short)value);
                break;
            }
            case 2: {
                if (offset < 0 || offset >= this.configuration.limit() - 3) break;
                this.configuration.putInt(offset, (int)value);
                break;
            }
            case 3: {
                if (offset < 0 || offset >= this.configuration.limit() - 7) break;
                this.configuration.putLong(offset, value);
            }
        }
    }

    protected void handleDeviceAcknowledged() {
    }

    protected void handleDeviceDriverPresent() {
    }

    protected void handleFeaturesNegotiated() {
    }

    protected void handleDeviceSetupComplete() {
    }

    protected void handleDeviceSetupFailed() {
    }

    protected boolean isFeatureSubsetSupported(long features) {
        return (features & 0x100000000L) != 0L;
    }

    protected final int getStatus() {
        return this.status;
    }

    protected final long getNegotiatedFeatures() {
        return this.spec.features & this.driverFeatures;
    }

    protected final void notifyConfigChanged() {
        if ((this.status & 1) == 0) {
            return;
        }
        ++this.configGeneration;
        this.interruptStatus |= 2;
        this.updateInterrupts();
    }

    public final void error() {
        this.status |= 0x40;
        this.notifyConfigChanged();
    }

    @Nullable
    protected final VirtqueueIterator getQueueIterator(int queueIndex) {
        if ((this.status & 8) == 0) {
            return null;
        }
        return this.queues[queueIndex];
    }

    protected void handleQueueNotification(int queueIndex) throws VirtIODeviceException, MemoryAccessException {
    }

    protected final void setQueueNotifications(int queueIndex, boolean enabled) {
        if ((this.status & 8) == 0) {
            return;
        }
        this.queues[queueIndex].dispatchQueueNotifications = enabled;
    }

    @Nullable
    protected final DescriptorChain validateReadOnlyDescriptorChain(int queueIndex, @Nullable DescriptorChain chain) throws VirtIODeviceException, MemoryAccessException {
        VirtqueueIterator queue;
        if (chain != null) {
            if (chain.readableBytes() > 0) {
                return chain;
            }
            chain.use();
        }
        if ((queue = this.getQueueIterator(queueIndex)) == null) {
            return null;
        }
        while (queue.hasNext()) {
            DescriptorChain newChain = queue.next();
            if (newChain.writableBytes() > 0) {
                this.error();
                return null;
            }
            if (newChain.readableBytes() > 0) {
                return newChain;
            }
            newChain.use();
        }
        return null;
    }

    @Nullable
    protected final DescriptorChain validateWriteOnlyDescriptorChain(int queueIndex, @Nullable DescriptorChain chain) throws VirtIODeviceException, MemoryAccessException {
        VirtqueueIterator queue;
        if (chain != null) {
            if (chain.writableBytes() > 0) {
                return chain;
            }
            chain.use();
        }
        if ((queue = this.getQueueIterator(queueIndex)) == null) {
            return null;
        }
        while (queue.hasNext()) {
            DescriptorChain newChain = queue.next();
            if (newChain.readableBytes() > 0) {
                this.error();
                throw new VirtIODeviceException();
            }
            if (newChain.writableBytes() > 0) {
                return newChain;
            }
            newChain.use();
        }
        return null;
    }

    @Override
    public final int getLength() {
        return 256 + this.configuration.capacity();
    }

    @Override
    public int getSupportedSizes() {
        return 5;
    }

    @Override
    public final long load(int offset, int sizeLog2) {
        if (offset >= 256) {
            return this.loadConfig(offset - 256, sizeLog2);
        }
        if (sizeLog2 != 2) {
            return 0L;
        }
        switch (offset) {
            case 0: {
                return 1953655158L;
            }
            case 4: {
                return 2L;
            }
            case 8: {
                return this.spec.deviceId;
            }
            case 12: {
                return this.spec.vendorId;
            }
            case 16: {
                if (Long.compareUnsigned(this.deviceFeaturesSel, 1L) <= 0) {
                    int shift = this.deviceFeaturesSel * 32;
                    return (int)(this.spec.features >>> shift);
                }
            }
            case 52: {
                return 256L;
            }
            case 68: {
                return this.queues[this.queueSel].ready;
            }
            case 96: {
                return this.interruptStatus;
            }
            case 112: {
                return this.status;
            }
            case 252: {
                return this.configGeneration;
            }
        }
        return 0L;
    }

    @Override
    public final void store(int offset, long value, int sizeLog2) {
        if (offset >= 256) {
            this.storeConfig(offset - 256, value, sizeLog2);
            return;
        }
        if (sizeLog2 != 2) {
            return;
        }
        int intValue = (int)value;
        switch (offset) {
            case 20: {
                this.deviceFeaturesSel = intValue;
                break;
            }
            case 32: {
                if (Long.compareUnsigned(this.driverFeaturesSel, 1L) > 0) break;
                int shift = this.driverFeaturesSel * 32;
                long mask = 0xFFFFFFFFL;
                this.driverFeatures = this.driverFeatures & (0xFFFFFFFFL << shift ^ 0xFFFFFFFFFFFFFFFFL) | ((long)intValue & 0xFFFFFFFFL) << shift;
                break;
            }
            case 36: {
                this.driverFeaturesSel = intValue;
                break;
            }
            case 48: {
                if (Integer.compareUnsigned(intValue, this.queues.length) >= 0) break;
                this.queueSel = intValue;
                break;
            }
            case 56: {
                if (intValue > 32768 || Integer.bitCount(intValue) != 1) break;
                this.queues[this.queueSel].num = intValue;
                break;
            }
            case 68: {
                this.queues[this.queueSel].ready = intValue != 0 ? 1 : 0;
                break;
            }
            case 80: {
                if ((this.status & 4) == 0) {
                    this.error();
                    return;
                }
                if (Integer.compareUnsigned(intValue, this.queues.length) >= 0) break;
                try {
                    this.queues[intValue].handleQueueNotification(intValue);
                }
                catch (MemoryAccessException | VirtIODeviceException e) {
                    this.error();
                }
                break;
            }
            case 100: {
                this.interruptStatus &= ~intValue;
                this.updateInterrupts();
                break;
            }
            case 112: {
                int change = this.status ^ intValue;
                this.status = intValue;
                if ((change & this.status & 1) != 0) {
                    this.handleDeviceAcknowledged();
                }
                if ((change & this.status & 2) != 0) {
                    this.handleDeviceDriverPresent();
                }
                if ((change & this.status & 8) != 0) {
                    if (!this.isFeatureSubsetSupported(this.getNegotiatedFeatures())) {
                        this.status &= 0xFFFFFFF7;
                    } else {
                        if (((long)this.status & 0x400000000L) != 0L) {
                            throw new AssertionError((Object)"Packed queues not implemented");
                        }
                        this.handleFeaturesNegotiated();
                    }
                }
                if ((change & this.status & 4) != 0) {
                    this.handleDeviceSetupComplete();
                }
                if ((change & this.status & 0x80) != 0) {
                    this.handleDeviceSetupFailed();
                }
                if (intValue != 0) break;
                this.reset();
                break;
            }
            case 128: {
                this.queues[this.queueSel].desc = this.queues[this.queueSel].desc & 0xFFFFFFFF00000000L | (long)intValue & 0xFFFFFFFFL;
                break;
            }
            case 132: {
                this.queues[this.queueSel].desc = this.queues[this.queueSel].desc & 0xFFFFFFFFL | (long)intValue << 32;
                break;
            }
            case 144: {
                this.queues[this.queueSel].driver = this.queues[this.queueSel].driver & 0xFFFFFFFF00000000L | (long)intValue & 0xFFFFFFFFL;
                break;
            }
            case 148: {
                this.queues[this.queueSel].driver = this.queues[this.queueSel].driver & 0xFFFFFFFFL | (long)intValue << 32;
                break;
            }
            case 160: {
                this.queues[this.queueSel].device = this.queues[this.queueSel].device & 0xFFFFFFFF00000000L | (long)intValue & 0xFFFFFFFFL;
                break;
            }
            case 164: {
                this.queues[this.queueSel].device = this.queues[this.queueSel].device & 0xFFFFFFFFL | (long)intValue << 32;
            }
        }
    }

    @Override
    public final Iterable<Interrupt> getInterrupts() {
        return Collections.singletonList(this.interrupt);
    }

    @Override
    public void reset() {
        this.status = 0;
        this.interruptStatus = 0;
        this.deviceFeaturesSel = 0;
        this.driverFeatures = 0L;
        this.driverFeaturesSel = 0;
        this.queueSel = 0;
        this.configGeneration = 0;
        for (SplitVirtqueue queue : this.queues) {
            queue.reset();
        }
        this.interrupt.lowerInterrupt();
        this.initializeConfig();
    }

    private void updateInterrupts() {
        if (this.interruptStatus == 0 || (this.status & 4) == 0) {
            this.interrupt.lowerInterrupt();
        } else {
            this.interrupt.raiseInterrupt();
        }
    }

    @Serialized
    public final class SplitVirtqueue
    extends AbstractVirtqueue {
        private static final int VIRTQ_DESC_TABLE_STRIDE = 16;
        private static final int VIRTQ_DESC_ADDR = 0;
        private static final int VIRTQ_DESC_LEN = 8;
        private static final int VIRTQ_DESC_FLAGS = 12;
        private static final int VIRTQ_DESC_NEXT = 14;
        private static final int VIRTQ_AVAIL_FLAGS = 0;
        private static final int VIRTQ_AVAIL_IDX = 2;
        private static final int VIRTQ_AVAIL_RING = 4;
        private static final int VIRTQ_AVAILABLE_RING_STRIDE = 2;
        private static final int VIRTQ_USED_FLAGS = 0;
        private static final int VIRTQ_USED_IDX = 2;
        private static final int VIRTQ_USED_RING = 4;
        private static final int VIRTQ_USED_RING_STRIDE = 8;
        private static final int VIRTQ_USED_RING_ELEM_ID = 0;
        private static final int VIRTQ_USED_RING_ELEM_LEN = 4;
        private static final int VIRTQ_DESC_F_NEXT = 1;
        private static final int VIRTQ_DESC_F_WRITE = 2;
        private static final int VIRTQ_DESC_F_INDIRECT = 4;
        short lastAvailIdx;

        @Override
        void reset() {
            super.reset();
            this.lastAvailIdx = 0;
        }

        @Override
        public boolean hasNext() throws MemoryAccessException {
            return this.ready != 0 && this.lastAvailIdx != this.getAvailIdx();
        }

        @Override
        public DescriptorChain next() throws VirtIODeviceException, MemoryAccessException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            short s = this.lastAvailIdx;
            this.lastAvailIdx = (short)(s + 1);
            return new DescriptorChainImpl(this.getAvailRing(s));
        }

        @Override
        void handleQueueNotification(int queueIndex) throws VirtIODeviceException, MemoryAccessException {
            if (this.ready == 0 || !this.dispatchQueueNotifications) {
                return;
            }
            if (this.hasNext()) {
                AbstractVirtIODevice.this.handleQueueNotification(queueIndex);
            }
        }

        long getDescAddress(int i) throws MemoryAccessException {
            return AbstractVirtIODevice.this.memoryMap.load(this.descIndexToAddress(i) + 0L, 3);
        }

        int getDescLength(int i) throws MemoryAccessException {
            return (int)AbstractVirtIODevice.this.memoryMap.load(this.descIndexToAddress(i) + 8L, 2);
        }

        short getDescFlags(int i) throws MemoryAccessException {
            return (short)AbstractVirtIODevice.this.memoryMap.load(this.descIndexToAddress(i) + 12L, 1);
        }

        short getDescNext(int i) throws MemoryAccessException {
            return (short)AbstractVirtIODevice.this.memoryMap.load(this.descIndexToAddress(i) + 14L, 1);
        }

        long descIndexToAddress(int i) {
            return this.desc + (long)i * 16L;
        }

        short getAvailFlags() throws MemoryAccessException {
            return (short)AbstractVirtIODevice.this.memoryMap.load(this.driver + 0L, 1);
        }

        short getAvailIdx() throws MemoryAccessException {
            return (short)AbstractVirtIODevice.this.memoryMap.load(this.driver + 2L, 1);
        }

        short getAvailRing(int i) throws MemoryAccessException {
            long address = this.driver + 4L + (long)this.toWrappedRingIndex(i) * 2L;
            return (short)(AbstractVirtIODevice.this.memoryMap.load(address, 1) & 0xFFFFL);
        }

        short getAvailUsedEvent() throws MemoryAccessException {
            return (short)AbstractVirtIODevice.this.memoryMap.load(this.driver + 4L + (long)this.num * 2L, 1);
        }

        void setUsedFlags(int value) throws MemoryAccessException {
            AbstractVirtIODevice.this.memoryMap.store(this.device + 0L, value, 1);
        }

        short getUsedIdx() throws MemoryAccessException {
            return (short)AbstractVirtIODevice.this.memoryMap.load(this.device + 2L, 1);
        }

        void setUsedIdx(short value) throws MemoryAccessException {
            AbstractVirtIODevice.this.memoryMap.store(this.device + 2L, value, 1);
        }

        void setUsedRing(int i, int id, int len) throws MemoryAccessException {
            long address = this.device + 4L + (long)this.toWrappedRingIndex(i) * 8L;
            AbstractVirtIODevice.this.memoryMap.store(address + 0L, id, 2);
            AbstractVirtIODevice.this.memoryMap.store(address + 4L, len, 2);
        }

        void setUsedAvailEvent(int value) throws MemoryAccessException {
            AbstractVirtIODevice.this.memoryMap.store(this.device + 4L + (long)this.num * 8L, value, 1);
        }

        int toWrappedRingIndex(int index) {
            return index & this.num - 1;
        }

        final class DescriptorChainImpl
        implements DescriptorChain {
            final short headDescIdx;
            final int readableByteCount;
            final int writableByteCount;
            int readByteCount;
            int writtenByteCount;
            boolean isUsed;
            short descIdx;
            long address;
            int length;
            int position;
            int chainLength = 1;

            DescriptorChainImpl(short headDescIdx) throws VirtIODeviceException, MemoryAccessException {
                this.headDescIdx = headDescIdx;
                int readableByteCount = 0;
                int writableByteCount = 0;
                short descIdx = headDescIdx;
                short descFlags = SplitVirtqueue.this.getDescFlags(descIdx);
                int descLength = SplitVirtqueue.this.getDescLength(descIdx);
                int chainLength = 1;
                boolean hasDesc = true;
                while ((descFlags & 2) == 0) {
                    readableByteCount += descLength;
                    if ((descFlags & 1) == 0) {
                        hasDesc = false;
                        break;
                    }
                    if (chainLength >= 128) {
                        AbstractVirtIODevice.this.error();
                        throw new VirtIODeviceException();
                    }
                    descIdx = SplitVirtqueue.this.getDescNext(descIdx);
                    descFlags = SplitVirtqueue.this.getDescFlags(descIdx);
                    descLength = SplitVirtqueue.this.getDescLength(descIdx);
                    ++chainLength;
                }
                if (hasDesc) {
                    while (true) {
                        if ((descFlags & 2) == 0) {
                            AbstractVirtIODevice.this.error();
                            throw new VirtIODeviceException();
                        }
                        writableByteCount += descLength;
                        if ((descFlags & 1) == 0) break;
                        if (chainLength >= 128) {
                            AbstractVirtIODevice.this.error();
                            throw new VirtIODeviceException();
                        }
                        descIdx = SplitVirtqueue.this.getDescNext(descIdx);
                        descFlags = SplitVirtqueue.this.getDescFlags(descIdx);
                        descLength = SplitVirtqueue.this.getDescLength(descIdx);
                        ++chainLength;
                    }
                }
                this.readableByteCount = readableByteCount;
                this.writableByteCount = writableByteCount;
                this.setDescriptor(headDescIdx);
            }

            @Override
            public void use() throws MemoryAccessException {
                boolean sendNotification;
                if (this.isUsed) {
                    return;
                }
                this.isUsed = true;
                short index = SplitVirtqueue.this.getUsedIdx();
                SplitVirtqueue.this.setUsedRing(index, this.headDescIdx, this.writtenByteCount);
                index = (short)(index + 1);
                SplitVirtqueue.this.setUsedIdx(index);
                if ((AbstractVirtIODevice.this.getNegotiatedFeatures() & 0x20000000L) == 0L) {
                    short flags = SplitVirtqueue.this.getAvailFlags();
                    sendNotification = flags == 0;
                } else {
                    short usedEvent = SplitVirtqueue.this.getAvailUsedEvent();
                    boolean bl = sendNotification = index == (usedEvent = (short)(usedEvent + 1));
                }
                if (sendNotification) {
                    AbstractVirtIODevice.this.interruptStatus |= 1;
                    AbstractVirtIODevice.this.updateInterrupts();
                }
            }

            @Override
            public int readableBytes() {
                if (this.isUsed) {
                    return 0;
                }
                assert (this.readByteCount <= this.readableByteCount);
                return this.readableByteCount - this.readByteCount;
            }

            @Override
            public int writableBytes() {
                if (this.isUsed) {
                    return 0;
                }
                assert (this.writtenByteCount <= this.writableByteCount);
                return this.writableByteCount - this.writtenByteCount;
            }

            @Override
            public void skip(int count) throws VirtIODeviceException, MemoryAccessException {
                if (this.isUsed) {
                    throw new IllegalStateException();
                }
                if (count > this.readableBytes() + this.writableBytes()) {
                    throw new IndexOutOfBoundsException();
                }
                while (count > 0) {
                    assert (this.position < this.length);
                    int remaining = this.length - this.position;
                    int skip = Math.min(count, remaining);
                    count -= skip;
                    if (this.readableBytes() > 0) {
                        assert (this.readableBytes() <= skip);
                        this.readByteCount += skip;
                    } else {
                        assert (this.writableBytes() <= skip);
                        this.writtenByteCount += skip;
                    }
                    this.position += skip;
                    if (this.position < this.length) continue;
                    this.nextDescriptor();
                }
            }

            @Override
            public byte get() throws VirtIODeviceException, MemoryAccessException {
                if (this.isUsed) {
                    throw new IllegalStateException();
                }
                if (this.readableBytes() <= 0) {
                    throw new IndexOutOfBoundsException();
                }
                assert (this.position < this.length);
                byte value = (byte)AbstractVirtIODevice.this.memoryMap.load(this.address + (long)this.position, 0);
                ++this.readByteCount;
                ++this.position;
                if (this.position >= this.length) {
                    this.nextDescriptor();
                }
                return value;
            }

            @Override
            public void get(ByteBuffer dst) throws VirtIODeviceException, MemoryAccessException {
                if (this.isUsed) {
                    throw new IllegalStateException();
                }
                if (dst.remaining() > this.readableBytes()) {
                    throw new IndexOutOfBoundsException();
                }
                int limit = dst.limit();
                while (dst.position() < limit) {
                    assert (this.position < this.length);
                    int count = Math.min(this.length - this.position, limit - dst.position());
                    dst.limit(dst.position() + count);
                    MemoryMaps.load(AbstractVirtIODevice.this.memoryMap, this.address + (long)this.position, dst);
                    this.readByteCount += count;
                    this.position += count;
                    if (this.position < this.length) continue;
                    this.nextDescriptor();
                }
                assert (dst.position() == dst.limit());
            }

            @Override
            public void put(byte value) throws VirtIODeviceException, MemoryAccessException {
                if (this.isUsed) {
                    throw new IllegalStateException();
                }
                if (this.readableBytes() > 0) {
                    throw new IllegalStateException();
                }
                if (this.writableBytes() <= 0) {
                    throw new IndexOutOfBoundsException();
                }
                assert (this.position < this.length);
                AbstractVirtIODevice.this.memoryMap.store(this.address + (long)this.position, value, 0);
                ++this.writtenByteCount;
                ++this.position;
                if (this.position >= this.length) {
                    this.nextDescriptor();
                }
            }

            @Override
            public void put(ByteBuffer src) throws VirtIODeviceException, MemoryAccessException {
                if (this.isUsed) {
                    throw new IllegalStateException();
                }
                if (this.readableBytes() > 0) {
                    throw new IllegalStateException();
                }
                if (src.remaining() > this.writableBytes()) {
                    throw new IndexOutOfBoundsException();
                }
                int limit = src.limit();
                while (src.position() < limit) {
                    assert (this.position < this.length);
                    int count = Math.min(this.length - this.position, limit - src.position());
                    src.limit(src.position() + count);
                    MemoryMaps.store(AbstractVirtIODevice.this.memoryMap, this.address + (long)this.position, src);
                    this.writtenByteCount += count;
                    this.position += count;
                    if (this.position < this.length) continue;
                    this.nextDescriptor();
                }
                assert (src.limit() == limit);
                assert (src.position() == src.limit());
            }

            void setDescriptor(short descIdx) throws MemoryAccessException {
                this.descIdx = descIdx;
                this.address = SplitVirtqueue.this.getDescAddress(descIdx);
                this.length = SplitVirtqueue.this.getDescLength(descIdx);
                this.position = 0;
            }

            void nextDescriptor() throws VirtIODeviceException, MemoryAccessException {
                if (this.position < this.length) {
                    throw new IllegalStateException("Current descriptor must be used up before advancing to the next.");
                }
                if ((SplitVirtqueue.this.getDescFlags(this.descIdx) & 1) == 0) {
                    return;
                }
                if (this.chainLength >= 52) {
                    AbstractVirtIODevice.this.error();
                    throw new VirtIODeviceException();
                }
                this.setDescriptor(SplitVirtqueue.this.getDescNext(this.descIdx));
                ++this.chainLength;
                if ((SplitVirtqueue.this.getDescFlags(this.descIdx) & 2) == 0 && this.writtenByteCount > 0) {
                    AbstractVirtIODevice.this.error();
                    throw new VirtIODeviceException();
                }
            }
        }
    }

    @Serialized
    public static abstract class AbstractVirtqueue
    implements VirtqueueIterator {
        int ready;
        int num = 256;
        long desc;
        long driver;
        long device;
        boolean dispatchQueueNotifications = true;

        void reset() {
            this.ready = 0;
            this.num = 256;
            this.desc = 0L;
            this.driver = 0L;
            this.device = 0L;
        }

        abstract void handleQueueNotification(int var1) throws VirtIODeviceException, MemoryAccessException;
    }
}

